/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem;

import java.io.BufferedReader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.rm.core.rtsystem.AbstractRemoteCommandJob;
import org.eclipse.ptp.rm.core.rtsystem.AbstractToolRuntimeSystem;
import org.eclipse.ptp.rm.mpi.mpich2.core.MPICH2NodeAttributes;
import org.eclipse.ptp.rm.mpi.mpich2.core.MPICH2Plugin;
import org.eclipse.ptp.rm.mpi.mpich2.core.messages.Messages;
import org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem.MPICH2HostMap;
import org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem.MPICH2RuntimeSystem;
import org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem.MPICH2TraceParser;

public class MPICH2DiscoverJob
extends AbstractRemoteCommandJob {
    MPICH2RuntimeSystem rts;

    public MPICH2DiscoverJob(MPICH2RuntimeSystem rts) {
        super((AbstractToolRuntimeSystem)rts, NLS.bind((String)Messages.MPICH2DiscoverJob_name, (Object)rts.getRmConfiguration().getName()), rts.retrieveEffectiveToolRmConfiguration().getDiscoverCmd(), Messages.MPICH2DiscoverJob_interruptedErrorMessage, Messages.MPICH2DiscoverJob_processErrorMessage, Messages.MPICH2DiscoverJob_parsingErrorMessage);
        this.rts = rts;
    }

    protected void parse(BufferedReader output) throws CoreException {
        MPICH2TraceParser parser = new MPICH2TraceParser();
        if (!parser.parse(output)) {
            throw new CoreException((IStatus)new Status(4, MPICH2Plugin.getDefault().getBundle().getSymbolicName(), parser.getErrorMessage()));
        }
        int nodeCounter = 0;
        MPICH2HostMap.Host[] hostArray = parser.getHostMap().getHosts();
        int n = hostArray.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeManager attrManager;
            String nodeId;
            MPICH2HostMap.Host host;
            block5: {
                host = hostArray[n2];
                nodeId = this.rts.createNode(this.rts.getMachineId(), host.getName(), nodeCounter++);
                attrManager = new AttributeManager();
                if (host.getNumProcessors() != 0) {
                    try {
                        attrManager.addAttribute((IAttribute)MPICH2NodeAttributes.getNumberOfNodesAttributeDefinition().create(Integer.valueOf(host.getNumProcessors())));
                    }
                    catch (IllegalValueException illegalValueException) {
                        if ($assertionsDisabled) break block5;
                        throw new AssertionError();
                    }
                }
            }
            this.rts.changeNode(nodeId, attrManager);
            this.rts.setNodeIDForName(host.getName(), nodeId);
            ++n2;
        }
    }
}

