/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml_jaxb.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.rm.lml.core.JobStatusData;
import org.eclipse.ptp.rm.lml.internal.core.model.Row;
import org.eclipse.ptp.rm.lml.ui.views.TableView;
import org.eclipse.ptp.rm.lml_jaxb.actions.ActionUtils;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractConsoleAction
implements IObjectActionDelegate {
    protected boolean error;
    protected ISelection selection;
    protected JobStatusData status;
    protected TableView view;

    public void run(IAction action) {
        if (this.status != null) {
            String path = this.error ? this.status.getErrorPath() : this.status.getOutputPath();
            ActionUtils.readRemoteFile(this.status.getRmId(), path);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection.isEmpty()) {
            action.setEnabled(false);
            return;
        }
        if (((IStructuredSelection)selection).size() > 1) {
            action.setEnabled(false);
            return;
        }
        Row row = (Row)((IStructuredSelection)selection).getFirstElement();
        this.status = row.status;
        if (this.status == null) {
            action.setEnabled(false);
            return;
        }
        IResourceManager rm = PTPCorePlugin.getDefault().getModelManager().getResourceManagerFromUniqueName(this.status.getRmId());
        if (rm == null || !"STARTED".equals(rm.getState())) {
            action.setEnabled(false);
        } else if (this.getReady()) {
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.view = (TableView)targetPart;
    }

    protected String getPath() {
        if (this.error) {
            return this.status.getErrorPath();
        }
        return this.status.getOutputPath();
    }

    protected boolean getReady() {
        if (this.error) {
            return this.status.getErrReady();
        }
        return this.status.getOutReady();
    }
}

