/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.rse.core;

import java.io.File;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.ptp.internal.remote.rse.core.DStoreShellOutputReader;
import org.eclipse.rse.services.dstore.util.DStoreStatusMonitor;
import org.eclipse.rse.services.shells.AbstractHostShell;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellOutputReader;

public class DStoreHostShell
extends AbstractHostShell
implements IHostShell {
    private IHostShellOutputReader _stdoutHandler;
    private IHostShellOutputReader _stderrHandler;
    private DataElement _status;
    private DStoreStatusMonitor _statusMonitor;
    protected DataElement _sendInputDescriptor;
    private boolean _sentCharConversionCommand = false;
    private DataStore _dataStore;

    public DStoreHostShell(DStoreStatusMonitor statusMonitor, DataElement status, DataStore dataStore, String initialWorkingDirectory, String invocation, String encoding, String[] environment, boolean redirectStderr) {
        this._dataStore = dataStore;
        DataElement contextDir = dataStore.createObject(null, "directory", new File(initialWorkingDirectory).getName(), initialWorkingDirectory);
        dataStore.setObject(contextDir);
        this._status = status;
        if (redirectStderr) {
            this._stdoutHandler = new DStoreShellOutputReader(this, this._status, false);
            this._stderrHandler = null;
        } else {
            this._stdoutHandler = new org.eclipse.rse.internal.services.dstore.shells.DStoreShellOutputReader((IHostShell)this, this._status, false);
            this._stderrHandler = new org.eclipse.rse.internal.services.dstore.shells.DStoreShellOutputReader((IHostShell)this, this._status, true);
        }
        this._statusMonitor = statusMonitor;
    }

    public boolean isActive() {
        return !this._statusMonitor.determineStatusDone(this._status);
    }

    public void writeToShell(String command) {
        DataElement commandElement = this._status.getParent();
        DataStore dataStore = commandElement.getDataStore();
        if (command.equals("") || command.equals("#break")) {
            DataElement commandDescriptor;
            String cmd = command;
            if (cmd.equals("")) {
                cmd = "#enter";
            }
            if ((commandDescriptor = this.getSendInputDescriptor(commandElement)) != null) {
                DataElement in = dataStore.createObject(null, "input", cmd);
                dataStore.command(commandDescriptor, in, commandElement);
            }
        } else {
            String[] tokens = command.split("\n\r");
            int i = 0;
            while (i < tokens.length) {
                String cmd = tokens[i];
                if (cmd != null) {
                    DataElement commandDescriptor;
                    DataElement fsD = dataStore.findObjectDescriptor("directory");
                    DataElement convDes = dataStore.localDescriptorQuery(fsD, "C_CHAR_CONVERSION", 1);
                    if (convDes != null) {
                        if (!this._sentCharConversionCommand) {
                            dataStore.command(convDes, this._status);
                            this._sentCharConversionCommand = true;
                        }
                        cmd = this.convertSpecialCharacters(cmd);
                    }
                    if ((commandDescriptor = this.getSendInputDescriptor(commandElement)) != null) {
                        DataElement in = dataStore.createObject(null, "input", cmd);
                        dataStore.command(commandDescriptor, in, commandElement);
                    }
                }
                ++i;
            }
        }
    }

    private DataElement getSendInputDescriptor(DataElement remoteObject) {
        if (this._sendInputDescriptor == null || this._dataStore != remoteObject.getDataStore()) {
            this._sendInputDescriptor = this._dataStore.findCommandDescriptor("C_SEND_INPUT");
        }
        return this._sendInputDescriptor;
    }

    private String convertSpecialCharacters(String input) {
        StringBuffer output = new StringBuffer();
        int idx = 0;
        while (idx < input.length()) {
            char currChar = input.charAt(idx);
            switch (currChar) {
                case '&': {
                    output.append("&#38;");
                    break;
                }
                case ';': {
                    output.append("&#59;");
                    break;
                }
                default: {
                    output.append(currChar);
                }
            }
            ++idx;
        }
        return output.toString();
    }

    public IHostShellOutputReader getStandardOutputReader() {
        return this._stdoutHandler;
    }

    public IHostShellOutputReader getStandardErrorReader() {
        return this._stderrHandler;
    }

    public DataElement getStatus() {
        return this._status;
    }

    public void exit() {
        DataElement cmdDescriptor;
        DataElement command = this._status.getParent();
        DataStore dataStore = command.getDataStore();
        DataElement cancelDescriptor = dataStore.localDescriptorQuery(cmdDescriptor = command.getDescriptor(), "C_CANCEL");
        if (cancelDescriptor != null) {
            dataStore.command(cancelDescriptor, command);
        }
        this._status.setAttribute(3, "done");
        this._stdoutHandler.finish();
        this._stderrHandler.finish();
    }
}

