/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.views.locations;

import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.debug.core.model.IPDebugElement;
import org.eclipse.ptp.debug.internal.ui.actions.CreateLocationSetAction;
import org.eclipse.ptp.debug.internal.ui.views.AbstractPDebugViewEventHandler;
import org.eclipse.ptp.debug.internal.ui.views.locations.PLocationContentProvider;
import org.eclipse.ptp.debug.internal.ui.views.locations.PLocationLabelProvider;
import org.eclipse.ptp.debug.internal.ui.views.locations.PLocationViewEventHandler;
import org.eclipse.ptp.debug.internal.ui.views.locations.PLocationViewerSorter;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.debug.ui.UIDebugManager;
import org.eclipse.ptp.debug.ui.messages.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class PLocationView
extends AbstractDebugView
implements IDebugContextListener {
    private AbstractPDebugViewEventHandler eventHandler;
    private UIDebugManager uiManager = null;
    private TableViewer viewer = null;
    public static final String COLUMN_FUNCTION = Messages.PLocationView_0;
    public static final String COLUMN_FILE = Messages.PLocationView_1;
    public static final String COLUMN_LINE = Messages.PLocationView_2;
    public static final String COLUMN_PROCESSES = Messages.PLocationView_3;

    protected Viewer createViewer(Composite parent) {
        this.uiManager = PTPDebugUIPlugin.getUIDebugManager();
        DebugUITools.getDebugContextManager().addDebugContextListener((IDebugContextListener)this);
        this.viewer = new TableViewer(parent, 66306);
        Table table = this.viewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        int i = 0;
        while (i < 4) {
            new TableColumn(table, 0).setResizable(true);
            ++i;
        }
        TableColumn[] columns = table.getColumns();
        columns[0].setText(COLUMN_FILE);
        columns[1].setText(COLUMN_FUNCTION);
        columns[2].setText(COLUMN_LINE);
        columns[3].setText(COLUMN_PROCESSES);
        int i2 = 0;
        while (i2 < 4) {
            final int j = i2++;
            columns[j].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ((PLocationViewerSorter)PLocationView.this.viewer.getSorter()).setColumn(j);
                    PLocationView.this.refresh();
                }
            });
        }
        PixelConverter pc = new PixelConverter((Control)parent);
        columns[0].setWidth(pc.convertWidthInCharsToPixels(30));
        columns[1].setWidth(pc.convertWidthInCharsToPixels(30));
        columns[2].setWidth(pc.convertWidthInCharsToPixels(10));
        columns[3].setWidth(pc.convertWidthInCharsToPixels(10));
        this.viewer.setColumnProperties(new String[]{COLUMN_FUNCTION, COLUMN_FILE, COLUMN_LINE, COLUMN_PROCESSES});
        PLocationContentProvider contentProvider = new PLocationContentProvider();
        PLocationLabelProvider labelProvider = new PLocationLabelProvider();
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setSorter((ViewerSorter)new PLocationViewerSorter());
        this.viewer.setUseHashlookup(true);
        this.updateContext(DebugUITools.getDebugContext());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PLocationView.this.updateActionsEnable();
            }
        });
        this.setEventHandler(new PLocationViewEventHandler(this));
        return this.viewer;
    }

    public void dispose() {
        super.dispose();
        DebugUITools.getDebugContextManager().removeDebugContextListener((IDebugContextListener)this);
        if (this.getEventHandler() != null) {
            this.getEventHandler().dispose();
        }
    }

    public void debugContextChanged(DebugContextEvent event) {
        this.updateContext(event.getContext());
    }

    private void updateContext(Object context) {
        if (context instanceof IStructuredSelection) {
            IPLaunch launch;
            String jobId;
            Object selection = ((IStructuredSelection)context).getFirstElement();
            if (selection instanceof IPDebugElement) {
                this.setViewerContent(((IPDebugElement)selection).getSession());
            } else if (selection instanceof IPLaunch && (jobId = (launch = (IPLaunch)selection).getJobId()) != null) {
                IPSession session = PTPDebugCorePlugin.getDebugModel().getSession(jobId);
                this.setViewerContent(session);
            }
        }
    }

    public void setViewerContent(IPSession session) {
        if (this.viewer != null && this.viewer.getInput() != session) {
            this.viewer.setInput((Object)session);
        }
    }

    public UIDebugManager getUIManager() {
        return this.uiManager;
    }

    public void refresh() {
        this.viewer.refresh();
        this.updateActionsEnable();
    }

    public ISelection getSelection() {
        return this.viewer.getSelection();
    }

    protected void setEventHandler(AbstractPDebugViewEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    protected AbstractPDebugViewEventHandler getEventHandler() {
        return this.eventHandler;
    }

    protected void createActions() {
        this.setAction("org.eclipse.ptp.debug.ui.CreateLocationSetAction", (IAction)new CreateLocationSetAction(this));
        this.setAction("Double_Click_ActionId", this.getAction("org.eclipse.ptp.debug.ui.CreateLocationSetAction"));
        this.updateActionsEnable();
    }

    protected void configureToolBar(IToolBarManager toolBarMgr) {
        toolBarMgr.add(this.getAction("org.eclipse.ptp.debug.ui.CreateLocationSetAction"));
    }

    protected String getHelpContextId() {
        return null;
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("additions"));
        menu.add(this.getAction("org.eclipse.ptp.debug.ui.CreateLocationSetAction"));
        this.updateObjects();
    }

    private boolean isCurrentJobAvailable() {
        String cur_jid = this.uiManager.getCurrentJobId();
        return cur_jid != null && cur_jid.length() > 0;
    }

    public void updateActionsEnable() {
        this.getAction("org.eclipse.ptp.debug.ui.CreateLocationSetAction").setEnabled(!this.viewer.getSelection().isEmpty() && this.isCurrentJobAvailable());
    }
}

