/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.core.rtsystem;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.attributes.AttributeDefinitionManager;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.BooleanAttribute;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.elements.IPElement;
import org.eclipse.ptp.core.elements.IPResourceManager;
import org.eclipse.ptp.core.elements.attributes.ElementAttributeManager;
import org.eclipse.ptp.core.elements.attributes.ElementAttributes;
import org.eclipse.ptp.core.elements.attributes.ErrorAttributes;
import org.eclipse.ptp.core.elements.attributes.FilterAttributes;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.core.elements.attributes.MachineAttributes;
import org.eclipse.ptp.core.elements.attributes.MessageAttributes;
import org.eclipse.ptp.core.elements.attributes.NodeAttributes;
import org.eclipse.ptp.core.elements.attributes.ProcessAttributes;
import org.eclipse.ptp.core.elements.attributes.QueueAttributes;
import org.eclipse.ptp.core.elements.attributes.ResourceManagerAttributes;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionChangeEvent;
import org.eclipse.ptp.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.rm.core.MPIJobAttributes;
import org.eclipse.ptp.rm.core.RMCorePlugin;
import org.eclipse.ptp.rm.core.messages.Messages;
import org.eclipse.ptp.rm.core.rmsystem.AbstractEffectiveToolRMConfiguration;
import org.eclipse.ptp.rm.core.rmsystem.AbstractToolResourceManager;
import org.eclipse.ptp.rm.core.rmsystem.IToolRMConfiguration;
import org.eclipse.ptp.rm.core.rtsystem.AbstractRemoteCommandJob;
import org.eclipse.ptp.rm.core.rtsystem.IToolRuntimeSystemJob;
import org.eclipse.ptp.rm.core.utils.DebugUtil;
import org.eclipse.ptp.rtsystem.AbstractRuntimeSystem;
import org.eclipse.ptp.rtsystem.events.IRuntimeEventFactory;
import org.eclipse.ptp.rtsystem.events.IRuntimeJobChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeMachineChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNodeChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeProcessChangeEvent;
import org.eclipse.ptp.rtsystem.events.RuntimeEventFactory;
import org.eclipse.ptp.utils.core.ArgumentParser;
import org.eclipse.ptp.utils.core.RangeSet;
import org.eclipse.ui.progress.IProgressConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractToolRuntimeSystem
extends AbstractRuntimeSystem {
    private Job continousMonitorJob;
    private final IRuntimeEventFactory eventFactory = new RuntimeEventFactory();
    private int jobNumber;
    private Thread jobQueueThread = null;
    private final Map<String, Job> jobs = Collections.synchronizedMap(new HashMap());
    private int nextID;
    private Job periodicMonitorJob;
    private IProgressMonitor startupMonitor = null;
    private final AbstractToolResourceManager fResourceManager;
    private final IPResourceManager fPResourceManager;
    private final ConnectionChangeHandler fConnectionChangeHandler = new ConnectionChangeHandler();
    protected AttributeDefinitionManager attrMgr = new AttributeDefinitionManager();
    protected IRemoteConnection connection = null;
    protected LinkedBlockingQueue<Job> pendingJobQueue = new LinkedBlockingQueue();
    protected IRemoteServices remoteServices = null;

    protected static String[] getEnvironment(ILaunchConfiguration configuration) throws CoreException {
        Map defaultEnv = null;
        Map configEnv = configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, defaultEnv);
        if (configEnv == null) {
            return null;
        }
        if (!configuration.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true)) {
            throw new CoreException((IStatus)new Status(4, RMCorePlugin.getUniqueIdentifier(), Messages.AbstractToolRuntimeSystem_EnvNotSupported));
        }
        ArrayList<String> strings = new ArrayList<String>(configEnv.size());
        for (Map.Entry entry : configEnv.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            strings.add(String.valueOf(key) + "=" + value);
        }
        return strings.toArray(new String[strings.size()]);
    }

    public AbstractToolRuntimeSystem(AbstractToolResourceManager rm) {
        this.fResourceManager = rm;
        this.fPResourceManager = (IPResourceManager)this.getResourceManager().getAdapter(IPResourceManager.class);
        int id = 0;
        try {
            id = Integer.valueOf(this.fPResourceManager.getID());
        }
        catch (NumberFormatException numberFormatException) {}
        this.nextID = id + 1;
        this.jobNumber = 0;
    }

    public void changeJob(String jobID, AttributeManager changedAttrMgr) {
        AttributeManager attrMgr = new AttributeManager();
        attrMgr.addAttributes(changedAttrMgr.getAttributes());
        ElementAttributeManager elementAttrs = new ElementAttributeManager();
        elementAttrs.setAttributeManager(new RangeSet(jobID), attrMgr);
        IRuntimeJobChangeEvent event = this.eventFactory.newRuntimeJobChangeEvent(elementAttrs);
        this.fireRuntimeJobChangeEvent(event);
        IAttribute[] iAttributeArray = changedAttrMgr.getAttributes();
        int n = iAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute attr = iAttributeArray[n2];
            DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}, job #{1}: {2}={3}", this.getResourceManager().getConfiguration().getName(), jobID, attr.getDefinition().getId(), attr.getValueAsString());
            ++n2;
        }
    }

    public void changeMachine(String machineID, AttributeManager changedAttrMgr) {
        AttributeManager attrMgr = new AttributeManager();
        attrMgr.addAttributes(changedAttrMgr.getAttributes());
        ElementAttributeManager elementAttrs = new ElementAttributeManager();
        elementAttrs.setAttributeManager(new RangeSet(machineID), attrMgr);
        IRuntimeMachineChangeEvent event = this.eventFactory.newRuntimeMachineChangeEvent(elementAttrs);
        this.fireRuntimeMachineChangeEvent(event);
        IAttribute[] iAttributeArray = changedAttrMgr.getAttributes();
        int n = iAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute attr = iAttributeArray[n2];
            DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}, machine #{1}: {2}={3}", this.getResourceManager().getConfiguration().getName(), machineID, attr.getDefinition().getId(), attr.getValueAsString());
            ++n2;
        }
    }

    public void changeNode(String nodeID, AttributeManager changedAttrMgr) {
        AttributeManager attrMgr = new AttributeManager();
        attrMgr.addAttributes(changedAttrMgr.getAttributes());
        ElementAttributeManager elementAttrs = new ElementAttributeManager();
        elementAttrs.setAttributeManager(new RangeSet(nodeID), attrMgr);
        IRuntimeNodeChangeEvent event = this.eventFactory.newRuntimeNodeChangeEvent(elementAttrs);
        this.fireRuntimeNodeChangeEvent(event);
        IAttribute[] iAttributeArray = changedAttrMgr.getAttributes();
        int n = iAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute attr = iAttributeArray[n2];
            DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}, node #{1}: {2}={3}", this.getResourceManager().getConfiguration().getName(), nodeID, attr.getDefinition().getId(), attr.getValueAsString());
            ++n2;
        }
    }

    public void changeProcesses(String jobId, BitSet processJobRanks, AttributeManager changedAttrMgr) {
        AttributeManager attrMgr = new AttributeManager();
        attrMgr.addAttributes(changedAttrMgr.getAttributes());
        ElementAttributeManager elementAttrs = new ElementAttributeManager();
        elementAttrs.setAttributeManager(new RangeSet(processJobRanks), attrMgr);
        IRuntimeProcessChangeEvent event = this.eventFactory.newRuntimeProcessChangeEvent(jobId, elementAttrs);
        this.fireRuntimeProcessChangeEvent(event);
        IAttribute[] iAttributeArray = changedAttrMgr.getAttributes();
        int n = iAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute attr = iAttributeArray[n2];
            DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}, processes #{1}: {2}={3}", this.getResourceManager().getConfiguration().getName(), processJobRanks, attr.getDefinition().getId(), attr.getValueAsString());
            ++n2;
        }
    }

    public String createJob(String parentID, AttributeManager attrMgr) throws CoreException {
        ElementAttributeManager mgr = new ElementAttributeManager();
        AttributeManager jobAttrMgr = new AttributeManager();
        String jobID = this.generateID().toString();
        jobAttrMgr.addAttribute((IAttribute)JobAttributes.getJobIdAttributeDefinition().create(jobID));
        jobAttrMgr.addAttribute((IAttribute)JobAttributes.getStatusAttributeDefinition().create(MPIJobAttributes.Status.NORMAL.toString()));
        jobAttrMgr.addAttribute((IAttribute)JobAttributes.getUserIdAttributeDefinition().create(System.getenv("USER")));
        jobAttrMgr.addAttribute((IAttribute)ElementAttributes.getNameAttributeDefinition().create(this.generateJobName()));
        String subId = (String)this.getAttributeValue(JobAttributes.getSubIdAttributeDefinition(), attrMgr);
        String execName = (String)this.getAttributeValue(JobAttributes.getExecutableNameAttributeDefinition(), attrMgr);
        String execPath = (String)this.getAttributeValue(JobAttributes.getExecutablePathAttributeDefinition(), attrMgr);
        String workDir = (String)this.getAttributeValue(JobAttributes.getWorkingDirectoryAttributeDefinition(), attrMgr);
        Integer numProcs = (Integer)this.getAttributeValue(JobAttributes.getNumberOfProcessesAttributeDefinition(), attrMgr);
        List progArgs = (List)this.getAttributeValue(JobAttributes.getProgramArgumentsAttributeDefinition(), attrMgr);
        jobAttrMgr.addAttribute((IAttribute)JobAttributes.getSubIdAttributeDefinition().create(subId));
        jobAttrMgr.addAttribute((IAttribute)JobAttributes.getExecutableNameAttributeDefinition().create(execName));
        jobAttrMgr.addAttribute((IAttribute)JobAttributes.getExecutablePathAttributeDefinition().create(execPath));
        jobAttrMgr.addAttribute((IAttribute)JobAttributes.getWorkingDirectoryAttributeDefinition().create(workDir));
        try {
            jobAttrMgr.addAttribute((IAttribute)JobAttributes.getNumberOfProcessesAttributeDefinition().create(numProcs));
        }
        catch (IllegalValueException e) {
            RMCorePlugin.log(e);
        }
        jobAttrMgr.addAttribute((IAttribute)JobAttributes.getProgramArgumentsAttributeDefinition().create((Comparable[])progArgs.toArray(new String[0])));
        BooleanAttribute debugAttr = (BooleanAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getDebugFlagAttributeDefinition());
        if (debugAttr != null) {
            jobAttrMgr.addAttribute((IAttribute)JobAttributes.getDebugFlagAttributeDefinition().create(debugAttr.getValue()));
        }
        mgr.setAttributeManager(new RangeSet(jobID), jobAttrMgr);
        this.fireRuntimeNewJobEvent(this.eventFactory.newRuntimeNewJobEvent(parentID, mgr));
        DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: new job #{1}", this.getResourceManager().getConfiguration().getName(), jobID);
        return jobID;
    }

    public String createMachine(String name) {
        String id = this.generateID().toString();
        ElementAttributeManager mgr = new ElementAttributeManager();
        AttributeManager attrMgr = new AttributeManager();
        attrMgr.addAttribute((IAttribute)MachineAttributes.getStateAttributeDefinition().create((Enum)MachineAttributes.State.UP));
        attrMgr.addAttribute((IAttribute)ElementAttributes.getNameAttributeDefinition().create(name));
        mgr.setAttributeManager(new RangeSet(id), attrMgr);
        IPResourceManager rm = (IPResourceManager)this.getResourceManager().getAdapter(IPResourceManager.class);
        this.fireRuntimeNewMachineEvent(this.eventFactory.newRuntimeNewMachineEvent(rm.getID(), mgr));
        DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: new machine #{1}", this.getResourceManager().getConfiguration().getName(), id);
        return id;
    }

    public String createNode(String parentID, String name, int number) {
        AttributeManager attrMgr;
        ElementAttributeManager mgr;
        String id;
        block2: {
            id = this.generateID();
            mgr = new ElementAttributeManager();
            attrMgr = new AttributeManager();
            attrMgr.addAttribute((IAttribute)NodeAttributes.getStateAttributeDefinition().create((Enum)NodeAttributes.State.UP));
            try {
                attrMgr.addAttribute((IAttribute)NodeAttributes.getNumberAttributeDefinition().create(new Integer(number)));
            }
            catch (IllegalValueException e) {
                RMCorePlugin.log(e);
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        attrMgr.addAttribute((IAttribute)ElementAttributes.getNameAttributeDefinition().create(name));
        mgr.setAttributeManager(new RangeSet(id), attrMgr);
        this.fireRuntimeNewNodeEvent(this.eventFactory.newRuntimeNewNodeEvent(parentID, mgr));
        DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: new node #{1}", this.getResourceManager().getConfiguration().getName(), id);
        return id;
    }

    public void createProcess(String jobId, int index) {
        ElementAttributeManager mgr = new ElementAttributeManager();
        AttributeManager attrMgr = new AttributeManager();
        attrMgr.addAttribute((IAttribute)ProcessAttributes.getStateAttributeDefinition().create((Enum)ProcessAttributes.State.STARTING));
        mgr.setAttributeManager(new RangeSet(index), attrMgr);
        this.fireRuntimeNewProcessEvent(this.eventFactory.newRuntimeNewProcessEvent(jobId, mgr));
        DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: new process #{1}", this.getResourceManager().getConfiguration().getName(), Integer.toString(index));
    }

    public IRemoteProcessBuilder createProcessBuilder(List<String> command) {
        return this.remoteServices.getProcessBuilder(this.connection, command);
    }

    public IRemoteProcessBuilder createProcessBuilder(List<String> command, String workdir) {
        IRemoteFileManager fileManager = this.remoteServices.getFileManager(this.connection);
        IRemoteProcessBuilder processBuilder = this.remoteServices.getProcessBuilder(this.connection, command);
        if (fileManager != null) {
            processBuilder.directory(fileManager.getResource(workdir));
        }
        return processBuilder;
    }

    public void createProcesses(String jobId, int num) {
        int index = 0;
        while (index < num) {
            this.createProcess(jobId, index);
            ++index;
        }
        DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: created {1} new processes", this.getResourceManager().getConfiguration().getName(), num);
    }

    public String createQueue(String name) {
        String id = this.generateID();
        ElementAttributeManager mgr = new ElementAttributeManager();
        AttributeManager attrMgr = new AttributeManager();
        attrMgr.addAttribute((IAttribute)ElementAttributes.getNameAttributeDefinition().create(name));
        mgr.setAttributeManager(new RangeSet(id), attrMgr);
        IPResourceManager rm = (IPResourceManager)this.getResourceManager().getAdapter(IPResourceManager.class);
        this.fireRuntimeNewQueueEvent(this.eventFactory.newRuntimeNewQueueEvent(rm.getID(), mgr));
        DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: new queue #{1}", this.getResourceManager().getConfiguration().getName(), id);
        return id;
    }

    public void filterEvents(IPElement element, boolean filterChildren, AttributeManager filterAttributes) throws CoreException {
        this.doFilterEvents(element, filterChildren, filterAttributes);
    }

    public AttributeDefinitionManager getAttributeDefinitionManager() {
        return this.attrMgr;
    }

    public IRemoteConnection getConnection() {
        return this.connection;
    }

    public IRemoteServices getRemoteServices() {
        return this.remoteServices;
    }

    public AbstractToolResourceManager getResourceManager() {
        return this.fResourceManager;
    }

    public IToolRMConfiguration getRmConfiguration() {
        return (IToolRMConfiguration)this.getResourceManager().getConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void shutdown() throws CoreException {
        block15: {
            DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: shutdown", new Object[]{this.getResourceManager().getConfiguration().getName()});
            if (this.connection != null) {
                this.connection.removeConnectionChangeListener((IRemoteConnectionChangeListener)this.fConnectionChangeHandler);
            }
            try {
                this.stopEvents();
            }
            catch (CoreException e) {
                RMCorePlugin.log(e);
            }
            try {
                this.doShutdown();
            }
            finally {
                if (this.jobQueueThread == null) break block15;
                this.jobQueueThread.interrupt();
                ** for (job : this.pendingJobQueue)
            }
lbl-1000:
            // 1 sources

            {
                job.cancel();
                continue;
            }
        }
        iterator = this.jobs.values().iterator();
        while (iterator.hasNext()) {
            job = iterator.next();
            job.cancel();
            iterator.remove();
        }
        var3_4 = this;
        synchronized (var3_4) {
            if (this.startupMonitor != null) {
                this.startupMonitor.setCanceled(true);
            }
        }
        this.jobQueueThread = null;
        this.fireRuntimeShutdownStateEvent(this.eventFactory.newRuntimeShutdownStateEvent());
    }

    public void startEvents() throws CoreException {
        DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: start events", this.getResourceManager().getConfiguration().getName());
        if (this.periodicMonitorJob == null) {
            this.periodicMonitorJob = this.createPeriodicMonitorJob();
        }
        if (this.continousMonitorJob == null) {
            this.continousMonitorJob = this.createContinuousMonitorJob();
        }
        if (this.periodicMonitorJob != null) {
            this.periodicMonitorJob.schedule();
        }
        if (this.continousMonitorJob != null) {
            this.continousMonitorJob.schedule();
        }
        this.doStartEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startup(IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractToolRuntimeSystem abstractToolRuntimeSystem = this;
        synchronized (abstractToolRuntimeSystem) {
            this.startupMonitor = subMon;
        }
        this.initialize();
        subMon.subTask(Messages.AbstractToolRuntimeSystem_1);
        DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: startup", this.getResourceManager().getConfiguration().getName());
        try {
            block34: {
                block33: {
                    block32: {
                        this.remoteServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(this.getResourceManager().getControlConfiguration().getRemoteServicesId(), (IProgressMonitor)subMon.newChild(10));
                        if (this.remoteServices == null) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rm.core", Messages.AbstractToolRuntimeSystem_Exception_NoRemoteServices));
                        }
                        IRemoteConnectionManager connectionManager = this.remoteServices.getConnectionManager();
                        Assert.isNotNull((Object)connectionManager);
                        subMon.worked(10);
                        subMon.subTask(Messages.AbstractToolRuntimeSystem_2);
                        this.connection = connectionManager.getConnection(this.getResourceManager().getControlConfiguration().getConnectionName());
                        if (this.connection == null) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rm.core", Messages.AbstractToolRuntimeSystem_Exception_NoConnection));
                        }
                        if (!this.connection.isOpen()) {
                            try {
                                this.connection.open((IProgressMonitor)subMon.newChild(50));
                            }
                            catch (RemoteConnectionException e) {
                                throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rm.core", e.getMessage()));
                            }
                        }
                        if (!subMon.isCanceled()) break block32;
                        this.connection.close();
                        break block33;
                    }
                    try {
                        this.doStartup((IProgressMonitor)subMon.newChild(40));
                    }
                    catch (CoreException e) {
                        this.connection.close();
                        throw e;
                    }
                    if (!subMon.isCanceled()) break block34;
                    this.connection.close();
                }
                AbstractToolRuntimeSystem abstractToolRuntimeSystem2 = this;
                synchronized (abstractToolRuntimeSystem2) {
                    this.startupMonitor = null;
                }
                if (monitor != null) {
                    monitor.done();
                }
                return;
            }
            Job discoverJob = this.createDiscoverJob();
            if (discoverJob != null) {
                discoverJob.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, (Object)Boolean.TRUE);
                discoverJob.schedule();
                try {
                    discoverJob.join();
                }
                catch (InterruptedException interruptedException) {}
                IStatus status = discoverJob.getResult();
                if (!status.isOK()) {
                    throw new CoreException(status);
                }
            }
            if (this.jobQueueThread == null) {
                this.jobQueueThread = new Thread((Runnable)new JobRunner(), Messages.AbstractToolRuntimeSystem_JobQueueManagerThreadTitle);
                this.jobQueueThread.start();
            }
            this.connection.addConnectionChangeListener((IRemoteConnectionChangeListener)this.fConnectionChangeHandler);
            this.fireRuntimeRunningStateEvent(this.eventFactory.newRuntimeRunningStateEvent());
        }
        catch (Throwable throwable) {
            AbstractToolRuntimeSystem abstractToolRuntimeSystem3 = this;
            synchronized (abstractToolRuntimeSystem3) {
                this.startupMonitor = null;
            }
            if (monitor != null) {
                monitor.done();
            }
            throw throwable;
        }
        AbstractToolRuntimeSystem abstractToolRuntimeSystem4 = this;
        synchronized (abstractToolRuntimeSystem4) {
            this.startupMonitor = null;
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    public void stopEvents() throws CoreException {
        DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: stop events", this.getResourceManager().getConfiguration().getName());
        if (this.periodicMonitorJob != null) {
            this.periodicMonitorJob.cancel();
        }
        if (this.continousMonitorJob != null) {
            this.continousMonitorJob.cancel();
        }
        this.doStopEvents();
    }

    public void submitJob(String subId, ILaunchConfiguration configuration, String mode) throws CoreException {
        if (this.remoteServices == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rm.core", Messages.AbstractToolRuntimeSystem_Exception_ResourceManagerNotInitialized));
        }
        AttributeManager attrMgr = new AttributeManager(this.getAttributes(configuration, mode).toArray(new IAttribute[0]));
        attrMgr.addAttribute((IAttribute)JobAttributes.getSubIdAttributeDefinition().create(subId));
        String queueID = ((StringAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getQueueIdAttributeDefinition())).getValue();
        String jobID = this.createJob(queueID, attrMgr);
        attrMgr.addAttribute((IAttribute)JobAttributes.getJobIdAttributeDefinition().create(jobID));
        DebugUtil.trace(DebugUtil.JOB_TRACING, "RTS {0}: job submission #{0}, job id #{1}, queue id @{2}", this.getResourceManager().getConfiguration().getName(), subId, jobID, queueID);
        Job job = this.createRuntimeSystemJob(jobID, attrMgr);
        this.jobs.put(jobID, job);
        try {
            this.pendingJobQueue.put(job);
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rm.core", e.getMessage()));
        }
    }

    public void terminateJob(String jobId) throws CoreException {
        DebugUtil.trace(DebugUtil.JOB_TRACING, "RTS {0}: terminate job #{1}", this.getResourceManager().getConfiguration().getName(), jobId);
        Job job = this.jobs.get(jobId);
        this.pendingJobQueue.remove(job);
        job.cancel();
    }

    private <T, A extends IAttribute<T, A, D>, D extends IAttributeDefinition<T, A, D>> T getAttributeValue(D attrDef, AttributeManager attrMgr) throws CoreException {
        IAttribute attr = attrMgr.getAttribute(attrDef);
        if (attr == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rm.core", NLS.bind((String)Messages.AbstractToolRuntimeSystem_3, (Object)attrDef.getName())));
        }
        return (T)attr.getValue();
    }

    private void initialize() {
        this.attrMgr.clear();
        this.attrMgr.setAttributeDefinitions(ElementAttributes.getDefaultAttributeDefinitions());
        this.attrMgr.setAttributeDefinitions(ErrorAttributes.getDefaultAttributeDefinitions());
        this.attrMgr.setAttributeDefinitions(FilterAttributes.getDefaultAttributeDefinitions());
        this.attrMgr.setAttributeDefinitions(JobAttributes.getDefaultAttributeDefinitions());
        this.attrMgr.setAttributeDefinitions(MachineAttributes.getDefaultAttributeDefinitions());
        this.attrMgr.setAttributeDefinitions(MessageAttributes.getDefaultAttributeDefinitions());
        this.attrMgr.setAttributeDefinitions(NodeAttributes.getDefaultAttributeDefinitions());
        this.attrMgr.setAttributeDefinitions(ProcessAttributes.getDefaultAttributeDefinitions());
        this.attrMgr.setAttributeDefinitions(QueueAttributes.getDefaultAttributeDefinitions());
        this.attrMgr.setAttributeDefinitions(ResourceManagerAttributes.getDefaultAttributeDefinitions());
    }

    protected abstract Job createContinuousMonitorJob() throws CoreException;

    protected abstract Job createDiscoverJob() throws CoreException;

    protected abstract Job createPeriodicMonitorJob() throws CoreException;

    protected abstract Job createRuntimeSystemJob(String var1, AttributeManager var2) throws CoreException;

    protected abstract void doFilterEvents(IPElement var1, boolean var2, AttributeManager var3) throws CoreException;

    protected abstract void doShutdown() throws CoreException;

    protected abstract void doStartEvents() throws CoreException;

    protected abstract void doStartup(IProgressMonitor var1) throws CoreException;

    protected abstract void doStopEvents() throws CoreException;

    protected String generateID() {
        String id = Integer.toString(this.generateIntID());
        return id;
    }

    protected RangeSet generateIdRange(int count) {
        int start = this.nextID;
        this.nextID += count;
        return new RangeSet(start, this.nextID - 1);
    }

    protected int generateIntID() {
        int id = this.nextID++;
        return id;
    }

    protected String generateJobName() {
        return "job" + this.jobNumber++;
    }

    protected List<IAttribute<?, ?, ?>> getAttributes(ILaunchConfiguration configuration, String mode) throws CoreException {
        String[] envArr;
        String wd;
        ArrayList attrs = new ArrayList();
        String exePath = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_REMOTE_EXECUTABLE_PATH", null);
        if (exePath != null) {
            Path programPath = new Path(exePath);
            attrs.add((IAttribute<?, ?, ?>)JobAttributes.getExecutableNameAttributeDefinition().create(programPath.lastSegment()));
            String path = programPath.removeLastSegments(1).toString();
            if (path != null) {
                attrs.add((IAttribute<?, ?, ?>)JobAttributes.getExecutablePathAttributeDefinition().create(path));
            }
        }
        if ((wd = configuration.getAttribute("org.eclipse.ptp.launch.WORKING_DIR_ATTR", null)) == null && exePath != null) {
            wd = new Path(exePath).removeLastSegments(1).toString();
        }
        attrs.add((IAttribute<?, ?, ?>)JobAttributes.getWorkingDirectoryAttributeDefinition().create(wd));
        String[] args = this.getProgramArguments(configuration, "org.eclipse.ptp.launch.ARGUMENT_ATTR");
        if (args != null) {
            attrs.add((IAttribute<?, ?, ?>)JobAttributes.getProgramArgumentsAttributeDefinition().create((Comparable[])args));
        }
        if ((envArr = AbstractToolRuntimeSystem.getEnvironment(configuration)) != null) {
            attrs.add((IAttribute<?, ?, ?>)JobAttributes.getEnvironmentAttributeDefinition().create((Comparable[])envArr));
        }
        if (mode.equals("debug")) {
            String dbgExePath;
            boolean stopInMainFlag = configuration.getAttribute("org.eclipse.ptp.launch.STOP_IN_MAIN", false);
            attrs.add((IAttribute<?, ?, ?>)JobAttributes.getDebuggerStopInMainFlagAttributeDefinition().create(Boolean.valueOf(stopInMainFlag)));
            attrs.add((IAttribute<?, ?, ?>)JobAttributes.getDebugFlagAttributeDefinition().create(Boolean.TRUE));
            args = this.getProgramArguments(configuration, "org.eclipse.ptp.launch.DEBUGGER_ARGS");
            if (args != null) {
                attrs.add((IAttribute<?, ?, ?>)JobAttributes.getDebuggerArgumentsAttributeDefinition().create((Comparable[])args));
            }
            if ((dbgExePath = configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", null)) != null) {
                Path path = new Path(dbgExePath);
                attrs.add((IAttribute<?, ?, ?>)JobAttributes.getDebuggerExecutableNameAttributeDefinition().create(path.lastSegment()));
                attrs.add((IAttribute<?, ?, ?>)JobAttributes.getDebuggerExecutablePathAttributeDefinition().create(path.removeLastSegments(1).toString()));
            }
        }
        attrs.add((IAttribute<?, ?, ?>)JobAttributes.getLaunchedByPTPFlagAttributeDefinition().create(Boolean.valueOf(true)));
        return attrs;
    }

    protected String[] getProgramArguments(ILaunchConfiguration configuration, String attrName) throws CoreException {
        ArgumentParser ap;
        List args;
        String temp = configuration.getAttribute(attrName, null);
        if (temp != null && temp.length() > 0 && (args = (ap = new ArgumentParser(temp)).getTokenList()) != null) {
            return args.toArray(new String[args.size()]);
        }
        return new String[0];
    }

    protected void notifyMonitorFailed(AbstractRemoteCommandJob job, Exception exception) {
    }

    protected abstract AbstractEffectiveToolRMConfiguration retrieveEffectiveToolRmConfiguration();

    private class ConnectionChangeHandler
    implements IRemoteConnectionChangeListener {
        public void connectionChanged(IRemoteConnectionChangeEvent event) {
            if (event.getType() == 4 || event.getType() == 1) {
                try {
                    AbstractToolRuntimeSystem.this.getResourceManager().stop();
                }
                catch (CoreException e) {
                    RMCorePlugin.log(e);
                }
            }
        }
    }

    protected class JobRunner
    implements Runnable {
        protected JobRunner() {
        }

        public void run() {
            DebugUtil.trace(DebugUtil.JOB_TRACING, "RTS {0}: started job thread", AbstractToolRuntimeSystem.this.getResourceManager().getConfiguration().getName());
            try {
                while (AbstractToolRuntimeSystem.this.connection != null) {
                    Job job = AbstractToolRuntimeSystem.this.pendingJobQueue.take();
                    if (job instanceof IToolRuntimeSystemJob) {
                        DebugUtil.trace(DebugUtil.JOB_TRACING, "RTS {0}: schedule job #{1}", AbstractToolRuntimeSystem.this.getResourceManager().getConfiguration().getName(), ((IToolRuntimeSystemJob)job).getJobID());
                    } else {
                        DebugUtil.trace(DebugUtil.JOB_TRACING, "RTS {0}: schedule job #{1}", AbstractToolRuntimeSystem.this.getResourceManager().getConfiguration().getName(), job.getName());
                    }
                    job.schedule();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                DebugUtil.error(DebugUtil.JOB_TRACING, "RTS {0}: {1}", AbstractToolRuntimeSystem.this.getResourceManager().getConfiguration().getName(), e);
                RMCorePlugin.log(e);
            }
            DebugUtil.trace(DebugUtil.JOB_TRACING, "RTS {0}: terminated job thread", AbstractToolRuntimeSystem.this.getResourceManager().getConfiguration().getName());
        }
    }
}

