/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.core;

import java.util.NoSuchElementException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.rdt.sync.core.ResourceMatcher;
import org.eclipse.ptp.rdt.sync.core.messages.Messages;
import org.eclipse.ui.IMemento;

public class PathResourceMatcher
extends ResourceMatcher {
    private static final String ATTR_PATH = "path";
    IPath path;

    public PathResourceMatcher(IPath p) {
        this.path = p == null ? new Path("") : p;
    }

    public boolean match(IResource candidate) {
        if (candidate == null) {
            return false;
        }
        return this.path.isPrefixOf(candidate.getProjectRelativePath());
    }

    public String toString() {
        return this.path.toOSString();
    }

    public int hashCode() {
        return this.path.toOSString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PathResourceMatcher)) {
            return false;
        }
        PathResourceMatcher other = (PathResourceMatcher)obj;
        return this.path.toOSString().equals(other.path.toOSString());
    }

    public void saveMatcher(IMemento memento) {
        super.saveMatcher(memento);
        memento.putString(ATTR_PATH, this.path.toPortableString());
    }

    public static ResourceMatcher loadMatcher(IMemento memento) throws NoSuchElementException {
        String p = memento.getString(ATTR_PATH);
        if (p == null) {
            throw new NoSuchElementException(Messages.PathResourceMatcher_0);
        }
        return new PathResourceMatcher(Path.fromPortableString((String)p));
    }
}

