/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.utils.verification;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.remotetools.utils.verification.IllegalAttributeException;
import org.eclipse.ptp.remotetools.utils.verification.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlAttributes
implements Cloneable {
    private final Map<String, String> currentMap;
    private final Map<String, String> defaultMap = new HashMap<String, String>();

    public ControlAttributes(Map<String, String> config) {
        this.currentMap = config;
    }

    public ControlAttributes() {
        this.currentMap = new HashMap<String, String>();
    }

    public Map<String, String> getAttributesAsMap() {
        return Collections.unmodifiableMap(this.currentMap);
    }

    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(this.currentMap.keySet());
        keys.addAll(this.defaultMap.keySet());
        return keys;
    }

    private String getCurrent(String attributeName) {
        return this.currentMap.get(attributeName);
    }

    private String getDefault(String attributeName) {
        return this.defaultMap.get(attributeName);
    }

    public Object clone() throws CloneNotSupportedException {
        ControlAttributes newObject = new ControlAttributes();
        newObject.currentMap.putAll(this.currentMap);
        newObject.defaultMap.putAll(this.defaultMap);
        return newObject;
    }

    private String getAttributeOrDefault(String attributeName) {
        String value = this.getCurrent(attributeName);
        if (value == null) {
            return this.getDefault(attributeName);
        }
        return value;
    }

    public String getString(String attributeKey) {
        return this.getString(attributeKey, "");
    }

    public String getString(String attributeKey, String defaultValue) {
        String stringValue = this.getAttributeOrDefault(attributeKey);
        if (stringValue == null) {
            return defaultValue;
        }
        return stringValue;
    }

    public String getText(String attributeKey) {
        return this.getText(attributeKey, "");
    }

    public String getText(String attributeKey, String defaultValue) {
        String textValue = this.getAttributeOrDefault(attributeKey);
        if (textValue == null) {
            textValue = defaultValue;
        }
        textValue = textValue.replaceAll("\\n", "\n");
        textValue = textValue.replaceAll("\\\\", "\\");
        return textValue;
    }

    public boolean getBoolean(String attributeKey) {
        return this.getBoolean(attributeKey, false);
    }

    public boolean getBoolean(String attributeKey, boolean defaultValue) {
        String string = this.getAttributeOrDefault(attributeKey);
        if (string == null) {
            return defaultValue;
        }
        return Boolean.valueOf(string);
    }

    public int getInt(String attributeKey) {
        return this.getInt(attributeKey, 0);
    }

    public int getInt(String attributeKey, int defaultValue) {
        String string = this.getAttributeOrDefault(attributeKey);
        if (string == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                string = this.getDefault(attributeKey);
                if (string == null) {
                    return defaultValue;
                }
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException2) {
                return defaultValue;
            }
        }
    }

    public double getDouble(String attributeKey) {
        return this.getDouble(attributeKey, 0.0);
    }

    public double getDouble(String attributeKey, double defaultValue) {
        String string = this.getAttributeOrDefault(attributeKey);
        if (string == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                string = this.getDefault(attributeKey);
                if (string == null) {
                    return defaultValue;
                }
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException2) {
                return defaultValue;
            }
        }
    }

    public int verifyInt(String attributeName, String attributeKey) throws IllegalAttributeException {
        String stringValue = this.verifyString(attributeName, attributeKey);
        try {
            return Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalAttributeException(e, attributeName, Messages.ControlAttributes_InvalidIntegerNumber, stringValue);
        }
    }

    public double verifyDouble(String attributeName, String attributeKey) throws IllegalAttributeException {
        String stringValue = this.verifyString(attributeName, attributeKey);
        try {
            return Double.parseDouble(stringValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalAttributeException(e, attributeName, Messages.ControlAttributes_InvalidDecimalNumber, stringValue);
        }
    }

    public IPath verifyPath(String attributeName, String attributeKey) throws IllegalAttributeException {
        Path path = new Path("");
        String stringValue = this.verifyString(attributeName, attributeKey);
        if (!path.isValidPath(stringValue)) {
            throw new IllegalAttributeException(attributeName, Messages.ControlAttributes_InvalidPath, stringValue);
        }
        return new Path(stringValue);
    }

    public String verifyString(String attributeName, String attributeKey) throws IllegalAttributeException {
        String stringValue = this.getAttributeOrDefault(attributeKey);
        if (stringValue == null) {
            throw new IllegalAttributeException(attributeName, Messages.ControlAttributes_MustNotBeEmpty);
        }
        return stringValue;
    }

    public void setAttribute(String attributeKey, String value) {
        this.currentMap.put(attributeKey, value);
    }

    public void setString(String attributeKey, String value) {
        this.setAttribute(attributeKey, value);
    }

    public void setInt(String attributeKey, int value) {
        this.setAttribute(attributeKey, Integer.toString(value));
    }

    public void setDouble(String attributeKey, double value) {
        this.setAttribute(attributeKey, Double.toString(value));
    }

    public void setBoolean(String attributeKey, boolean value) {
        this.setAttribute(attributeKey, Boolean.toString(value));
    }

    public void setText(String attributeKey, String value) {
        String textValue = value;
        textValue = textValue.replaceAll("\\", "\\\\");
        textValue = textValue.replaceAll("\n", "\\n");
        this.setAttribute(attributeKey, textValue);
    }

    private void setDefaultAttribute(String attributeKey, String value) {
        this.defaultMap.put(attributeKey, value);
    }

    public void setDefaultString(String attributeKey, String value) {
        this.setDefaultAttribute(attributeKey, value);
    }

    public void setDefaultInt(String attributeKey, int value) {
        this.setDefaultAttribute(attributeKey, Integer.toString(value));
    }

    public void setDefaultDouble(String attributeKey, double value) {
        this.setDefaultAttribute(attributeKey, Double.toString(value));
    }

    public void setDefaultBoolean(String attributeKey, boolean value) {
        this.setDefaultAttribute(attributeKey, Boolean.toString(value));
    }

    public void setDefaultText(String attributeKey, String value) {
        String textValue = value;
        textValue = textValue.replaceAll("\\", "\\\\");
        textValue = textValue.replaceAll("\n", "\\n");
        this.setDefaultAttribute(attributeKey, textValue);
    }
}

