/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.ui.util;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.rm.jaxb.core.JAXBInitializationUtils;
import org.eclipse.ptp.rm.jaxb.ui.JAXBUIConstants;
import org.eclipse.ptp.rm.jaxb.ui.JAXBUIPlugin;
import org.eclipse.ptp.rm.jaxb.ui.messages.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBExtensionUtils {
    private static final FilenameFilter xmlFilter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            File f = new File(dir, name);
            return name.endsWith(".xml") && f.isFile();
        }
    };

    private JAXBExtensionUtils() {
    }

    public static void loadExtensions(Map<String, URL> resourceManagers) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.ptp.rm.jaxb.core.JAXBResourceManagerConfigurations");
        if (extensionPoint != null) {
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    URL url;
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    ce.getAttribute("id");
                    String name = ce.getAttribute("name");
                    String configurationFile = ce.getAttribute("configurationFile");
                    String bundleId = ce.getDeclaringExtension().getContributor().getName();
                    Bundle bundle = Platform.getBundle((String)bundleId);
                    if (bundle != null && (url = bundle.getEntry(configurationFile)) != null) {
                        resourceManagers.put(name, url);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public static void loadJAXBResourceManagers(Map<String, URL> resourceManagers, boolean showError) {
        JAXBExtensionUtils.loadExtensions(resourceManagers);
        JAXBExtensionUtils.loadExternal(resourceManagers, showError);
    }

    private static void loadExternal(Map<String, URL> resourceManagers, boolean showError) {
        IPath path;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("resourceManagers");
        StringBuffer invalid = new StringBuffer();
        if (project != null && (path = project.getLocation()) != null) {
            File[] custom;
            File dir = path.toFile();
            File[] fileArray = custom = dir.listFiles(xmlFilter);
            int n = custom.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    File rm = fileArray[n2];
                    try {
                        String name = rm.getName();
                        name = name.substring(0, name.length() - 4);
                        URI uri = rm.toURI();
                        URL url = uri.toURL();
                        try {
                            JAXBInitializationUtils.validate((URL)url);
                        }
                        catch (Throwable t) {
                            invalid.append(JAXBUIConstants.LINE_SEP).append(name);
                            JAXBUIPlugin.log(t.getMessage());
                            break block7;
                        }
                        resourceManagers.put(name, url);
                    }
                    catch (MalformedURLException t) {
                        JAXBUIPlugin.log(t);
                    }
                }
                ++n2;
            }
        }
        if (showError && invalid.length() > 0) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.InvalidConfiguration_title, (String)(String.valueOf(Messages.InvalidConfiguration) + invalid.toString()));
        }
    }
}

