/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.photran.internal.core.analysis.binding.VariableAccess;
import org.eclipse.photran.internal.core.analysis.types.Type;
import org.eclipse.photran.internal.core.analysis.types.TypeProcessor;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.core.vpg.PhotranVPGSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionType
extends Type {
    private static final long serialVersionUID = 1L;
    private String name;
    private Type returnType = Type.UNKNOWN;
    private List<String> argumentNames = new LinkedList<String>();
    private List<Type> argumentTypes = new LinkedList<Type>();
    private List<VariableAccess> argumentIntents = new LinkedList<VariableAccess>();

    public FunctionType(String name) {
        this.name = name.toLowerCase();
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public Type getArgumentType(int argument) {
        if (argument < 0 || argument >= this.argumentIntents.size()) {
            return Type.TYPE_ERROR;
        }
        return this.argumentTypes.get(argument);
    }

    public Type getArgumentType(String argName) {
        return this.getArgumentType(this.argumentNames.indexOf(PhotranVPG.canonicalizeIdentifier(argName)));
    }

    public VariableAccess getArgumentAccess(int argument) {
        if (argument < 0 || argument >= this.argumentIntents.size()) {
            return VariableAccess.RW;
        }
        return this.argumentIntents.get(argument);
    }

    public VariableAccess getArgumentAccess(String argName) {
        return this.getArgumentAccess(this.argumentNames.indexOf(PhotranVPG.canonicalizeIdentifier(argName)));
    }

    public void setReturnType(Type type) {
        this.returnType = type;
    }

    public void addArgument(String name, Type type, VariableAccess intent) {
        if (name == null) {
            name = "";
        }
        if (type == null) {
            type = Type.UNKNOWN;
        }
        if (intent == null) {
            intent = VariableAccess.RW;
        }
        this.argumentNames.add(PhotranVPG.canonicalizeIdentifier(name));
        this.argumentTypes.add(type);
        this.argumentIntents.add(intent);
    }

    @Override
    public String toString() {
        return "function(" + this.name + "): " + this.argumentTypes + " -> " + this.returnType;
    }

    @Override
    public <T> T processUsing(TypeProcessor<T> p) {
        return p.ifFunctionType(this.name, this);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof FunctionType && ((FunctionType)other).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static String getStaticThreeLetterTypeSerializationCode() {
        return "fun";
    }

    @Override
    public String getThreeLetterTypeSerializationCode() {
        return "fun";
    }

    @Override
    void finishWriteTo(OutputStream out) throws IOException {
        PhotranVPGSerializer.serialize(this.name, out);
        PhotranVPGSerializer.serialize(this.returnType, out);
        int args = this.argumentTypes.size();
        PhotranVPGSerializer.serialize(args, out);
        int i = 0;
        while (i < args) {
            PhotranVPGSerializer.serialize(this.argumentNames.get(i), out);
            PhotranVPGSerializer.serialize(this.argumentTypes.get(i), out);
            PhotranVPGSerializer.serialize(this.argumentIntents.get(i), out);
            ++i;
        }
    }

    public static Type finishReadFrom(InputStream in) throws IOException {
        String name = (String)PhotranVPGSerializer.deserialize(in);
        FunctionType result = new FunctionType(name);
        result.returnType = (Type)PhotranVPGSerializer.deserialize(in);
        int args = (Integer)PhotranVPGSerializer.deserialize(in);
        int i = 0;
        while (i < args) {
            result.argumentNames.add((String)PhotranVPGSerializer.deserialize(in));
            result.argumentTypes.add((Type)PhotranVPGSerializer.deserialize(in));
            result.argumentIntents.add((VariableAccess)PhotranVPGSerializer.deserialize(in));
            ++i;
        }
        return result;
    }
}

