/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.reindenter;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTAssociateStmtNode;
import org.eclipse.photran.internal.core.parser.ASTBlockDataStmtNode;
import org.eclipse.photran.internal.core.parser.ASTBlockStmtNode;
import org.eclipse.photran.internal.core.parser.ASTCaseConstructNode;
import org.eclipse.photran.internal.core.parser.ASTCaseStmtNode;
import org.eclipse.photran.internal.core.parser.ASTContainsStmtNode;
import org.eclipse.photran.internal.core.parser.ASTContinueStmtNode;
import org.eclipse.photran.internal.core.parser.ASTDerivedTypeStmtNode;
import org.eclipse.photran.internal.core.parser.ASTDoConstructNode;
import org.eclipse.photran.internal.core.parser.ASTElseIfStmtNode;
import org.eclipse.photran.internal.core.parser.ASTElseStmtNode;
import org.eclipse.photran.internal.core.parser.ASTElseWhereStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndDoStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEndSelectStmtNode;
import org.eclipse.photran.internal.core.parser.ASTForallConstructStmtNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionStmtNode;
import org.eclipse.photran.internal.core.parser.ASTIfThenStmtNode;
import org.eclipse.photran.internal.core.parser.ASTInterfaceStmtNode;
import org.eclipse.photran.internal.core.parser.ASTLabelDoStmtNode;
import org.eclipse.photran.internal.core.parser.ASTModuleStmtNode;
import org.eclipse.photran.internal.core.parser.ASTProgramStmtNode;
import org.eclipse.photran.internal.core.parser.ASTSelectCaseStmtNode;
import org.eclipse.photran.internal.core.parser.ASTSelectTypeStmtNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineStmtNode;
import org.eclipse.photran.internal.core.parser.ASTVisitor;
import org.eclipse.photran.internal.core.parser.ASTWhereConstructStmtNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IActionStmt;
import org.eclipse.photran.internal.core.reindenter.Reindenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StartOfLine {
    private final Token label;
    private final Token firstStmtToken;

    public static StartOfLine createForLine(int line, IFortranAST ast) {
        return StartOfLine.createForLineStartingWith(ast.findFirstTokenOnLine(line));
    }

    public static StartOfLine createForFirstNonemptyLineBelow(Token token, IFortranAST ast) {
        return StartOfLine.createForFirstNonemptyLineBelow(token.getLine(), ast);
    }

    public static StartOfLine createForFirstNonemptyLineBelow(int startLine, IFortranAST ast) {
        Token previousToken = null;
        for (Token tok : ast) {
            if (tok.getLine() > startLine && (previousToken == null || previousToken.getLine() <= startLine)) {
                return StartOfLine.createForLineStartingWith(tok);
            }
            previousToken = tok;
        }
        return null;
    }

    public static StartOfLine createForLastNonemptyLineAbove(StartOfLine line, IFortranAST ast) {
        return StartOfLine.createForLastNonemptyLineAbove(line.getFirstTokenOnLine().getLine(), ast);
    }

    private static StartOfLine createForLastNonemptyLineAbove(int startLine, IFortranAST ast) {
        int line = startLine - 1;
        while (line >= 0) {
            Token firstBlockOnLine = ast.findFirstTokenOnLine(line);
            if (firstBlockOnLine != null) {
                return StartOfLine.createForLineStartingWith(firstBlockOnLine);
            }
            --line;
        }
        return null;
    }

    public static StartOfLine createForLineStartingWith(Token token) {
        if (token == null) {
            return null;
        }
        if (StartOfLine.isLabel(token)) {
            return new StartOfLine(token, StartOfLine.getTokenFollowingLabel(token));
        }
        return new StartOfLine(null, token);
    }

    private static Token getTokenFollowingLabel(Token label) {
        assert (StartOfLine.isLabel(label));
        class V
        extends ASTVisitor {
            private Token lastToken = null;
            private Token tokenFollowingLabel = null;
            private final /* synthetic */ Token val$label;

            V(Token token) {
                this.val$label = token;
            }

            public void visitToken(Token token) {
                if (this.lastToken == this.val$label) {
                    this.tokenFollowingLabel = token;
                }
                this.lastToken = token;
            }
        }
        V v = new V(label);
        label.getParent().accept(v);
        return v.tokenFollowingLabel;
    }

    private static boolean isLabel(Token token) {
        return token != null && token.getParent() != null && token.getParent() instanceof IActionStmt && ((IActionStmt)token.getParent()).getLabel() == token;
    }

    private StartOfLine(Token label, Token firstStmtToken) {
        this.label = label;
        this.firstStmtToken = firstStmtToken;
    }

    private String getComments() {
        Token token = this.getFirstTokenOnLine();
        String whiteText = token.getWhiteBefore();
        int lastCR = whiteText.lastIndexOf(10);
        if (lastCR >= 0) {
            return whiteText.substring(0, lastCR + 1);
        }
        return "";
    }

    public void reindent(String removeIndent, String addIndent) {
        this.reindentComments(removeIndent, addIndent);
        this.reindentStatement(removeIndent, addIndent);
    }

    private void reindentComments(String removeIndent, String addIndent) {
        StringBuilder sb = new StringBuilder();
        for (String line : this.splitLines(this.getComments())) {
            sb.append(this.reindentCommentLine(line, removeIndent, addIndent));
        }
        String reindentedComments = sb.toString();
        this.getFirstTokenOnLine().setWhiteBefore(String.valueOf(reindentedComments) + this.getIndentation());
    }

    private ArrayList<String> splitLines(String comments) {
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        int end = comments.indexOf(10, start);
        while (end >= start) {
            result.add(comments.substring(start, end + 1));
            start = end + 1;
            end = comments.indexOf(10, start);
        }
        if (comments.length() > start) {
            result.add(comments.substring(start, comments.length()));
        }
        return result;
    }

    private String reindentCommentLine(String line, String removeIndent, String addIndent) {
        if (!line.trim().startsWith("!")) {
            return line;
        }
        int endIndex = 0;
        while (endIndex < line.length() && (line.charAt(endIndex) == ' ' || line.charAt(endIndex) == '\t')) {
            ++endIndex;
        }
        String indentation = line.substring(0, endIndex);
        String comment = line.substring(endIndex);
        return String.valueOf(this.newIndentation(indentation, removeIndent, addIndent)) + comment;
    }

    private void reindentStatement(String removeIndent, String addIndent) {
        this.setIndentation(this.newIndentation(this.getIndentation(), removeIndent, addIndent));
    }

    public void setIndentation(String newIndentation) {
        this.getFirstTokenOnLine().setWhiteBefore(String.valueOf(this.getComments()) + newIndentation);
        if (this.label != null) {
            this.label.setWhiteBefore(this.getComments());
            int start = this.label.getText().length();
            int end = newIndentation.length();
            if (start < end) {
                this.firstStmtToken.setWhiteBefore(newIndentation.substring(start, end));
            } else {
                this.firstStmtToken.setWhiteBefore(" ");
            }
        }
    }

    private String newIndentation(String currentIndentation, String removeIndent, String addIndent) {
        String newIndentation = removeIndent.length() > currentIndentation.length() ? "" : (currentIndentation.startsWith(removeIndent) ? currentIndentation.substring(removeIndent.length()) : currentIndentation);
        newIndentation = String.valueOf(newIndentation) + addIndent;
        return newIndentation;
    }

    public String getIndentation() {
        int lastCR;
        String whiteText = this.getFirstTokenOnLine().getWhiteBefore();
        String result = whiteText.substring((lastCR = whiteText.lastIndexOf(10)) + 1);
        if (result.equals("") && this.getFirstTokenOnLine() == this.label) {
            whiteText = String.valueOf(this.spaces(this.label.getText().length())) + this.firstStmtToken.getWhiteBefore();
            lastCR = whiteText.lastIndexOf(10);
            result = whiteText.substring(lastCR + 1);
        }
        return result;
    }

    private String spaces(int count) {
        StringBuilder sb = new StringBuilder(count);
        int i = 0;
        while (i < count) {
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    public Token getFirstTokenOnLine() {
        if (this.label != null) {
            return this.label;
        }
        return this.firstStmtToken;
    }

    public boolean startsIndentedRegion() {
        return this.starts(ASTProgramStmtNode.class) || this.starts(ASTFunctionStmtNode.class) || this.starts(ASTSubroutineStmtNode.class) || this.starts(ASTModuleStmtNode.class) || this.starts(ASTBlockStmtNode.class) || this.starts(ASTBlockDataStmtNode.class) || this.starts(ASTForallConstructStmtNode.class) || this.starts(ASTWhereConstructStmtNode.class) || this.starts(ASTDerivedTypeStmtNode.class) || this.starts(ASTIfThenStmtNode.class) || this.starts(ASTElseStmtNode.class) || this.starts(ASTElseWhereStmtNode.class) || this.starts(ASTElseIfStmtNode.class) || this.starts(ASTSelectCaseStmtNode.class) || this.starts(ASTSelectTypeStmtNode.class) || this.starts(ASTCaseStmtNode.class) || this.starts(ASTDoConstructNode.class) || this.starts(ASTLabelDoStmtNode.class) || this.starts(ASTInterfaceStmtNode.class) || this.starts(ASTContainsStmtNode.class) || this.starts(ASTAssociateStmtNode.class);
    }

    private boolean starts(Class<? extends IASTNode> nodeClass) {
        return this.firstStmtToken.findNearestAncestor(nodeClass) != null;
    }

    public boolean endsIndentedRegion() {
        Terminal t = this.firstStmtToken.getTerminal();
        return t == Terminal.T_CASE && !this.isFirstCaseStmtInSelectConstruct() || t == Terminal.T_CONTAINS || t == Terminal.T_CONTINUE || t == Terminal.T_END || t == Terminal.T_ENDBEFORESELECT || t == Terminal.T_ENDBLOCK || t == Terminal.T_ENDBLOCKDATA || t == Terminal.T_ENDDO || t == Terminal.T_ENDFILE || t == Terminal.T_ENDFORALL || t == Terminal.T_ENDFUNCTION || t == Terminal.T_ENDIF || t == Terminal.T_ENDINTERFACE || t == Terminal.T_ENDMODULE || t == Terminal.T_ENDPROGRAM || t == Terminal.T_ENDSELECT || t == Terminal.T_ENDSUBROUTINE || t == Terminal.T_ENDTYPE || t == Terminal.T_ENDWHERE || t == Terminal.T_ELSE || t == Terminal.T_ELSEWHERE || t == Terminal.T_ELSEIF;
    }

    public boolean endsDoublyIndentedRegion() {
        return this.firstStmtToken.findNearestAncestor(ASTEndSelectStmtNode.class) != null;
    }

    private boolean isFirstCaseStmtInSelectConstruct() {
        ASTCaseConstructNode selectConstruct = this.firstStmtToken.findNearestAncestor(ASTCaseConstructNode.class);
        if (selectConstruct == null) {
            return false;
        }
        ASTCaseStmtNode firstCaseStmt = selectConstruct.getSelectCaseBody().findFirst(ASTCaseStmtNode.class);
        if (firstCaseStmt == null) {
            return false;
        }
        return this.firstStmtToken.findNearestAncestor(ASTCaseStmtNode.class) == firstCaseStmt;
    }

    public String toString() {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        if (this.label != null) {
            this.label.printOn(out, null);
        }
        this.firstStmtToken.printOn(out, null);
        return bytes.toString();
    }

    public String getIncreasedIndentation() {
        return StartOfLine.getIncreasedIndentation(this.getIndentation());
    }

    public static String getIncreasedIndentation(String currentIndentation) {
        return String.valueOf(currentIndentation) + Reindenter.defaultIndentation();
    }

    public String getDecreasedIndentation() {
        return StartOfLine.getDecreasedIndentation(this.getIndentation());
    }

    public static String getDecreasedIndentation(String indentation) {
        if (indentation.endsWith(Reindenter.defaultIndentation())) {
            return indentation.substring(0, indentation.length() - Reindenter.defaultIndentation().length());
        }
        if (indentation.endsWith("\t")) {
            return indentation.substring(0, indentation.length() - 1);
        }
        return indentation;
    }

    public boolean hasLabel() {
        return this.label != null;
    }

    public boolean isContinuationLine() {
        String whiteText = this.firstStmtToken.getWhiteBefore();
        if (whiteText.indexOf(33) >= 0) {
            whiteText = whiteText.substring(0, whiteText.indexOf(33));
        }
        return whiteText.indexOf(38) >= 0;
    }

    public boolean isEndDoStmt() {
        return this.firstStmtToken.findNearestAncestor(ASTEndDoStmtNode.class) != null;
    }

    public boolean isContinueStmt() {
        return this.firstStmtToken.findNearestAncestor(ASTContinueStmtNode.class) != null;
    }
}

