/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.vpg;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.FortranCorePlugin;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.analysis.types.Type;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTErrorConstructNode;
import org.eclipse.photran.internal.core.parser.ASTErrorProgramUnitNode;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.ASTExternalNameListNode;
import org.eclipse.photran.internal.core.parser.ASTExternalStmtNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionStmtNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTModuleStmtNode;
import org.eclipse.photran.internal.core.parser.ASTNodeWithErrorRecoverySymbols;
import org.eclipse.photran.internal.core.parser.ASTSubroutineStmtNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTVisitor;
import org.eclipse.photran.internal.core.parser.GenericASTVisitor;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IProgramUnit;
import org.eclipse.photran.internal.core.preferences.FortranPreferences;
import org.eclipse.photran.internal.core.properties.SearchPathProperties;
import org.eclipse.photran.internal.core.vpg.AnnotationType;
import org.eclipse.photran.internal.core.vpg.EdgeType;
import org.eclipse.photran.internal.core.vpg.Messages;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPGComponentFactory;
import org.eclipse.photran.internal.core.vpg.PhotranVPGWriter;
import org.eclipse.rephraserengine.core.vpg.eclipse.EclipseVPG;
import org.eclipse.rephraserengine.core.vpg.eclipse.IEclipseVPGComponentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhotranVPG
extends EclipseVPG<IFortranAST, Token, PhotranTokenRef> {
    private static PhotranVPG instance = null;

    public static PhotranVPG getInstance() {
        if (instance == null) {
            PhotranVPGComponentFactory locator = new PhotranVPGComponentFactory();
            instance = FortranPreferences.ENABLE_VPG_LOGGING.getValue() ? new PhotranVPG(locator){

                public void debug(String message, String filename) {
                    System.out.println(String.valueOf(message) + " - " + 1.lastSegmentOfFilename((String)filename));
                }
            } : new PhotranVPG(locator);
        }
        return instance;
    }

    public static PhotranVPGWriter getProvider() {
        return (PhotranVPGWriter)PhotranVPG.getInstance().getVPGWriter();
    }

    protected PhotranVPG(PhotranVPGComponentFactory locator) {
        super((IEclipseVPGComponentFactory)locator, Messages.PhotranVPG_PhotranIndexer, 2);
    }

    public void start() {
        if (!FortranCorePlugin.inTestingMode()) {
            super.start();
        }
    }

    public static String canonicalizeIdentifier(String identifier) {
        return identifier.trim().toLowerCase().replaceAll("[ \t\r\n]", "");
    }

    public ArrayList<Definition> findAllModulesNamed(String name) {
        ArrayList<Definition> result = new ArrayList<Definition>();
        for (IFile file : this.findFilesThatExportModule(name)) {
            result.addAll(this.findModules(name, file));
        }
        return result;
    }

    private ArrayList<Definition> findModules(String name, IFile file) {
        ArrayList<Definition> result = new ArrayList<Definition>();
        String cname = PhotranVPG.canonicalizeIdentifier(name);
        IFortranAST ast = (IFortranAST)PhotranVPG.getInstance().acquireTransientAST(file);
        if (ast != null) {
            for (ASTModuleStmtNode module : ast.getRoot().findAll(ASTModuleStmtNode.class)) {
                Definition d;
                Token moduleNameToken = module.getModuleName().getModuleName();
                String moduleName = PhotranVPG.canonicalizeIdentifier(moduleNameToken.getText());
                if (!moduleName.equals(cname) || (d = this.getDefinitionFor(moduleNameToken.getTokenRef())) == null) continue;
                result.add(d);
            }
        }
        return result;
    }

    public ArrayList<Definition> findAllExternalSubprogramsNamed(String name) {
        ArrayList<Definition> result = new ArrayList<Definition>();
        for (IFile file : this.findFilesThatExportSubprogram(name)) {
            result.addAll(this.findSubprograms(name, file));
        }
        return result;
    }

    private ArrayList<Definition> findSubprograms(String name, IFile file) {
        ArrayList<Definition> result = new ArrayList<Definition>();
        String cname = PhotranVPG.canonicalizeIdentifier(name);
        IFortranAST ast = (IFortranAST)PhotranVPG.getInstance().acquireTransientAST(file);
        if (ast != null) {
            ASTExecutableProgramNode node = ast.getRoot();
            for (IProgramUnit pu : node.getProgramUnitList()) {
                Definition d;
                PhotranTokenRef tr = this.attemptToMatch(cname, pu);
                if (tr == null || (d = this.getDefinitionFor(tr)) == null) continue;
                result.add(d);
            }
        }
        return result;
    }

    private PhotranTokenRef attemptToMatch(String cname, IProgramUnit pu) {
        if (pu instanceof ASTSubroutineSubprogramNode) {
            return this.attemptToMatch(cname, ((ASTSubroutineSubprogramNode)pu).getSubroutineStmt());
        }
        if (pu instanceof ASTFunctionSubprogramNode) {
            return this.attemptToMatch(cname, ((ASTFunctionSubprogramNode)pu).getFunctionStmt());
        }
        return null;
    }

    private PhotranTokenRef attemptToMatch(String cname, ASTSubroutineStmtNode functionStmt) {
        return this.attemptToMatch(cname, functionStmt.getSubroutineName().getSubroutineName());
    }

    private PhotranTokenRef attemptToMatch(String cname, ASTFunctionStmtNode functionStmt) {
        return this.attemptToMatch(cname, functionStmt.getFunctionName().getFunctionName());
    }

    private PhotranTokenRef attemptToMatch(String cname, Token nameToken) {
        String thisSub = PhotranVPG.canonicalizeIdentifier(nameToken.getText());
        if (thisSub.equals(cname)) {
            return nameToken.getTokenRef();
        }
        return null;
    }

    public static ASTNodeWithErrorRecoverySymbols findFirstErrorIn(ASTExecutableProgramNode ast) {
        class V
        extends ASTVisitor {
            private ASTNodeWithErrorRecoverySymbols firstError = null;

            V() {
            }

            public void visitASTErrorProgramUnitNode(ASTErrorProgramUnitNode node) {
                if (this.firstError == null) {
                    this.firstError = node;
                }
            }

            public void visitASTErrorConstructNode(ASTErrorConstructNode node) {
                if (this.firstError == null) {
                    this.firstError = node;
                }
            }
        }
        V v = new V();
        ast.accept(v);
        return v.firstError;
    }

    public ArrayList<Definition> findAllDeclarationsInInterfacesForExternalSubprogram(String name) {
        ArrayList<Definition> result = new ArrayList<Definition>();
        for (IFile file : this.findFilesThatImportSubprogram(name)) {
            result.addAll(this.findInterfaceSubprograms(name, file));
        }
        return result;
    }

    private ArrayList<Definition> findInterfaceSubprograms(String name, IFile file) {
        ArrayList<Definition> result = new ArrayList<Definition>();
        IFortranAST ast = (IFortranAST)PhotranVPG.getInstance().acquireTransientAST(file);
        if (ast != null) {
            ast.accept(new InterfaceVisitor(result, PhotranVPG.canonicalizeIdentifier(name)));
        }
        return result;
    }

    public ArrayList<Definition> findAllDeclarationsInExternalStmts(String name) {
        ArrayList<Definition> result = new ArrayList<Definition>();
        for (IFile file : this.findFilesThatImportSubprogram(name)) {
            result.addAll(this.findExternalStmts(name, file));
        }
        return result;
    }

    private ArrayList<Definition> findExternalStmts(String name, IFile file) {
        ArrayList<Definition> result = new ArrayList<Definition>();
        IFortranAST ast = (IFortranAST)PhotranVPG.getInstance().acquireTransientAST(file);
        if (ast != null) {
            ast.accept(new ExternalStmtVisitor(result, PhotranVPG.canonicalizeIdentifier(name)));
        }
        return result;
    }

    private List<IFile> getOutgoingIFileDependenciesFrom(String targetFilename) {
        LinkedList<IFile> files = new LinkedList<IFile>();
        for (String filename : super.getOutgoingDependenciesFrom(targetFilename)) {
            IFile file = PhotranVPG.getIFileForFilename((String)filename);
            if (file == null) continue;
            files.add(file);
        }
        return files;
    }

    private List<IFile> getIncomingIFileDependenciesTo(String targetFilename) {
        LinkedList<IFile> files = new LinkedList<IFile>();
        for (String filename : super.getIncomingDependenciesTo(targetFilename)) {
            files.add(PhotranVPG.getIFileForFilename((String)filename));
        }
        return files;
    }

    public List<IFile> findFilesThatExportSubprogram(String subprogramName) {
        return this.getOutgoingIFileDependenciesFrom("subprogram:" + PhotranVPG.canonicalizeIdentifier(subprogramName));
    }

    public List<IFile> findFilesThatImportSubprogram(String subprogramName) {
        return this.getIncomingIFileDependenciesTo("subprogram:" + PhotranVPG.canonicalizeIdentifier(subprogramName));
    }

    public List<IFile> findFilesThatExportModule(String moduleName) {
        return this.getOutgoingIFileDependenciesFrom("module:" + PhotranVPG.canonicalizeIdentifier(moduleName));
    }

    public List<IFile> findFilesThatImportModule(String moduleName) {
        return this.getIncomingIFileDependenciesTo("module:" + PhotranVPG.canonicalizeIdentifier(moduleName));
    }

    public List<IFile> findFilesThatUseCommonBlock(String commonBlockName) {
        if (commonBlockName == null) {
            commonBlockName = "";
        }
        return this.getIncomingIFileDependenciesTo("common:" + PhotranVPG.canonicalizeIdentifier(commonBlockName));
    }

    public Iterable<String> listAllModules() {
        return this.listAllDependentFilenamesStartingWith("module:");
    }

    public Iterable<String> listAllSubprograms() {
        return this.listAllDependentFilenamesStartingWith("subprogram:");
    }

    public Iterable<String> listAllCommonBlocks() {
        return this.listAllFilenamesWithDependentsStartingWith("common:");
    }

    private Iterable<String> listAllDependentFilenamesStartingWith(String prefix) {
        TreeSet<String> result = new TreeSet<String>();
        for (String name : this.listAllDependentFilenames()) {
            if (!name.startsWith(prefix)) continue;
            result.add(name.substring(prefix.length()));
        }
        for (String name : this.listAllFilenamesWithDependents()) {
            if (!name.startsWith(prefix)) continue;
            result.add(name.substring(prefix.length()));
        }
        return result;
    }

    private Iterable<String> listAllFilenamesWithDependentsStartingWith(String prefix) {
        TreeSet<String> result = new TreeSet<String>();
        for (String name : this.listAllFilenamesWithDependents()) {
            if (!name.startsWith(prefix)) continue;
            result.add(name.substring(prefix.length()));
        }
        return result;
    }

    public Definition getDefinitionFor(PhotranTokenRef tokenRef) {
        return (Definition)tokenRef.getAnnotation(AnnotationType.DEFINITION_ANNOTATION_TYPE);
    }

    public Type getTypeFor(PhotranTokenRef tokenRef) {
        return (Type)tokenRef.getAnnotation(AnnotationType.TYPE_ANNOTATION_TYPE);
    }

    public Definition.Visibility getVisibilityFor(Definition def, ScopingNode visibilityInScope) {
        PhotranTokenRef targetScope = visibilityInScope.getRepresentativeToken();
        for (PhotranTokenRef privateScope : def.getTokenRef().followOutgoing(EdgeType.DEFINITION_IS_PRIVATE_IN_SCOPE_EDGE_TYPE)) {
            if (!privateScope.equals(targetScope)) continue;
            return Definition.Visibility.PRIVATE;
        }
        return Definition.Visibility.PUBLIC;
    }

    public PhotranTokenRef getModuleTokenRef(String moduleName) {
        String filename = "module:" + PhotranVPG.canonicalizeIdentifier(moduleName);
        PhotranTokenRef tokenRef = (PhotranTokenRef)this.getVPGNode(filename, 0, 0);
        return (PhotranTokenRef)tokenRef.getAnnotation(AnnotationType.MODULE_TOKENREF_ANNOTATION_TYPE);
    }

    public List<Definition> getModuleSymbolTable(String moduleName) {
        return PhotranVPG.getProvider().getModuleSymbolTable(moduleName);
    }

    public String describeEdgeType(int edgeType) {
        return PhotranVPG.getProvider().describeEdgeType(edgeType);
    }

    public String describeAnnotationType(int annotationType) {
        return PhotranVPG.getProvider().describeAnnotationType(annotationType);
    }

    public boolean doesProjectHaveRefactoringEnabled(IFile file) {
        if (FortranCorePlugin.inTestingMode()) {
            return true;
        }
        String vpgEnabledProperty = new SearchPathProperties().getProperty(file, "EnableVPG");
        return vpgEnabledProperty != null && vpgEnabledProperty.equals("true");
    }

    public String getSourceCodeFromAST(IFortranAST ast) {
        return ast.getRoot().toString();
    }

    public boolean shouldProcessFile(IFile file) {
        return FortranCorePlugin.hasFortranContentType((String)file.getName());
    }

    public boolean shouldProcessProject(IProject project) {
        block5: {
            block4: {
                try {
                    if (project.isAccessible()) break block4;
                    return false;
                }
                catch (CoreException coreException) {
                    return false;
                }
            }
            if (project.hasNature("org.eclipse.photran.core.fnature")) break block5;
            return false;
        }
        return FortranCorePlugin.inTestingMode() || new SearchPathProperties().getProperty(project, "EnableVPG").equals("true");
    }

    public String describeWhyCannotProcessProject(IProject project) {
        try {
            if (!project.isAccessible()) {
                return Messages.bind((String)Messages.PhotranVPG_ProjectIsNotAccessible, (Object)project.getName());
            }
            if (!project.hasNature("org.eclipse.photran.core.fnature")) {
                return Messages.bind((String)Messages.PhotranVPG_ProjectIsNotAFortranProject, (Object)project.getName());
            }
            if (!new SearchPathProperties().getProperty(project, "EnableVPG").equals("true")) {
                return Messages.bind((String)Messages.PhotranVPG_AnalysisRefactoringNotEnabled, (Object)project.getName());
            }
            return null;
        }
        catch (CoreException e) {
            return e.getLocalizedMessage();
        }
    }

    public String describeWhyCannotProcessFile(IFile file) {
        if (file.getProject() == null) {
            return Messages.bind((String)Messages.PhotranVPG_FileIsNotInAFortranProject, (Object)file.getName());
        }
        if (!this.shouldProcessProject(file.getProject())) {
            return this.describeWhyCannotProcessProject(file.getProject());
        }
        if (!this.shouldProcessFile(file)) {
            return Messages.bind((String)Messages.PhotranVPG_NotAFortranSourceFile, (Object)file.getName(), (Object)file.getFileExtension());
        }
        return null;
    }

    public boolean isVirtualFile(String filename) {
        return filename.startsWith("module:") || filename.startsWith("common:") || filename.startsWith("subprogram:");
    }

    public IFortranAST parse(String filename) {
        return ((PhotranVPGWriter)this.getVPGWriter()).parse(filename);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ExternalStmtVisitor
    extends GenericASTVisitor {
        private final ArrayList<Definition> result;
        private final String canonicalizedName;

        public ExternalStmtVisitor(ArrayList<Definition> result, String canonicalizedName) {
            this.result = result;
            this.canonicalizedName = canonicalizedName;
        }

        @Override
        public void visitASTExternalStmtNode(ASTExternalStmtNode node) {
            super.traverseChildren(node);
            IASTListNode<ASTExternalNameListNode> list = node.getExternalNameList();
            int i = 0;
            while (i < list.size()) {
                this.add(PhotranVPG.this.attemptToMatch(this.canonicalizedName, ((ASTExternalNameListNode)list.get(i)).getExternalName()));
                ++i;
            }
        }

        private void add(PhotranTokenRef tr) {
            Definition def;
            Definition definition = def = tr == null ? null : PhotranVPG.this.getDefinitionFor(tr);
            if (def != null) {
                this.result.add(def);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class InterfaceVisitor
    extends GenericASTVisitor {
        private final ArrayList<Definition> result;
        private final String canonicalizedName;

        public InterfaceVisitor(ArrayList<Definition> result, String canonicalizedName) {
            this.result = result;
            this.canonicalizedName = canonicalizedName;
        }

        @Override
        public void visitASTFunctionStmtNode(ASTFunctionStmtNode node) {
            this.addIfDefinedInInterface(PhotranVPG.this.attemptToMatch(this.canonicalizedName, node));
        }

        @Override
        public void visitASTSubroutineStmtNode(ASTSubroutineStmtNode node) {
            this.addIfDefinedInInterface(PhotranVPG.this.attemptToMatch(this.canonicalizedName, node));
        }

        private void addIfDefinedInInterface(PhotranTokenRef tr) {
            Definition def;
            Definition definition = def = tr == null ? null : PhotranVPG.this.getDefinitionFor(tr);
            if (def != null && def.isExternalSubprogramReferenceInInterfaceBlock()) {
                this.result.add(def);
            }
        }
    }
}

