/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.core.launch;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPIPlugin;
import org.eclipse.ptp.rm.mpi.openmpi.core.launch.OpenMPILaunchConfigurationDefaults;

public class OpenMPILaunchConfiguration {
    public static final String ATTR_BASE = String.valueOf(OpenMPIPlugin.getUniqueIdentifier()) + ".launchAttributes";
    public static final String ATTR_NUMPROCS = String.valueOf(ATTR_BASE) + ".numProcs";
    public static final String ATTR_BYNODE = String.valueOf(ATTR_BASE) + ".byNode";
    public static final String ATTR_BYSLOT = String.valueOf(ATTR_BASE) + ".bySlot";
    public static final String ATTR_NOOVERSUBSCRIBE = String.valueOf(ATTR_BASE) + ".noOversubscribe";
    public static final String ATTR_NOLOCAL = String.valueOf(ATTR_BASE) + ".noLocal";
    public static final String ATTR_PREFIX = String.valueOf(ATTR_BASE) + ".prefix";
    public static final String ATTR_USEPREFIX = String.valueOf(ATTR_BASE) + ".usePrefix";
    public static final String ATTR_HOSTFILE = String.valueOf(ATTR_BASE) + ".hostFile";
    public static final String ATTR_USEHOSTFILE = String.valueOf(ATTR_BASE) + ".useHostFile";
    public static final String ATTR_HOSTLIST = String.valueOf(ATTR_BASE) + ".hostList";
    public static final String ATTR_USEHOSTLIST = String.valueOf(ATTR_BASE) + ".useHostList";
    public static final String ATTR_ARGUMENTS = String.valueOf(ATTR_BASE) + ".arguments";
    public static final String ATTR_USEDEFAULTARGUMENTS = String.valueOf(ATTR_BASE) + ".useDefaultArguments";
    public static final String ATTR_PARAMETERS = String.valueOf(ATTR_BASE) + ".parameters";
    public static final String ATTR_USEDEFAULTPARAMETERS = String.valueOf(ATTR_BASE) + ".useDefaultParameters";

    public static String calculateArguments(ILaunchConfiguration configuration) throws CoreException {
        if (configuration.getAttribute(ATTR_USEDEFAULTARGUMENTS, OpenMPILaunchConfigurationDefaults.ATTR_USEDEFAULTARGUMENTS)) {
            String launchArgs = "-np " + Integer.toString(configuration.getAttribute(ATTR_NUMPROCS, OpenMPILaunchConfigurationDefaults.ATTR_NUMPROCS));
            if (configuration.getAttribute(ATTR_BYNODE, OpenMPILaunchConfigurationDefaults.ATTR_BYNODE)) {
                launchArgs = String.valueOf(launchArgs) + " -bynode";
            }
            if (configuration.getAttribute(ATTR_BYSLOT, OpenMPILaunchConfigurationDefaults.ATTR_BYSLOT)) {
                launchArgs = String.valueOf(launchArgs) + " -byslot";
            }
            if (configuration.getAttribute(ATTR_NOOVERSUBSCRIBE, OpenMPILaunchConfigurationDefaults.ATTR_NOOVERSUBSCRIBE)) {
                launchArgs = String.valueOf(launchArgs) + " -nooversubscribe";
            }
            if (configuration.getAttribute(ATTR_NOLOCAL, OpenMPILaunchConfigurationDefaults.ATTR_NOLOCAL)) {
                launchArgs = String.valueOf(launchArgs) + " -nolocal";
            }
            if (configuration.getAttribute(ATTR_USEPREFIX, OpenMPILaunchConfigurationDefaults.ATTR_USEPREFIX)) {
                launchArgs = String.valueOf(launchArgs) + " --prefix " + OpenMPILaunchConfiguration.fixString(configuration.getAttribute(ATTR_PREFIX, OpenMPILaunchConfigurationDefaults.ATTR_PREFIX));
            }
            if (configuration.getAttribute(ATTR_USEHOSTFILE, OpenMPILaunchConfigurationDefaults.ATTR_USEHOSTFILE)) {
                launchArgs = String.valueOf(launchArgs) + " -hostfile " + OpenMPILaunchConfiguration.fixString(configuration.getAttribute(ATTR_HOSTFILE, OpenMPILaunchConfigurationDefaults.ATTR_HOSTFILE));
            }
            if (configuration.getAttribute(ATTR_USEHOSTLIST, OpenMPILaunchConfigurationDefaults.ATTR_USEHOSTLIST)) {
                launchArgs = String.valueOf(launchArgs) + " -host " + OpenMPILaunchConfiguration.textToHostList(OpenMPILaunchConfiguration.fixString(configuration.getAttribute(ATTR_HOSTLIST, OpenMPILaunchConfigurationDefaults.ATTR_HOSTLIST)));
            }
            if (!configuration.getAttribute(ATTR_USEDEFAULTPARAMETERS, OpenMPILaunchConfigurationDefaults.ATTR_USEDEFAULTPARAMETERS)) {
                Map params = configuration.getAttribute(ATTR_PARAMETERS, OpenMPILaunchConfigurationDefaults.ATTR_PARAMETERS);
                for (Map.Entry param : params.entrySet()) {
                    launchArgs = String.valueOf(launchArgs) + " -mca " + (String)param.getKey() + " " + OpenMPILaunchConfiguration.fixString((String)param.getValue());
                }
            }
            return launchArgs;
        }
        return configuration.getAttribute(ATTR_ARGUMENTS, OpenMPILaunchConfigurationDefaults.ATTR_ARGUMENTS);
    }

    private static String fixString(String s) {
        if (s == null) {
            return "\"\"";
        }
        return "\"" + s + "\"";
    }

    private static String textToHostList(String text) {
        if (text == null) {
            return "";
        }
        String result = "";
        String[] values = text.split("\n");
        int i = 0;
        while (i < values.length) {
            if (!values[i].equals("")) {
                if (i > 0) {
                    result = String.valueOf(result) + ",";
                }
                result = String.valueOf(result) + values[i];
            }
            ++i;
        }
        return result;
    }
}

