/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.IRemoteServicesDescriptor;
import org.eclipse.ptp.remote.core.messages.Messages;
import org.eclipse.ptp.remote.internal.core.DebugUtil;
import org.eclipse.ptp.remote.internal.core.RemoteServicesProxy;
import org.osgi.framework.BundleContext;

public class PTPRemoteCorePlugin
extends Plugin {
    private static final String PLUGIN_ID = "org.eclipse.ptp.remote.core";
    public static final String REMOTE_SERVICES_EXTENSION_POINT_ID = "remoteServices";
    private static PTPRemoteCorePlugin plugin;
    private final Map<String, RemoteServicesProxy> allRemoteServicesById = new HashMap<String, RemoteServicesProxy>();
    private final Map<String, RemoteServicesProxy> allRemoteServicesByScheme = new HashMap<String, RemoteServicesProxy>();
    private IRemoteServices defaultRemoteServices;

    public static Object getAdapter(Object sourceObject, Class adapterType) {
        Object result;
        IAdaptable adaptable;
        Object result2;
        Assert.isNotNull((Object)adapterType);
        if (sourceObject == null) {
            return null;
        }
        if (adapterType.isInstance(sourceObject)) {
            return sourceObject;
        }
        if (sourceObject instanceof IAdaptable && (result2 = (adaptable = (IAdaptable)sourceObject).getAdapter(adapterType)) != null) {
            Assert.isTrue((boolean)adapterType.isInstance(result2));
            return result2;
        }
        if (!(sourceObject instanceof PlatformObject) && (result = Platform.getAdapterManager().getAdapter(sourceObject, adapterType)) != null) {
            return result;
        }
        return null;
    }

    public static PTPRemoteCorePlugin getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        if (PTPRemoteCorePlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return PTPRemoteCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(IStatus status) {
        PTPRemoteCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(String message) {
        PTPRemoteCorePlugin.log((IStatus)new Status(4, PTPRemoteCorePlugin.getUniqueIdentifier(), 4, message, null));
    }

    public static void log(Throwable e) {
        PTPRemoteCorePlugin.log((IStatus)new Status(4, PTPRemoteCorePlugin.getUniqueIdentifier(), 4, e.getMessage(), e));
    }

    public synchronized IRemoteServices[] getAllRemoteServices() {
        this.retrieveRemoteServices();
        ArrayList<IRemoteServices> services = new ArrayList<IRemoteServices>();
        for (RemoteServicesProxy proxy : this.allRemoteServicesById.values()) {
            services.add(proxy.getServices());
        }
        Collections.sort(services, new RemoteServicesSorter());
        return services.toArray(new IRemoteServices[0]);
    }

    public synchronized IRemoteServices[] getAllRemoteServices(IProgressMonitor monitor) {
        this.retrieveRemoteServices();
        ArrayList<IRemoteServices> initializedServices = new ArrayList<IRemoteServices>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.allRemoteServicesById.size());
        try {
            for (RemoteServicesProxy proxy : this.allRemoteServicesById.values()) {
                IRemoteServices services = proxy.getServices();
                this.initializeRemoteServices(services, (IProgressMonitor)progress.newChild(1));
                initializedServices.add(services);
            }
            Collections.sort(initializedServices, new RemoteServicesSorter());
            IRemoteServices[] iRemoteServicesArray = initializedServices.toArray(new IRemoteServices[0]);
            return iRemoteServicesArray;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public IRemoteServices getDefaultServices() {
        if (this.defaultRemoteServices == null) {
            this.defaultRemoteServices = this.getRemoteServices("org.eclipse.ptp.remote.LocalServices");
        }
        return this.defaultRemoteServices;
    }

    public synchronized IRemoteServices getRemoteServices(String id) {
        this.retrieveRemoteServices();
        RemoteServicesProxy proxy = this.allRemoteServicesById.get(id);
        if (proxy != null) {
            return proxy.getServices();
        }
        return null;
    }

    public IRemoteServices getRemoteServices(String id, IProgressMonitor monitor) {
        IRemoteServices services = this.getRemoteServices(id);
        if (services != null) {
            this.initializeRemoteServices(services, monitor);
        }
        return services;
    }

    public IRemoteServices getRemoteServices(URI uri) {
        RemoteServicesProxy proxy;
        this.retrieveRemoteServices();
        String scheme = uri.getScheme();
        if (scheme != null && (proxy = this.allRemoteServicesByScheme.get(uri.getScheme())) != null) {
            return proxy.getServices();
        }
        return null;
    }

    public IRemoteServices getRemoteServices(URI uri, IProgressMonitor monitor) {
        IRemoteServices services = this.getRemoteServices(uri);
        if (services != null) {
            this.initializeRemoteServices(services, monitor);
        }
        return services;
    }

    public IRemoteServicesDescriptor getRemoteServicesDescriptor(String id) {
        this.retrieveRemoteServices();
        return this.allRemoteServicesById.get(id);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        DebugUtil.configurePluginDebugOptions();
        this.defaultRemoteServices = null;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRemoteServices(IRemoteServices services, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        progress.setTaskName(NLS.bind((String)Messages.PTPRemoteCorePlugin_0, (Object)services.getName()));
        try {
            while (!services.isInitialized()) {
                progress.setWorkRemaining(9);
                services.initialize();
                if (!services.isInitialized()) {
                    try {
                        PTPRemoteCorePlugin pTPRemoteCorePlugin = this;
                        synchronized (pTPRemoteCorePlugin) {
                            ((Object)((Object)this)).wait(1000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
                progress.worked(1);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void retrieveRemoteServices() {
        if (this.allRemoteServicesById.isEmpty()) {
            IExtension[] extensions;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(PLUGIN_ID, REMOTE_SERVICES_EXTENSION_POINT_ID);
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = ext.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    RemoteServicesProxy proxy = new RemoteServicesProxy(ce);
                    this.allRemoteServicesById.put(proxy.getId(), proxy);
                    this.allRemoteServicesByScheme.put(proxy.getScheme(), proxy);
                    ++n4;
                }
                ++n2;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RemoteServicesSorter
    implements Comparator<IRemoteServices> {
        private RemoteServicesSorter() {
        }

        @Override
        public int compare(IRemoteServices o1, IRemoteServices o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }
}

