/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ibm.pe.core.rmsystem;

import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.rm.core.rmsystem.AbstractRemoteResourceManagerConfiguration;
import org.eclipse.ptp.rm.ibm.pe.core.PECorePlugin;
import org.eclipse.ptp.services.core.IServiceProvider;

public class PEResourceManagerConfiguration
extends AbstractRemoteResourceManagerConfiguration {
    private static final String TAG_USE_LOADLEVELER = "PE_UseLoadLeveler";
    private static final String TAG_DEBUG_LEVEL = "PE_DebugLevel";
    private static final String TAG_RUN_MINIPROXY = "PE_RunMiniproxy";
    private static final String TAG_SUSPEND_PROXY = "PE_SuspendProxy";
    private static final String TAG_LOADLEVELER_MODE = "PE_LoadLevelerMode";
    private static final String TAG_MIN_NODE_POLL_INTERVAL = "PE_NodeMinPollInterval";
    private static final String TAG_MAX_NODE_POLL_INTERVAL = "PE_NodeMaxPollInterval";
    private static final String TAG_JOB_POLL_INTERVAL = "PE_JobPollInterval";
    private static final String TAG_LIBRARY_OVERRIDE = "PE_LibraryOverride";

    public PEResourceManagerConfiguration(String namespace, IServiceProvider provider) {
        super(namespace, provider);
        this.setDescription("IBM PE Resource Manager");
    }

    public String getDebugLevel() {
        return this.getString(TAG_DEBUG_LEVEL, Preferences.getString((String)PECorePlugin.getUniqueIdentifier(), (String)"PE_traceLevel"));
    }

    public String getJobPollInterval() {
        return this.getString(TAG_JOB_POLL_INTERVAL, Preferences.getString((String)PECorePlugin.getUniqueIdentifier(), (String)TAG_JOB_POLL_INTERVAL));
    }

    public String getLibraryOverride() {
        return this.getString(TAG_LIBRARY_OVERRIDE, Preferences.getString((String)PECorePlugin.getUniqueIdentifier(), (String)"PE_libraryOverride"));
    }

    public String getLoadLevelerMode() {
        return this.getString(TAG_LOADLEVELER_MODE, Preferences.getString((String)PECorePlugin.getUniqueIdentifier(), (String)TAG_LOADLEVELER_MODE));
    }

    public String getNodeMaxPollInterval() {
        return this.getString(TAG_MAX_NODE_POLL_INTERVAL, Preferences.getString((String)PECorePlugin.getUniqueIdentifier(), (String)TAG_MAX_NODE_POLL_INTERVAL));
    }

    public String getNodeMinPollInterval() {
        return this.getString(TAG_MIN_NODE_POLL_INTERVAL, Preferences.getString((String)PECorePlugin.getUniqueIdentifier(), (String)TAG_MIN_NODE_POLL_INTERVAL));
    }

    public String getRunMiniproxy() {
        return "";
    }

    public String getSuspendProxy() {
        return this.getString(TAG_SUSPEND_PROXY, "n");
    }

    public String getUseLoadLeveler() {
        return this.getString(TAG_USE_LOADLEVELER, Preferences.getString((String)PECorePlugin.getUniqueIdentifier(), (String)"PE_useLoadLeveler"));
    }

    public boolean isConfigured() {
        return true;
    }

    public boolean needsDebuggerLaunchHelp() {
        return true;
    }

    public void setDebugLevel(String debugLevel) {
        this.putString(TAG_DEBUG_LEVEL, debugLevel);
    }

    public void setDefaultNameAndDesc() {
        String name = "IBM PE";
        String conn = this.getConnectionName();
        if (conn != null && !conn.equals("")) {
            name = String.valueOf(name) + "@" + conn;
        }
        this.setName(name);
        this.setDescription("IBM PE Resource Manager");
    }

    public void setJobPollInterval(String interval) {
        this.putString(TAG_JOB_POLL_INTERVAL, interval);
    }

    public void setLibraryOverride(String override) {
        this.putString(TAG_LIBRARY_OVERRIDE, override);
    }

    public void setLoadLevelerMode(String mode) {
        this.putString(TAG_LOADLEVELER_MODE, mode);
    }

    public void setNodeMaxPollInterval(String interval) {
        this.putString(TAG_MAX_NODE_POLL_INTERVAL, interval);
    }

    public void setNodeMinPollInterval(String interval) {
        this.putString(TAG_MIN_NODE_POLL_INTERVAL, interval);
    }

    public void setRunMiniproxy(String flag) {
        this.putString(TAG_RUN_MINIPROXY, flag);
    }

    public void setSuspendProxy(String flag) {
        this.putString(TAG_SUSPEND_PROXY, flag);
    }

    public void setUseLoadLeveler(String flag) {
        this.putString(TAG_USE_LOADLEVELER, flag);
    }
}

