/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.rm.lml.core.ILMLCoreConstants;
import org.eclipse.ptp.rm.lml.core.Preferences;
import org.eclipse.ptp.rm.lml.core.messages.Messages;
import org.eclipse.ptp.rm.lml.core.util.DebugUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class LMLCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.ptp.rm.lml.core";
    private static LMLCorePlugin fPlugin;
    private ResourceBundle resourceBundle;

    public static LMLCorePlugin getDefault() {
        return fPlugin;
    }

    public static URL getResource(String resource) throws IOException {
        URL url = null;
        if (LMLCorePlugin.getDefault() != null) {
            Bundle bundle = LMLCorePlugin.getDefault().getBundle();
            url = FileLocator.find((Bundle)bundle, (IPath)new Path(String.valueOf(ILMLCoreConstants.PATH_SEP) + resource), null);
        } else {
            url = new File(resource).toURI().toURL();
        }
        return url;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = LMLCorePlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getUniqueIdentifier() {
        if (LMLCorePlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return LMLCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(IStatus status) {
        LMLCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(String msg) {
        if (DebugUtil.RM_TRACING) {
            System.err.println(msg);
        }
        LMLCorePlugin.log((IStatus)new Status(4, LMLCorePlugin.getUniqueIdentifier(), 4, msg, null));
    }

    public static void log(Throwable e) {
        LMLCorePlugin.log((IStatus)new Status(4, LMLCorePlugin.getUniqueIdentifier(), 4, Messages.LMLCorePlugin_0, e));
    }

    public LMLCorePlugin() {
        fPlugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.ptp.rm.lml.core.ParallelPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        DebugUtil.configurePluginDebugOptions();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            Preferences.savePreferences(LMLCorePlugin.getUniqueIdentifier());
        }
        finally {
            super.stop(context);
            fPlugin = null;
        }
    }
}

