/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.internal.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.ptp.rm.lml.core.events.ILguiUpdatedEvent;
import org.eclipse.ptp.rm.lml.core.listeners.ILguiListener;
import org.eclipse.ptp.rm.lml.core.model.ILguiItem;
import org.eclipse.ptp.rm.lml.internal.core.elements.InfoType;
import org.eclipse.ptp.rm.lml.internal.core.elements.InformationType;
import org.eclipse.ptp.rm.lml.internal.core.elements.LguiType;
import org.eclipse.ptp.rm.lml.internal.core.model.LguiHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OIDToInformation
extends LguiHandler {
    private HashMap<String, List<InfoType>> oidToInfo;

    public OIDToInformation(ILguiItem lguiItem, LguiType lgui) {
        super(lguiItem, lgui);
        this.updateData(lgui);
        lguiItem.addListener(new ILguiListener(){

            public void handleEvent(ILguiUpdatedEvent e) {
                OIDToInformation.this.updateData(e.getLgui());
            }
        });
    }

    public InfoType getInfoByOid(String oid) {
        List<InformationType> listInformation = this.lguiItem.getOverviewAccess().getInformations();
        for (InformationType information : listInformation) {
            List<InfoType> listInfo = information.getInfo();
            for (InfoType info : listInfo) {
                if (!info.getOid().equals(oid)) continue;
                return info;
            }
        }
        return null;
    }

    public List<InfoType> getInfosById(String id) {
        return this.oidToInfo.get(id);
    }

    public List<InfoType> getInfosByType(String id, String type) {
        List<InfoType> infoList = this.getInfosById(id);
        if (infoList == null) {
            return null;
        }
        ArrayList<InfoType> result = new ArrayList<InfoType>();
        for (InfoType info : infoList) {
            if (!info.getType().equals(type)) continue;
            result.add(info);
        }
        return result;
    }

    public void updateData(LguiType lgui) {
        this.lgui = lgui;
        this.getInformationFromModel();
    }

    private void getInformationFromModel() {
        this.oidToInfo = new HashMap();
        for (Object object : jaxbUtil.getObjects(this.lgui)) {
            if (!(object instanceof InformationType)) continue;
            for (InfoType info : ((InformationType)object).getInfo()) {
                String oid = info.getOid();
                if (this.oidToInfo.containsKey(oid)) {
                    List<InfoType> oldList = this.oidToInfo.get(oid);
                    oldList.add(info);
                    continue;
                }
                ArrayList<InfoType> newList = new ArrayList<InfoType>();
                newList.add(info);
                this.oidToInfo.put(oid, newList);
            }
        }
    }
}

