/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.internal.core.model;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.ptp.rm.lml.core.JobStatusData;
import org.eclipse.ptp.rm.lml.core.LMLCorePlugin;
import org.eclipse.ptp.rm.lml.core.LMLManager;
import org.eclipse.ptp.rm.lml.core.events.ILguiUpdatedEvent;
import org.eclipse.ptp.rm.lml.core.listeners.ILguiListener;
import org.eclipse.ptp.rm.lml.core.model.ILguiItem;
import org.eclipse.ptp.rm.lml.core.model.IPattern;
import org.eclipse.ptp.rm.lml.core.model.ITableColumnLayout;
import org.eclipse.ptp.rm.lml.internal.core.elements.CellType;
import org.eclipse.ptp.rm.lml.internal.core.elements.ColumnType;
import org.eclipse.ptp.rm.lml.internal.core.elements.ColumnlayoutType;
import org.eclipse.ptp.rm.lml.internal.core.elements.Columnsortedtype;
import org.eclipse.ptp.rm.lml.internal.core.elements.GobjectType;
import org.eclipse.ptp.rm.lml.internal.core.elements.LguiType;
import org.eclipse.ptp.rm.lml.internal.core.elements.PatternMatchType;
import org.eclipse.ptp.rm.lml.internal.core.elements.PatternType;
import org.eclipse.ptp.rm.lml.internal.core.elements.RowType;
import org.eclipse.ptp.rm.lml.internal.core.elements.SortingType;
import org.eclipse.ptp.rm.lml.internal.core.elements.TableType;
import org.eclipse.ptp.rm.lml.internal.core.elements.TablelayoutType;
import org.eclipse.ptp.rm.lml.internal.core.model.Cell;
import org.eclipse.ptp.rm.lml.internal.core.model.LguiHandler;
import org.eclipse.ptp.rm.lml.internal.core.model.Row;
import org.eclipse.ptp.rm.lml.internal.core.model.TableColumnLayout;
import org.eclipse.ptp.rm.lml.internal.core.model.TableSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableHandler
extends LguiHandler {
    private final TableListener tableListener = new TableListener();

    public TableHandler(ILguiItem lguiItem, LguiType lgui) {
        super(lguiItem, lgui);
        lguiItem.addListener(this.tableListener);
    }

    public void changeTableColumnsOrder(String gid, int[] order) {
        ArrayList<ColumnlayoutType> newColumnLayouts = new ArrayList<ColumnlayoutType>();
        List<ColumnlayoutType> oldColumnLayouts = this.lguiItem.getLayoutAccess().getTableLayout(gid).getColumn();
        int i = 0;
        while (i < order.length) {
            for (ColumnlayoutType column : oldColumnLayouts) {
                if (!BigInteger.valueOf(order[i]).equals(column.getPos())) continue;
                ColumnlayoutType columnNew = column;
                columnNew.setPos(BigInteger.valueOf(i));
                newColumnLayouts.add(columnNew);
                this.lguiItem.getLayoutAccess().getTableLayout(gid).getColumn().remove(column);
                break;
            }
            ++i;
        }
        for (ColumnlayoutType column : newColumnLayouts) {
            this.lguiItem.getLayoutAccess().getTableLayout(gid).getColumn().add(column);
        }
    }

    public void changeTableColumnsWidth(String gid, Double[] widths) {
        BigInteger[] cids = this.getCids(gid);
        int i = 0;
        while (i < widths.length) {
            ColumnlayoutType[] columnlayoutTypeArray = this.lguiItem.getLayoutAccess().getLayoutColumsToCids(cids, gid);
            int n = columnlayoutTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnlayoutType column = columnlayoutTypeArray[n2];
                if (column.getPos() != null && BigInteger.valueOf(i).equals(column.getPos())) {
                    column.setWidth(widths[i]);
                    break;
                }
                ++n2;
            }
            ++i;
        }
    }

    public TableType generateDefaultTable(String gid) {
        TableType table = new TableType();
        table.setId(gid);
        table.setTitle("title_" + gid);
        table.setContenttype("jobs");
        for (ColumnlayoutType columnLayout : this.lguiItem.getLayoutAccess().getTableLayout(gid).getColumn()) {
            if (!columnLayout.isActive()) continue;
            ColumnType column = new ColumnType();
            column.setId(columnLayout.getCid());
            column.setName(columnLayout.getKey());
            this.generateDefaultSorting(column);
            if (columnLayout.getKey().equals("owner")) {
                this.generateDefaultPattern(".*", column);
            }
            if (columnLayout.getKey().equals("status")) {
                column.setType("mandatory");
                if (gid.equals("joblistrun")) {
                    this.generateDefaultPattern("RUNNING", column);
                } else {
                    this.generateDefaultPattern("SUBMITTED", column);
                }
            }
            table.getColumn().add(column);
        }
        jaxbUtil.addTable(this.lgui, table);
        return table;
    }

    public ITableColumnLayout[] getActiveTableColumnLayout(String gid) {
        ITableColumnLayout[] allColumns = this.getTableColumnLayout(gid);
        ArrayList<ITableColumnLayout> activeColumns = new ArrayList<ITableColumnLayout>();
        ITableColumnLayout[] iTableColumnLayoutArray = allColumns;
        int n = allColumns.length;
        int n2 = 0;
        while (n2 < n) {
            ITableColumnLayout allColumn = iTableColumnLayoutArray[n2];
            if (allColumn.isActive()) {
                activeColumns.add(allColumn);
            }
            ++n2;
        }
        return activeColumns.toArray(new ITableColumnLayout[activeColumns.size()]);
    }

    public String getCellValue(TableType table, RowType row, String colName) {
        BigInteger index = this.getColumnIndex(table, colName);
        if (index != null) {
            for (CellType cell : row.getCell()) {
                if (!cell.getCid().equals(index)) continue;
                return cell.getValue();
            }
        }
        return null;
    }

    public int getNumberOfTableColumns(String gid) {
        TablelayoutType layout = this.lguiItem.getLayoutAccess().getTableLayout(gid);
        int activeColumn = 0;
        for (ColumnlayoutType column : layout.getColumn()) {
            if (!column.isActive()) continue;
            ++activeColumn;
        }
        return activeColumn;
    }

    public int getNumberOfTables() {
        return this.getTables().size();
    }

    public Object[] getSortProperties(String gid) {
        Object[] values = new Object[]{-1, "NONE"};
        TablelayoutType tableLayout = this.lguiItem.getLayoutAccess().getTableLayout(gid);
        for (ColumnlayoutType columnLayout : tableLayout.getColumn()) {
            if (columnLayout.getSorted().equals((Object)Columnsortedtype.FALSE)) continue;
            values[0] = columnLayout.getPos().intValue();
            values[1] = columnLayout.getSorted().equals((Object)Columnsortedtype.ASC) ? "UP" : "DOWN";
        }
        return values;
    }

    public TableType getTable(String gid) {
        for (TableType tag : this.getTables()) {
            if (!tag.getId().equals(gid)) continue;
            return tag;
        }
        LMLCorePlugin.log("No table found for gid \"" + gid + "\"!");
        return null;
    }

    public String[] getTableColumnActive(String gid) {
        TablelayoutType tableLayout = this.lguiItem.getLayoutAccess().getTableLayout(gid);
        ArrayList<String> tableColumnNonActive = new ArrayList<String>();
        int i = 0;
        while (i < tableLayout.getColumn().size()) {
            if (tableLayout.getColumn().get(i).isActive()) {
                tableColumnNonActive.add(tableLayout.getColumn().get(i).getKey());
            }
            ++i;
        }
        return tableColumnNonActive.toArray(new String[tableColumnNonActive.size()]);
    }

    public ITableColumnLayout[] getTableColumnLayout(String gid) {
        if (this.lguiItem == null && this.lguiItem.getLayoutAccess() == null) {
            return new ITableColumnLayout[0];
        }
        BigInteger[] cids = this.getCids(gid);
        ColumnlayoutType[] layoutColumns = this.lguiItem.getLayoutAccess().getLayoutColumsToCids(cids, gid);
        ITableColumnLayout[] tableColumnLayouts = new ITableColumnLayout[layoutColumns.length];
        int i = 0;
        while (i < layoutColumns.length) {
            ColumnlayoutType column = layoutColumns[i];
            if (column != null) {
                String sort = this.getColumnSortProperty(this.getTable(gid), cids, i);
                String style = column.getSorted() != null && column.getSorted().value() != null && sort != null && sort.equals("numeric") ? "RIGHT" : "LEFT";
                tableColumnLayouts[i] = new TableColumnLayout(column.getKey(), column.getWidth(), style, column.isActive(), sort);
            }
            ++i;
        }
        return tableColumnLayouts;
    }

    public String[] getTableColumnNonActive(String gid) {
        TablelayoutType tableLayout = this.lguiItem.getLayoutAccess().getTableLayout(gid);
        ArrayList<String> tableColumnNonActive = new ArrayList<String>();
        int i = 0;
        while (i < tableLayout.getColumn().size()) {
            if (!tableLayout.getColumn().get(i).isActive()) {
                tableColumnNonActive.add(tableLayout.getColumn().get(i).getKey());
            }
            ++i;
        }
        return tableColumnNonActive.toArray(new String[tableColumnNonActive.size()]);
    }

    public String[] getTableColumnTitles(String gid) {
        if (this.lguiItem == null && this.lguiItem.getLayoutAccess() == null) {
            return null;
        }
        ColumnlayoutType[] layoutColumns = this.lguiItem.getLayoutAccess().getLayoutColumsToCids(this.getCidsActiveColumns(gid), gid);
        ArrayList<String> titles = new ArrayList<String>();
        ColumnlayoutType[] columnlayoutTypeArray = layoutColumns;
        int n = layoutColumns.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnlayoutType layoutColumn = columnlayoutTypeArray[n2];
            if (layoutColumn.getKey() != null) {
                titles.add(layoutColumn.getKey());
            }
            ++n2;
        }
        return titles.toArray(new String[titles.size()]);
    }

    public Row[] getTableDataWithColor(String gid, boolean addColor) {
        BigInteger[] cids = this.getCids(gid);
        TableType table = this.getTable(gid);
        if (table == null) {
            return new Row[0];
        }
        Row[] tableData = new Row[table.getRow().size()];
        int i = 0;
        while (i < tableData.length) {
            RowType row = table.getRow().get(i);
            tableData[i] = new Row();
            tableData[i].setOid(row.getOid());
            if (addColor) {
                tableData[i].setColor(this.lguiItem.getOIDToObject().getColorById(row.getOid()));
            }
            BigInteger jobIdIndex = this.getColumnIndex(table, "step");
            Cell[] tableDataRow = new Cell[cids.length];
            String jobId = null;
            int j = 0;
            while (j < cids.length) {
                for (CellType cell : row.getCell()) {
                    if (cell.getCid() == null || !cell.getCid().equals(cids[j])) continue;
                    tableDataRow[j] = new Cell(cell.getValue(), tableData[i]);
                    break;
                }
                if (tableDataRow[j] == null) {
                    tableDataRow[j] = new Cell("?", tableData[i]);
                }
                if (cids[j].equals(jobIdIndex)) {
                    jobId = tableDataRow[j].value;
                }
                ++j;
            }
            if (jobId != null) {
                JobStatusData status = LMLManager.getInstance().getUserJob(this.lguiItem.toString(), jobId);
                if (status == null) {
                    String queueName = this.getCellValue(table, row, "queue");
                    String owner = this.getCellValue(table, row, "owner");
                    status = new JobStatusData(this.lguiItem.toString(), jobId, queueName, owner, null, null, false);
                }
                tableData[i].setJobStatusData(status);
            }
            tableData[i].setCells(tableDataRow);
            ++i;
        }
        return tableData;
    }

    public Row[] getTableDataWithColor(String gid, boolean addColor, List<IPattern> filterTitlesValues) {
        Row[] rows = this.getTableDataWithColor(gid, addColor);
        if (rows.length == 0) {
            return rows;
        }
        BigInteger[] cids = this.getCids(gid);
        TableType table = this.getTable(gid);
        HashMap<Integer, IPattern> filterPosValues = new HashMap<Integer, IPattern>();
        for (IPattern pattern : filterTitlesValues) {
            BigInteger cid = BigInteger.valueOf(-1L);
            for (ColumnType column : table.getColumn()) {
                if (!column.getName().equals(pattern.getColumnTitle())) continue;
                cid = column.getId();
                break;
            }
            if (cid.equals(BigInteger.valueOf(-1L))) continue;
            int position = -1;
            int i = 0;
            while (i < cids.length) {
                if (cids[i].equals(cid)) {
                    position = i;
                    break;
                }
                ++i;
            }
            if (position == -1) continue;
            filterPosValues.put(position, pattern);
        }
        ArrayList<Object> filterRows = new ArrayList<Object>();
        Row[] rowArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            Object row = rowArray[n2];
            boolean allIncluded = true;
            Iterator iterator = filterPosValues.keySet().iterator();
            while (iterator.hasNext()) {
                int position = (Integer)iterator.next();
                if (((Row)row).cells[position] == null) continue;
                IPattern pattern = (IPattern)filterPosValues.get(position);
                String rowValue = ((Row)row).cells[position].value;
                String type = pattern.getType();
                if (pattern.isRange()) {
                    String minValue = pattern.getMinValueRange();
                    String maxValue = pattern.getMaxValueRange();
                    if (type.equals("numeric")) {
                        if (Integer.valueOf(rowValue) >= Integer.valueOf(minValue) && Integer.valueOf(maxValue) >= Integer.valueOf(rowValue)) continue;
                        allIncluded = false;
                        break;
                    }
                    if (rowValue.compareTo(minValue) >= 0 && maxValue.compareTo(rowValue) >= 0) continue;
                    allIncluded = false;
                    break;
                }
                if (!pattern.isRelation()) continue;
                String compareValue = pattern.getRelationValue();
                String compareOperator = pattern.getRelationOperator();
                if (type.equals("numeric")) {
                    int rowValueInt = Integer.valueOf(rowValue);
                    int compareValueInt = Integer.valueOf(compareValue);
                    if (compareOperator.equals("=") && rowValueInt != compareValueInt) {
                        allIncluded = false;
                        break;
                    }
                    if (compareOperator.equals("!=") && rowValueInt == compareValueInt) {
                        allIncluded = false;
                        break;
                    }
                    if (compareOperator.equals("<") && rowValueInt >= compareValueInt) {
                        allIncluded = false;
                        break;
                    }
                    if (compareOperator.equals("<=") && rowValueInt > compareValueInt) {
                        allIncluded = false;
                        break;
                    }
                    if (compareOperator.equals(">") && rowValueInt <= compareValueInt) {
                        allIncluded = false;
                        break;
                    }
                    if (!compareOperator.equals(">=") || rowValueInt >= compareValueInt) continue;
                    allIncluded = false;
                    break;
                }
                if (compareOperator.equals("=") && !compareValue.equals(rowValue) || compareOperator.equals("!=") && compareValue.equals(rowValue)) {
                    allIncluded = false;
                    break;
                }
                if (type.equals("alpha")) {
                    if ((!compareOperator.equals("=~") || rowValue.contains(compareValue)) && (!compareOperator.equals("!~") || !rowValue.contains(compareValue))) continue;
                    allIncluded = false;
                    break;
                }
                if (!type.equals("date")) continue;
                if (compareOperator.equals("<") && rowValue.compareTo(compareValue) >= 0) {
                    allIncluded = false;
                    break;
                }
                if (compareOperator.equals("<=") && rowValue.compareTo(compareValue) > 0) {
                    allIncluded = false;
                    break;
                }
                if (compareOperator.equals(">") && rowValue.compareTo(compareValue) <= 0) {
                    allIncluded = false;
                    break;
                }
                if (!compareOperator.equals(">=") || rowValue.compareTo(compareValue) >= 0) continue;
                allIncluded = false;
                break;
            }
            if (allIncluded) {
                filterRows.add(row);
            }
            ++n2;
        }
        return filterRows.toArray(new Row[filterRows.size()]);
    }

    public List<TableType> getTables() {
        LinkedList<TableType> tables = new LinkedList<TableType>();
        for (GobjectType tag : this.lguiItem.getOverviewAccess().getGraphicalObjects()) {
            if (!(tag instanceof TableType)) continue;
            tables.add((TableType)tag);
        }
        return tables;
    }

    public String getTableTitle(String gid) {
        TableType table = this.getTable(gid);
        if (table == null) {
            return "";
        }
        return table.getTitle();
    }

    public boolean isEmpty(String gid) {
        return this.getTable(gid) == null;
    }

    public String setCellValue(TableType table, RowType row, String colName, String value) {
        BigInteger index = this.getColumnIndex(table, colName);
        if (index != null) {
            for (CellType cell : row.getCell()) {
                if (!cell.getCid().equals(index)) continue;
                String oldVal = cell.getValue();
                cell.setValue(value);
                return oldVal;
            }
        }
        return null;
    }

    public void setSortProperties(String gid, int sortIndex, String sortDirection) {
        TablelayoutType tableLayout = this.lguiItem.getLayoutAccess().getTableLayout(gid);
        for (ColumnlayoutType column : tableLayout.getColumn()) {
            if (column.getSorted() == Columnsortedtype.FALSE) continue;
            column.setSorted(Columnsortedtype.FALSE);
        }
        if (!sortDirection.equals("NONE") && sortIndex != -1) {
            for (ColumnlayoutType column : tableLayout.getColumn()) {
                if (!column.getPos().equals(BigInteger.valueOf(sortIndex))) continue;
                if (sortDirection.equals("UP")) {
                    column.setSorted(Columnsortedtype.ASC);
                    continue;
                }
                column.setSorted(Columnsortedtype.DESC);
            }
        }
    }

    public void setTableColumnActive(String gid, String text, boolean activeTableColumn) {
        List<ColumnlayoutType> columnLayouts = this.lguiItem.getLayoutAccess().getTableLayout(gid).getColumn();
        for (ColumnlayoutType column : columnLayouts) {
            if (!column.getKey().equals(text)) continue;
            column.setActive(activeTableColumn);
            break;
        }
    }

    public void sort(String gid, int sortDirectionComparator, int sortIndex, int sortDirection) {
        BigInteger[] cids;
        TableType table = this.getTable(gid);
        if (table != null && sortIndex != -1 && (cids = this.getCids(gid)).length > sortIndex) {
            RowType[] jobTableData = this.getTableData(table, cids);
            Arrays.sort(jobTableData, new TableSorter(this.getColumnSortProperty(table, cids, sortIndex), sortDirectionComparator, sortIndex, sortDirection));
            table.getRow().clear();
            RowType[] rowTypeArray = jobTableData;
            int n = jobTableData.length;
            int n2 = 0;
            while (n2 < n) {
                RowType element = rowTypeArray[n2];
                table.getRow().add(element);
                ++n2;
            }
        }
    }

    private void generateDefaultPattern(String regexp, ColumnType column) {
        PatternType pattern = new PatternType();
        PatternMatchType patternMatch = new PatternMatchType();
        patternMatch.setRegexp(regexp);
        jaxbUtil.addPatternInclude(pattern, patternMatch);
        column.setPattern(pattern);
    }

    private void generateDefaultSorting(ColumnType column) {
        if (column.getName().equals("step") || column.getName().equals("owner") || column.getName().equals("queue") || column.getName().equals("status")) {
            column.setSort(SortingType.ALPHA);
        } else if (column.getName().equals("wall") || column.getName().equals("totalcores")) {
            column.setSort(SortingType.NUMERIC);
        } else {
            column.setSort(SortingType.DATE);
        }
    }

    private BigInteger[] getCids(String gid) {
        TablelayoutType layout = this.lguiItem.getLayoutAccess().getTableLayout(gid);
        BigInteger[] cids = new BigInteger[layout.getColumn().size()];
        int i = 0;
        while (i < layout.getColumn().size()) {
            for (ColumnlayoutType column : layout.getColumn()) {
                if (column.getPos() == null || !column.getPos().equals(BigInteger.valueOf(i))) continue;
                cids[i] = column.getCid();
            }
            ++i;
        }
        return cids;
    }

    private BigInteger[] getCidsActiveColumns(String gid) {
        TablelayoutType layout = this.lguiItem.getLayoutAccess().getTableLayout(gid);
        ArrayList<BigInteger> cids = new ArrayList<BigInteger>();
        int i = 0;
        while (i < layout.getColumn().size()) {
            for (ColumnlayoutType column : layout.getColumn()) {
                if (column.getPos() == null || !column.getPos().equals(BigInteger.valueOf(i)) || !column.isActive()) continue;
                cids.add(column.getCid());
            }
            ++i;
        }
        return cids.toArray(new BigInteger[cids.size()]);
    }

    private BigInteger getColumnIndex(TableType table, String colName) {
        if (table != null) {
            for (ColumnType column : table.getColumn()) {
                if (!colName.equals(column.getName())) continue;
                return column.getId();
            }
        }
        return null;
    }

    private String getColumnSortProperty(TableType table, BigInteger[] cids, int index) {
        for (ColumnType column : table.getColumn()) {
            if (column == null || !column.getId().equals(cids[index])) continue;
            return column.getSort().value();
        }
        return "alpha";
    }

    private RowType[] getTableData(TableType table, BigInteger[] cids) {
        RowType[] tableData = new RowType[table.getRow().size()];
        int i = 0;
        while (i < tableData.length) {
            RowType row = table.getRow().get(i);
            tableData[i] = new RowType();
            if (row.getOid() != null) {
                tableData[i].setOid(row.getOid());
            }
            BigInteger[] bigIntegerArray = cids;
            int n = cids.length;
            int n2 = 0;
            while (n2 < n) {
                BigInteger cid = bigIntegerArray[n2];
                boolean exists = false;
                for (CellType cell : row.getCell()) {
                    if (!cell.getCid().equals(cid)) continue;
                    tableData[i].getCell().add(cell);
                    exists = true;
                    break;
                }
                if (!exists) {
                    CellType newCell = new CellType();
                    newCell.setCid(cid);
                    newCell.setValue("?");
                    tableData[i].getCell().add(newCell);
                }
                ++n2;
            }
            ++i;
        }
        return tableData;
    }

    private void reduceColumnPos(String gid, int pos, int i) {
        if (pos == i) {
            return;
        }
        List<ColumnlayoutType> columnLayouts = this.lguiItem.getLayoutAccess().getTableLayout(gid).getColumn();
        for (ColumnlayoutType column : columnLayouts) {
            if (column.getPos() == null || column.getPos().intValue() != pos) continue;
            column.setPos(BigInteger.valueOf(pos - 1));
            this.reduceColumnPos(gid, pos + 1, i);
            break;
        }
    }

    public class TableListener
    implements ILguiListener {
        public void handleEvent(ILguiUpdatedEvent e) {
            TableHandler.this.update(e.getLgui());
        }
    }
}

