/*
 * Copyright (c) 2010 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
 
#ifndef _x10_DBG_TYPES_H_
#define _x10_DBG_TYPES_H_

/************************************************************************
 *                    x10dbgType Definitions
 ************************************************************************/

/*
 * These type values are used in the mapping tables generated by the
 * compiler and included in the .cc intermediate files.
 */

typedef enum {
	/* Primitive Types */
	X10DTNull = 0,
	X10DTBoolean = 1,
	X10DTByte  = 2,
	X10DTChar = 3,
	X10DTDouble = 4,
	X10DTFloat = 5,
	X10DTInt = 6,
	X10DTLong = 7,
	X10DTShort = 8,

	X10DTUByte = 9,
	X10DTUInt = 10,
	X10DTULong = 11,
	X10DTUShort = 12,
	X10DTLastPrimitive = X10DTUShort,

	/* Compiler generated types */
	X10DTAsyncClosure = 100,
	X10DTClass = 101,

	/* "Built-in" Types requiring x10DA handling */
	X10DTArray = 200,
	X10DTDist = 201,
	X10DTDistArray = 202,
	X10DTPlaceLocalHandle = 203,
	X10DTRail = 204,
	X10DTRandom = 205,
	X10DTString = 206,
	X10DTValRail = 207,
	X10DTPoint = 208,
	X10DTDistArrayLocalState = 209,

	X10DTRegion = 300,
	X10DTRectRegion = 301,
	X10DTEmptyRegion = 302,
	X10DTFullRegion = 303,
	X10DTPolyRegion = 304,


} x10dbg_type_t;


#endif /* _x10_DBG_TYPES_H_ */
