/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPMethod
extends CPPFunction
implements ICPPMethod {
    public CPPMethod(IASTDeclarator declarator) {
        super(declarator);
    }

    public IASTDeclaration getPrimaryDeclaration() {
        IASTDeclaration decl;
        IASTDeclarator dtor;
        if (this.declarations != null) {
            IASTDeclarator[] iASTDeclaratorArray = this.declarations;
            int n = this.declarations.length;
            int n2 = 0;
            while (n2 < n) {
                dtor = iASTDeclaratorArray[n2];
                if (dtor == null) break;
                IASTDeclaration decl2 = (IASTDeclaration)(dtor = ASTQueries.findOutermostDeclarator(dtor)).getParent();
                if (decl2.getParent() instanceof ICPPASTCompositeTypeSpecifier) {
                    return decl2;
                }
                ++n2;
            }
        }
        if (this.definition != null && (decl = (IASTDeclaration)(dtor = ASTQueries.findOutermostDeclarator(this.definition)).getParent()).getParent() instanceof ICPPASTCompositeTypeSpecifier) {
            return decl;
        }
        char[] myName = this.getASTName().getLookupKey();
        ICPPClassScope scope = (ICPPClassScope)this.getScope();
        ICPPASTCompositeTypeSpecifier compSpec = (ICPPASTCompositeTypeSpecifier)ASTInternal.getPhysicalNodeOfScope(scope);
        if (compSpec != null) {
            IASTDeclaration[] members;
            IASTDeclaration[] iASTDeclarationArray = members = compSpec.getMembers();
            int n = members.length;
            int n3 = 0;
            while (n3 < n) {
                IASTFunctionDeclarator declarator;
                IASTName name;
                IASTDeclaration member = iASTDeclarationArray[n3];
                if (member instanceof IASTSimpleDeclaration) {
                    IASTDeclarator[] dtors;
                    IASTDeclarator[] iASTDeclaratorArray = dtors = ((IASTSimpleDeclaration)member).getDeclarators();
                    int n4 = dtors.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        IASTDeclarator dtor2 = iASTDeclaratorArray[n5];
                        IASTName name2 = ASTQueries.findInnermostDeclarator(dtor2).getName();
                        if (CharArrayUtils.equals(name2.getLookupKey(), myName) && name2.resolveBinding() == this) {
                            return member;
                        }
                        ++n5;
                    }
                } else if (member instanceof IASTFunctionDefinition && CharArrayUtils.equals((name = ASTQueries.findInnermostDeclarator(declarator = ((IASTFunctionDefinition)member).getDeclarator()).getName()).getLookupKey(), myName) && name.resolveBinding() == this) {
                    return member;
                }
                ++n3;
            }
        }
        return null;
    }

    public int getVisibility() {
        IASTDeclaration decl = this.getPrimaryDeclaration();
        if (decl == null) {
            ICPPClassType cls;
            IScope scope = this.getScope();
            if (scope instanceof ICPPClassScope && (cls = ((ICPPClassScope)scope).getClassType()) != null) {
                return cls.getKey() == 3 ? 3 : 1;
            }
            return 3;
        }
        IASTCompositeTypeSpecifier cls = (IASTCompositeTypeSpecifier)decl.getParent();
        IASTDeclaration[] members = cls.getMembers();
        ICPPASTVisibilityLabel vis = null;
        IASTDeclaration[] iASTDeclarationArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration member = iASTDeclarationArray[n2];
            if (member instanceof ICPPASTVisibilityLabel) {
                vis = (ICPPASTVisibilityLabel)member;
            } else if (member == decl) break;
            ++n2;
        }
        if (vis != null) {
            return vis.getVisibility();
        }
        if (cls.getKey() == 3) {
            return 3;
        }
        return 1;
    }

    public ICPPClassType getClassOwner() {
        ICPPClassScope scope = (ICPPClassScope)this.getScope();
        return scope.getClassType();
    }

    protected IASTName getASTName() {
        IASTDeclarator dtor = this.declarations != null && this.declarations.length > 0 ? this.declarations[0] : this.definition;
        IASTName name = (dtor = ASTQueries.findInnermostDeclarator(dtor)).getName();
        if (name instanceof ICPPASTQualifiedName) {
            IASTName[] ns = ((ICPPASTQualifiedName)name).getNames();
            name = ns[ns.length - 1];
        }
        return name;
    }

    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.getASTName());
    }

    public boolean isVirtual() {
        ICPPASTDeclSpecifier declSpec;
        IASTDeclaration decl = this.getPrimaryDeclaration();
        if (decl != null && (declSpec = this.getDeclSpec(decl)) != null) {
            return declSpec.isVirtual();
        }
        return false;
    }

    protected ICPPASTDeclSpecifier getDeclSpec(IASTDeclaration decl) {
        ICPPASTDeclSpecifier declSpec = null;
        if (decl instanceof IASTSimpleDeclaration) {
            declSpec = (ICPPASTDeclSpecifier)((IASTSimpleDeclaration)decl).getDeclSpecifier();
        } else if (decl instanceof IASTFunctionDefinition) {
            declSpec = (ICPPASTDeclSpecifier)((IASTFunctionDefinition)decl).getDeclSpecifier();
        }
        return declSpec;
    }

    public boolean isInline() {
        IASTDeclaration decl = this.getPrimaryDeclaration();
        if (decl instanceof IASTFunctionDefinition) {
            return true;
        }
        if (decl == null) {
            return false;
        }
        IASTDeclSpecifier declSpec = ((IASTSimpleDeclaration)decl).getDeclSpecifier();
        return declSpec.isInline();
    }

    public boolean isMutable() {
        return CPPMethod.hasStorageClass(this, 6);
    }

    public boolean isStatic(boolean resolveAll) {
        ICPPASTDeclSpecifier declSpec;
        IASTDeclaration decl = this.getPrimaryDeclaration();
        if (decl != null && (declSpec = this.getDeclSpec(decl)) != null) {
            return declSpec.getStorageClass() == 3;
        }
        return false;
    }

    public boolean isDestructor() {
        char[] name = this.getNameCharArray();
        return name.length > 1 && name[0] == '~';
    }

    public boolean isImplicit() {
        return false;
    }

    public boolean isPureVirtual() {
        if (this.declarations != null) {
            IASTDeclarator[] iASTDeclaratorArray = this.declarations;
            int n = this.declarations.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclarator dtor = iASTDeclaratorArray[n2];
                if (dtor == null) break;
                IASTDeclaration decl = (IASTDeclaration)(dtor = ASTQueries.findOutermostDeclarator(dtor)).getParent();
                if (decl.getParent() instanceof ICPPASTCompositeTypeSpecifier && (dtor = ASTQueries.findTypeRelevantDeclarator(dtor)) instanceof ICPPASTFunctionDeclarator) {
                    return ((ICPPASTFunctionDeclarator)dtor).isPureVirtual();
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean isExplicit() {
        ICPPASTDeclSpecifier declspec;
        IASTDeclaration decl = this.getPrimaryDeclaration();
        if (decl != null && (declspec = this.getDeclSpec(decl)) != null) {
            return declspec.isExplicit();
        }
        return false;
    }
}

