/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.model;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.IVariableDeclaration;
import org.eclipse.ptp.internal.rdt.core.model.CElementInfo;
import org.eclipse.ptp.internal.rdt.core.model.Parent;
import org.eclipse.ptp.internal.rdt.core.model.SourceManipulation;
import org.eclipse.ptp.internal.rdt.core.model.VariableInfo;

public class VariableDeclaration
extends SourceManipulation
implements IVariableDeclaration {
    private static final long serialVersionUID = 1L;
    protected String fTypeName = "";
    protected boolean fIsStatic;
    protected boolean fIsConst;
    protected boolean fIsVolatile;

    public VariableDeclaration(Parent parent, String variableName) {
        super((ICElement)parent, 77, variableName);
    }

    protected VariableDeclaration(Parent parent, int kind, String name) {
        super((ICElement)parent, kind, name);
    }

    protected VariableDeclaration(Parent parent, IVariableDeclaration element) throws CModelException {
        super((ICElement)parent, (ICElement)element, (ISourceReference)element);
        this.fTypeName = element.getTypeName();
        this.fIsStatic = element.isStatic();
        this.fIsConst = element.isConst();
        this.fIsVolatile = element.isVolatile();
    }

    protected VariableDeclaration(Parent parent, int type, IVariable binding) throws DOMException {
        super((ICElement)parent, type, binding.getName());
        IType astType = binding.getType();
        if (astType != null) {
            this.setTypeName(ASTTypeUtil.getType((IType)astType, (boolean)false));
        }
        this.fIsStatic = binding.isStatic();
    }

    public String getTypeName() {
        return this.fTypeName;
    }

    public void setTypeName(String type) {
        this.fTypeName = type;
    }

    public boolean isConst() {
        return this.fIsConst;
    }

    public boolean isStatic() {
        return this.fIsStatic;
    }

    public boolean isVolatile() {
        return this.fIsVolatile;
    }

    public void setConst(boolean isConst) {
        this.fIsConst = isConst;
    }

    public void setVolatile(boolean isVolatile) {
        this.fIsVolatile = isVolatile;
    }

    public void setStatic(boolean isStatic) {
        this.fIsStatic = isStatic;
    }

    public VariableInfo getVariableInfo() {
        if (this.fInfo == null) {
            this.fInfo = new VariableInfo(this);
        }
        return (VariableInfo)this.fInfo;
    }

    public CElementInfo getElementInfo() {
        return this.getVariableInfo();
    }
}

