/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionSet;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Conversions;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.FunctionSetType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class ExpressionTypes {
    public static IType glvalueType(IType type) {
        return SemanticUtil.getNestedType(type, 3);
    }

    public static IType prvalueType(IType type) {
        return Conversions.lvalue_to_rvalue(type);
    }

    public static IASTExpression.ValueCategory valueCategoryFromFunctionCall(ICPPFunction function) {
        ICPPFunctionType ft = function.getType();
        return ExpressionTypes.valueCategoryFromReturnType(ft.getReturnType());
    }

    public static IASTExpression.ValueCategory valueCategoryFromReturnType(IType r) {
        if ((r = SemanticUtil.getNestedType(r, 1)) instanceof ICPPReferenceType) {
            ICPPReferenceType refType = (ICPPReferenceType)r;
            if (!refType.isRValueReference()) {
                return IASTExpression.ValueCategory.LVALUE;
            }
            if (SemanticUtil.getNestedType(refType.getType(), 7) instanceof IFunctionType) {
                return IASTExpression.ValueCategory.LVALUE;
            }
            return IASTExpression.ValueCategory.XVALUE;
        }
        return IASTExpression.ValueCategory.PRVALUE;
    }

    public static IType typeFromFunctionCall(ICPPFunction function) {
        ICPPFunctionType ft = function.getType();
        return ExpressionTypes.typeFromReturnType(ft.getReturnType());
    }

    public static IType typeFromReturnType(IType r) {
        if ((r = SemanticUtil.getNestedType(r, 1)) instanceof ICPPReferenceType) {
            return ExpressionTypes.glvalueType(r);
        }
        return ExpressionTypes.prvalueType(r);
    }

    public static IType typeOrFunctionSet(IASTExpression e) {
        FunctionSetType fs = ExpressionTypes.getFunctionSetType(e);
        if (fs != null) {
            return fs;
        }
        return e.getExpressionType();
    }

    public static IASTExpression.ValueCategory valueCat(IASTExpression e) {
        FunctionSetType fs = ExpressionTypes.getFunctionSetType(e);
        if (fs != null) {
            return fs.getValueCategory();
        }
        return e.getValueCategory();
    }

    private static FunctionSetType getFunctionSetType(IASTExpression e) {
        IASTIdExpression idexpr;
        IASTName name;
        IBinding b;
        boolean addressOf = false;
        while (e instanceof IASTUnaryExpression) {
            IASTUnaryExpression unary = (IASTUnaryExpression)e;
            int op = unary.getOperator();
            if (op == 11) {
                e = unary.getOperand();
                continue;
            }
            if (addressOf || op != 5) break;
            addressOf = true;
            e = unary.getOperand();
        }
        if (e instanceof IASTIdExpression && (b = (name = (idexpr = (IASTIdExpression)e).getName()).resolvePreBinding()) instanceof CPPFunctionSet) {
            return new FunctionSetType(((CPPFunctionSet)b).getBindings(), name, addressOf);
        }
        return null;
    }
}

