/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.core.remotemake;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.CMacroEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector3;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.core.scannerconfig.ScannerInfoTypes;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.rdt.core.RDTLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectDescriptionCollector
implements IScannerInfoCollector3 {
    private IProject fProject;
    private InfoContext fInfoContext;
    private static final SettingFactory MACRO_FACTORY = new SettingFactory(){

        public ICLanguageSettingEntry createEntry(String value) {
            String[] split = value.split("=");
            switch (split.length) {
                case 2: {
                    return new CMacroEntry(split[0], split[1], 0);
                }
            }
            return new CMacroEntry(value, null, 0);
        }
    };
    private static final SettingFactory INCLUDE_PATH_FACTORY = new SettingFactory(){

        public ICLanguageSettingEntry createEntry(String value) {
            return new CIncludePathEntry(value, 0);
        }
    };

    public void contributeToScannerConfig(Object resource, Map scannerInfo) {
        if (!(resource instanceof IResource)) {
            return;
        }
        Map info = scannerInfo;
        IProject project = ((IResource)resource).getProject();
        ICProjectDescription projectDescription = CoreModel.getDefault().getProjectDescription(project, true);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = projectDescription.getConfigurations();
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription config = iCConfigurationDescriptionArray[n2];
            if (config.getRootFolderDescription() != null) {
                ICLanguageSetting[] iCLanguageSettingArray = config.getRootFolderDescription().getLanguageSettings();
                int n3 = iCLanguageSettingArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICLanguageSetting setting = iCLanguageSettingArray[n4];
                    List paths = (List)info.get(ScannerInfoTypes.INCLUDE_PATHS);
                    this.addSettingEntries(setting, 1, paths, INCLUDE_PATH_FACTORY);
                    List macros = (List)info.get(ScannerInfoTypes.SYMBOL_DEFINITIONS);
                    this.addSettingEntries(setting, 4, macros, MACRO_FACTORY);
                    ++n4;
                }
            }
            ++n2;
        }
        try {
            CoreModel.getDefault().setProjectDescription(project, projectDescription);
        }
        catch (CoreException e) {
            RDTLog.logError(e);
        }
    }

    private void addSettingEntries(ICLanguageSetting setting, int settingType, List<String> values, SettingFactory factory) {
        if (values.isEmpty()) {
            return;
        }
        LinkedHashSet<ICLanguageSettingEntry> entries = new LinkedHashSet<ICLanguageSettingEntry>();
        List existingEntries = setting.getSettingEntriesList(settingType);
        entries.addAll(existingEntries);
        for (String value : values) {
            entries.add(factory.createEntry(value));
        }
        setting.setSettingEntries(settingType, new ArrayList(entries));
    }

    public List getCollectedScannerInfo(Object resource, ScannerInfoTypes type) {
        return null;
    }

    public void setInfoContext(InfoContext context) {
        this.fInfoContext = context;
        this.fProject = this.fInfoContext.getProject();
    }

    public IDiscoveredPathManager.IDiscoveredPathInfo createPathInfoObject() {
        return new DiscoveredPathInfo(this.fProject);
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    public void updateScannerConfiguration(IProgressMonitor monitor) throws CoreException {
    }

    private static interface SettingFactory {
        public ICLanguageSettingEntry createEntry(String var1);
    }
}

