/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IResource;
import org.eclipse.ptp.rdt.sync.core.messages.Messages;
import org.eclipse.ui.IMemento;

public abstract class ResourceMatcher {
    private static final String ATTR_CLASS_NAME = "class-name";

    public abstract boolean match(IResource var1);

    public abstract String toString();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public void saveMatcher(IMemento memento) {
        memento.putString(ATTR_CLASS_NAME, this.getClass().getName());
    }

    public static ResourceMatcher loadMatcher(IMemento memento) throws InvocationTargetException, ParserConfigurationException {
        block21: {
            String className = memento.getString(ATTR_CLASS_NAME);
            if (className == null) {
                throw new ParserConfigurationException(Messages.ResourceMatcher_1);
            }
            try {
                if (!ResourceMatcher.class.isAssignableFrom(Class.forName(className)) || Modifier.isAbstract(Class.forName(className).getModifiers())) {
                    throw new ParserConfigurationException(Messages.ResourceMatcher_2);
                }
                boolean hasMethod = true;
                Method subClassMethod = null;
                try {
                    subClassMethod = Class.forName(className).getDeclaredMethod("loadMatcher", IMemento.class);
                }
                catch (SecurityException securityException) {
                    hasMethod = false;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    hasMethod = false;
                }
                if (hasMethod && subClassMethod != null) {
                    try {
                        return (ResourceMatcher)subClassMethod.invoke(Class.forName(className), memento);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        assert (false);
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
                hasMethod = true;
                Constructor<?> subClassConstructor = null;
                try {
                    subClassConstructor = Class.forName(className).getConstructor(new Class[0]);
                }
                catch (SecurityException securityException) {
                    hasMethod = false;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    hasMethod = false;
                }
                if (!hasMethod || subClassConstructor == null) break block21;
                try {
                    return (ResourceMatcher)subClassConstructor.newInstance(new Object[0]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    assert (false);
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ParserConfigurationException(String.valueOf(Messages.ResourceMatcher_0) + className);
            }
        }
        throw new ParserConfigurationException(Messages.ResourceMatcher_3);
    }
}

