/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.core.analysis;

import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTCallStmtNode;
import org.eclipse.photran.internal.core.parser.ASTNameNode;
import org.eclipse.photran.internal.core.parser.ASTVarOrFnRefNode;
import org.eclipse.photran.internal.core.parser.GenericASTVisitor;
import org.eclipse.ptp.pldt.common.Artifact;
import org.eclipse.ptp.pldt.common.ScanReturn;
import org.eclipse.ptp.pldt.common.util.SourceInfo;

public class MpiFortranASTVisitor
extends GenericASTVisitor {
    private static final String PREFIX = "MPI_";
    private static final boolean traceOn = false;
    private final ScanReturn scanReturn;
    private final String fileName;

    public void visitASTCallStmtNode(ASTCallStmtNode node) {
        Token subroutineName = node.getSubroutineName();
        this.addArtifact(subroutineName, 1);
    }

    public void visitASTVarOrFnRefNode(ASTVarOrFnRefNode node) {
        ASTNameNode nameNode = node.getName();
        if (nameNode != null) {
            Token varName = nameNode.getName();
            this.addArtifact(varName, 2);
        }
    }

    private void addArtifact(Token subroutineName, int artifactType) {
        String callname = subroutineName.getText().toUpperCase();
        if (callname.startsWith(PREFIX)) {
            int start = subroutineName.getFileOffset();
            int end = subroutineName.getFileOffset() + subroutineName.getLength();
            SourceInfo si = new SourceInfo(subroutineName.getLine(), start, end, artifactType);
            this.scanReturn.addArtifact(new Artifact(this.fileName, subroutineName.getLine(), 1, callname, si));
        }
    }

    public MpiFortranASTVisitor(String fileName, ScanReturn scanReturn) {
        this.scanReturn = scanReturn;
        this.fileName = fileName;
    }
}

