/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.loops;

import java.util.HashSet;
import org.eclipse.photran.internal.core.analysis.loops.ASTVisitorWithLoops;
import org.eclipse.photran.internal.core.analysis.loops.IASTVisitorWithLoops;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTEndDoStmtNode;
import org.eclipse.photran.internal.core.parser.ASTExitStmtNode;
import org.eclipse.photran.internal.core.parser.ASTIntConstNode;
import org.eclipse.photran.internal.core.parser.ASTLabelDoStmtNode;
import org.eclipse.photran.internal.core.parser.ASTListNode;
import org.eclipse.photran.internal.core.parser.ASTLoopControlNode;
import org.eclipse.photran.internal.core.parser.ASTNode;
import org.eclipse.photran.internal.core.parser.ASTUnaryExprNode;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IASTVisitor;
import org.eclipse.photran.internal.core.parser.IExecutableConstruct;
import org.eclipse.photran.internal.core.parser.IExecutionPartConstruct;
import org.eclipse.photran.internal.core.parser.IExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTProperLoopConstructNode
extends ASTNode
implements IExecutableConstruct {
    private ASTLabelDoStmtNode loopHeader;
    private IASTListNode<IExecutionPartConstruct> body = new ASTListNode<IExecutionPartConstruct>();
    private ASTEndDoStmtNode endDoStmt;

    public ASTProperLoopConstructNode() {
        this.body.setParent(this);
    }

    public ASTLabelDoStmtNode getLoopHeader() {
        return this.loopHeader;
    }

    public void setLoopHeader(ASTLabelDoStmtNode header) {
        this.loopHeader = header;
        if (header != null) {
            header.setParent(this);
        }
    }

    public IASTListNode<IExecutionPartConstruct> getBody() {
        return this.body;
    }

    public ASTEndDoStmtNode getEndDoStmt() {
        return this.endDoStmt;
    }

    public void setEndDoStmt(ASTEndDoStmtNode endDoStmt) {
        this.endDoStmt = endDoStmt;
        if (endDoStmt != null) {
            endDoStmt.setParent(this);
        }
    }

    @Override
    public void accept(IASTVisitor visitor) {
        if (visitor instanceof IASTVisitorWithLoops) {
            ((IASTVisitorWithLoops)visitor).visitASTProperLoopConstructNode(this);
        }
        visitor.visitIExecutableConstruct(this);
        visitor.visitASTNode(this);
    }

    @Override
    protected int getNumASTFields() {
        return 3;
    }

    @Override
    protected IASTNode getASTField(int index) {
        switch (index) {
            case 0: {
                return this.loopHeader;
            }
            case 1: {
                return this.body;
            }
            case 2: {
                return this.endDoStmt;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected void setASTField(int index, IASTNode value) {
        switch (index) {
            case 0: {
                this.loopHeader = (ASTLabelDoStmtNode)value;
                if (this.loopHeader == null) break;
                this.loopHeader.setParent(this);
                break;
            }
            case 1: {
                this.body = (IASTListNode)value;
                if (this.body == null) break;
                this.body.setParent(this);
                break;
            }
            case 2: {
                this.endDoStmt = (ASTEndDoStmtNode)value;
                if (this.endDoStmt == null) break;
                this.endDoStmt.setParent(this);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private ASTLoopControlNode getLoopControl() {
        return this.getLoopHeader().getLoopControl();
    }

    public boolean isDoWhileLoop() {
        return this.getLoopHeader().getLoopControl().getVariableName() == null;
    }

    public IExpr getLowerBoundIExpr() {
        ASTLoopControlNode node = this.getLoopControl();
        return node.getLb();
    }

    public void setLowerBoundIExpr(int newLower) {
        ASTLoopControlNode node = this.getLoopControl();
        IExpr low = node.getLb();
        low.replaceWith(Integer.toString(newLower));
    }

    public IExpr getUpperBoundIExpr() {
        ASTLoopControlNode node = this.getLoopControl();
        return node.getUb();
    }

    public void setUpperBoundIExpr(int newUpper) {
        ASTLoopControlNode node = this.getLoopControl();
        IExpr upper = node.getUb();
        upper.replaceWith(Integer.toString(newUpper));
    }

    public int getLowerBoundInt() throws NumberFormatException {
        ASTLoopControlNode node = this.getLoopControl();
        IExpr expr = node.getLb();
        if (expr instanceof ASTIntConstNode) {
            return Integer.parseInt(expr.findFirstToken().getText().trim());
        }
        throw new NumberFormatException();
    }

    public int getUpperBoundInt() {
        ASTLoopControlNode node = this.getLoopControl();
        IExpr expr = node.getUb();
        if (expr instanceof ASTIntConstNode) {
            return Integer.parseInt(expr.findFirstToken().getText().trim());
        }
        throw new NumberFormatException();
    }

    public int getStepInt() {
        ASTLoopControlNode node = this.getLoopControl();
        IExpr expr = node.getStep();
        if (expr instanceof ASTIntConstNode || expr instanceof ASTUnaryExprNode && ((ASTUnaryExprNode)expr).getOperand() instanceof ASTIntConstNode) {
            return Integer.parseInt(expr.toString().trim());
        }
        if (expr == null) {
            return 1;
        }
        throw new NumberFormatException();
    }

    public void setStepInt(int newStep) {
        ASTLoopControlNode node = this.getLoopControl();
        IExpr step = node.getStep();
        if (step == null) {
            String s = "," + Integer.toString(newStep);
            Token newVal = new Token(Terminal.T_ICON, s);
            ASTIntConstNode newStepVar = new ASTIntConstNode();
            newStepVar.setIntConst(newVal);
            node.setStep(newStepVar);
        } else {
            step.replaceWith(Integer.toString(newStep));
        }
    }

    public Token getIndexVariable() {
        return this.getLoopHeader().getLoopControl().getVariableName();
    }

    public HashSet<ASTExitStmtNode> getExits() {
        final HashSet<ASTExitStmtNode> exits = new HashSet<ASTExitStmtNode>();
        this.getBody().accept(new ASTVisitorWithLoops(){

            public void visitASTExitStmtNode(ASTExitStmtNode node) {
                exits.add(node);
            }
        });
        return exits;
    }
}

