/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui;

import java.util.Arrays;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class OverlayImageDescriptor
extends CompositeImageDescriptor {
    private static final int DEFAULT_WIDTH = 16;
    private static final int DEFAULT_HEIGHT = 16;
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;
    private Image base;
    private ImageDescriptor[] overlays;
    private Point size;

    public OverlayImageDescriptor(Image base, ImageDescriptor[] overlays) {
        this(base, overlays, new Point(16, 16));
    }

    public OverlayImageDescriptor(Image base, ImageDescriptor[] overlays, Point size) {
        this.setBase(base);
        this.setOverlays(overlays);
        this.setSize(size);
    }

    protected void drawOverlays(ImageDescriptor[] overlays) {
        Point size = this.getSize();
        int i = 0;
        while (i < overlays.length) {
            ImageDescriptor overlay = overlays[i];
            if (overlay != null) {
                ImageData overlayData = overlay.getImageData();
                if (overlayData == null) {
                    overlayData = ImageDescriptor.getMissingImageDescriptor().getImageData();
                }
                switch (i) {
                    case 0: {
                        this.drawImage(overlayData, 0, 0);
                        break;
                    }
                    case 1: {
                        this.drawImage(overlayData, size.x - overlayData.width, 0);
                        break;
                    }
                    case 2: {
                        this.drawImage(overlayData, 0, size.y - overlayData.height);
                        break;
                    }
                    case 3: {
                        this.drawImage(overlayData, size.x - overlayData.width, size.y - overlayData.height);
                    }
                }
            }
            ++i;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof OverlayImageDescriptor)) {
            return false;
        }
        OverlayImageDescriptor other = (OverlayImageDescriptor)((Object)o);
        return this.getBase().equals((Object)other.getBase()) && Arrays.equals(this.getOverlays(), other.getOverlays());
    }

    public int hashCode() {
        int code = this.getBase().hashCode();
        int i = 0;
        while (i < this.getOverlays().length) {
            if (this.getOverlays()[i] != null) {
                code ^= this.getOverlays()[i].hashCode();
            }
            ++i;
        }
        return code;
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage(this.getBase().getImageData(), 0, 0);
        this.drawOverlays(this.getOverlays());
    }

    protected Point getSize() {
        return this.size;
    }

    private Image getBase() {
        return this.base;
    }

    private void setBase(Image base) {
        this.base = base;
    }

    private ImageDescriptor[] getOverlays() {
        return this.overlays;
    }

    private void setOverlays(ImageDescriptor[] overlays) {
        this.overlays = overlays;
    }

    private void setSize(Point size) {
        this.size = size;
    }
}

