/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.preservation;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.rephraserengine.core.vpg.IVPGNode;
import org.eclipse.rephraserengine.core.vpg.VPGEdge;
import org.eclipse.rephraserengine.core.vpg.eclipse.EclipseVPG;

final class ModelDiff {
    private Set<String> filesWithAllEdgesDeleted = new TreeSet<String>();
    private Set<DiffEntry> differences = new HashSet<DiffEntry>();

    ModelDiff() {
    }

    void recordFileWithNoEdges(String filename) {
        this.filesWithAllEdgesDeleted.add(filename);
    }

    void add(DiffEntry entry) {
        this.differences.add(entry);
    }

    public void processUsing(ModelDiffProcessor processor) {
        if (!this.filesWithAllEdgesDeleted.isEmpty()) {
            processor.processAllEdgesDeleted(this.filesWithAllEdgesDeleted);
        }
        for (DiffEntry entry : this.differences) {
            entry.accept(processor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class DiffEntry {
        public final VPGEdge<?, ?, ?> edge;

        public DiffEntry(VPGEdge<?, ?, ?> edge) {
            this.edge = edge.getOriginalEdge();
        }

        protected abstract void accept(ModelDiffProcessor var1);

        public IFile getFileContainingSourceRegion() {
            return EclipseVPG.getIFileForFilename(((IVPGNode)this.edge.getSource()).getFilename());
        }

        public IRegion getSourceRegion() {
            return new Region(((IVPGNode)this.edge.getSource()).getOffset(), ((IVPGNode)this.edge.getSource()).getLength());
        }

        public IFile getFileContainingSinkRegion() {
            return EclipseVPG.getIFileForFilename(((IVPGNode)this.edge.getSink()).getFilename());
        }

        public IRegion getSinkRegion() {
            return new Region(((IVPGNode)this.edge.getSink()).getOffset(), ((IVPGNode)this.edge.getSink()).getLength());
        }

        public boolean equals(Object other) {
            if (other == null || !other.getClass().equals(this.getClass())) {
                return false;
            }
            DiffEntry that = (DiffEntry)other;
            return this.edge.equals(that.edge);
        }

        public int hashCode() {
            return this.edge.hashCode();
        }

        public String toString() {
            return this.edge.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EdgeAdded
    extends DiffEntry {
        public EdgeAdded(VPGEdge<?, ?, ?> edge) {
            super(edge);
        }

        @Override
        protected void accept(ModelDiffProcessor processor) {
            processor.processEdgeAdded(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EdgeDeleted
    extends DiffEntry {
        public EdgeDeleted(VPGEdge<?, ?, ?> edge) {
            super(edge);
        }

        @Override
        protected void accept(ModelDiffProcessor processor) {
            processor.processEdgeDeleted(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EdgeSinkChanged
    extends DiffEntry {
        public final VPGEdge<?, ?, ?> newEdge;

        public EdgeSinkChanged(VPGEdge<?, ?, ?> edge, VPGEdge<?, ?, ?> newEdge) {
            super(edge);
            this.newEdge = newEdge.getOriginalEdge();
        }

        @Override
        protected void accept(ModelDiffProcessor processor) {
            processor.processEdgeSinkChanged(this);
        }

        public IFile getFileContainingNewSinkRegion() {
            return EclipseVPG.getIFileForFilename(((IVPGNode)this.newEdge.getSink()).getFilename());
        }

        public IRegion getNewSinkRegion() {
            Object newSink = this.newEdge.getSink();
            return new Region(newSink.getOffset(), newSink.getLength());
        }

        @Override
        public String toString() {
            return String.valueOf(this.edge.toString()) + " will become " + this.newEdge.toString();
        }

        @Override
        public boolean equals(Object other) {
            return super.equals(other) && this.newEdge.equals(((EdgeSinkChanged)other).newEdge);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 17 * this.newEdge.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ModelDiffProcessor {
        public abstract void processEdgeAdded(EdgeAdded var1);

        public abstract void processEdgeDeleted(EdgeDeleted var1);

        public abstract void processAllEdgesDeleted(Set<String> var1);

        public abstract void processEdgeSinkChanged(EdgeSinkChanged var1);
    }
}

