/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.gem.popup.actions;

import java.net.URI;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.gem.GemPlugin;
import org.eclipse.ptp.gem.messages.Messages;
import org.eclipse.ptp.gem.util.GemUtilities;
import org.eclipse.ptp.rdt.sync.core.BuildConfigurationManager;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class VerificationPopUpAction
implements IObjectActionDelegate {
    private IStructuredSelection selection;

    public void run(IAction action) {
        if (this.selection == null) {
            return;
        }
        if (this.selection.toString().equals("<empty selection>")) {
            GemUtilities.showErrorDialog(Messages.VerificationPopUpAction_0);
        } else {
            Object selectionElement = this.selection.getFirstElement();
            IResource resource = null;
            if (selectionElement instanceof IResource) {
                resource = (IResource)selectionElement;
            } else if (selectionElement instanceof ICElement) {
                resource = ((ICElement)selectionElement).getResource();
            }
            if (resource != null) {
                String id = action.getId();
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                IPreferenceStore pstore = GemPlugin.getDefault().getPreferenceStore();
                try {
                    GemUtilities.setCommandLineArgs();
                    String activeView = pstore.getString("activeViewPreference");
                    if (activeView.equals("analyzer")) {
                        page.showView("org.eclipse.ptp.gem.views.GemBrowser");
                        page.showView("org.eclipse.ptp.gem.views.GemAnalyzer");
                    } else {
                        page.showView("org.eclipse.ptp.gem.views.GemAnalyzer");
                        page.showView("org.eclipse.ptp.gem.views.GemBrowser");
                    }
                    page.showView("org.eclipse.ptp.gem.views.GemConsole");
                    boolean isValidSourceFile = id.equals("org.eclipse.ptp.gem.verificationPopupC") || id.equals("org.eclipse.ptp.gem.verificationPopupCpp") || id.equals("org.eclipse.ptp.gem.verificationPopupC++") || id.equals("org.eclipse.ptp.gem.verificationPopupCp") || id.equals("org.eclipse.ptp.gem.verificationPopupCc");
                    boolean isSync = GemUtilities.isSynchronizedProject(resource);
                    URI resourceLocation = null;
                    try {
                        resourceLocation = isSync ? BuildConfigurationManager.getInstance().getActiveSyncLocationURI(resource) : resource.getLocationURI();
                    }
                    catch (CoreException e) {
                        GemUtilities.logExceptionDetail((Exception)((Object)e));
                    }
                    GemUtilities.saveMostRecentURI(resourceLocation);
                    GemUtilities.initGemViews(resource, isValidSourceFile, true);
                }
                catch (PartInitException e) {
                    GemUtilities.logExceptionDetail((Exception)((Object)e));
                }
            } else {
                GemUtilities.showErrorDialog(Messages.VerificationPopUpAction_1);
                return;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

