/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.internal.core.model;

import java.math.BigInteger;
import org.eclipse.ptp.rm.lml.internal.core.elements.ObjectFactory;
import org.eclipse.ptp.rm.lml.internal.core.elements.SchemeElement;
import org.eclipse.ptp.rm.lml.internal.core.model.LMLCheck;

public class Mask {
    private static final String number = "\\s*(-|\\+)?(0x|0X)?([a-fA-F\\d]+)";
    private String maskstring;
    private String regularMask;
    private int outputlength;
    private String pre;
    private String post;
    private String[] names;
    private final SchemeElement scheme;
    private int[] numbers = null;

    public static void main(String[] args) {
        ObjectFactory objf = new ObjectFactory();
        SchemeElement scheme = objf.createSchemeElement();
        scheme.setMin(BigInteger.valueOf(5L));
        scheme.setMax(BigInteger.valueOf(10L));
        scheme.setStep(BigInteger.valueOf(1L));
        scheme.setMap("hans,peter,jupp");
        Mask m = new Mask(scheme);
        System.out.println(m.getNumberOfLevelstring("peter"));
    }

    public Mask(SchemeElement pscheme) {
        this.scheme = pscheme;
        if (pscheme.getMap() != null) {
            this.names = pscheme.getMap().split(",");
            this.outputlength = -1;
            this.regularMask = pscheme.getMap().replace(',', '|');
            this.pre = "";
            this.post = "";
            this.maskstring = "";
        } else {
            this.names = null;
            this.maskstring = pscheme.getMask();
            this.outputlength = this.maskstring.matches("([^%])*%(\\-|\\+|\\s|\\#)*d([^%])+") ? -1 : String.format(this.maskstring, 1).length();
            int percent = this.maskstring.indexOf(37);
            int dpos = this.maskstring.indexOf(100);
            this.pre = this.maskstring.substring(0, percent);
            this.post = this.maskstring.substring(dpos + 1, this.maskstring.length());
            this.regularMask = String.valueOf(this.pre) + number + this.post;
        }
    }

    public String getImplicitLevelname(int id) {
        return LMLCheck.getLevelName(this.scheme, id);
    }

    public String getMask() {
        return this.maskstring;
    }

    public int getNumberOfLevelstring(String levelstring) {
        if (this.names == null) {
            if (!this.isOutputAllowed(levelstring)) {
                return -1;
            }
            levelstring = levelstring.substring(this.pre.length());
            levelstring = levelstring.substring(0, levelstring.length() - this.post.length());
            char[] chars = levelstring.toCharArray();
            int i = 0;
            while (i < chars.length && chars[i] < '0' || chars[i] > '9') {
                ++i;
            }
            if (i == chars.length) {
                return -1;
            }
            String number = String.valueOf(chars[i]);
            ++i;
            while (i < chars.length && chars[i] >= '0' && chars[i] <= '9') {
                number = String.valueOf(number) + chars[i];
                ++i;
            }
            return Integer.parseInt(number);
        }
        int pos = 0;
        String[] stringArray = this.names;
        int n = this.names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.equals(levelstring)) {
                if (this.scheme.getList() != null) {
                    if (this.numbers == null) {
                        this.numbers = LMLCheck.getNumbersFromNumberlist(this.scheme.getList());
                    }
                    return this.numbers[pos];
                }
                int min = this.scheme.getMin().intValue();
                if (this.scheme.getMax() != null) {
                    this.scheme.getMax().intValue();
                }
                int step = this.scheme.getStep().intValue();
                return min + step * pos;
            }
            ++pos;
            ++n2;
        }
        return -1;
    }

    public int getOutputLength() {
        return this.outputlength;
    }

    public boolean isOutputAllowed(String output) {
        if (this.names == null) {
            return output.matches(this.regularMask) && (this.outputlength == -1 || this.outputlength == output.length());
        }
        String[] stringArray = this.names;
        int n = this.names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.equals(output)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

