/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.gem.popup.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.gem.GemPlugin;
import org.eclipse.ptp.gem.messages.Messages;
import org.eclipse.ptp.gem.util.GemUtilities;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class VerificationPopUpAction
implements IObjectActionDelegate {
    private IStructuredSelection selection;

    public void run(IAction action) {
        if (this.selection == null) {
            return;
        }
        if (this.selection.toString().equals("<empty selection>")) {
            GemUtilities.showErrorDialog(Messages.VerificationPopUpAction_0);
        } else {
            IFile inputFile = (IFile)this.selection.getFirstElement();
            String id = action.getId();
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            IPreferenceStore pstore = GemPlugin.getDefault().getPreferenceStore();
            try {
                boolean isValidSourceFile;
                GemUtilities.setCommandLineArgs();
                String activeView = pstore.getString("activeViewPreference");
                if (activeView.equals("analyzer")) {
                    page.showView("org.eclipse.ptp.gem.views.GemBrowser");
                    page.showView("org.eclipse.ptp.gem.views.GemAnalyzer");
                } else {
                    page.showView("org.eclipse.ptp.gem.views.GemAnalyzer");
                    page.showView("org.eclipse.ptp.gem.views.GemBrowser");
                }
                page.showView("org.eclipse.ptp.gem.views.GemConsole");
                boolean bl = isValidSourceFile = id.equals("org.eclipse.ptp.gem.verificationPopupC") || id.equals("org.eclipse.ptp.gem.verificationPopupCpp") || id.equals("org.eclipse.ptp.gem.verificationPopupC++") || id.equals("org.eclipse.ptp.gem.verificationPopupCp") || id.equals("org.eclipse.ptp.gem.verificationPopupCc");
                if (isValidSourceFile) {
                    GemUtilities.saveMostRecentURI(inputFile.getLocationURI());
                }
                GemUtilities.initGemViews(inputFile, isValidSourceFile, true);
            }
            catch (PartInitException e) {
                GemUtilities.logExceptionDetail((Exception)((Object)e));
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

