/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.core;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.WriteAccessException;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.internal.core.envvar.EnvironmentVariableManager;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ptp.rdt.core.serviceproviders.IRemoteExecutionServiceProvider;
import org.eclipse.ptp.rdt.sync.core.BuildScenario;
import org.eclipse.ptp.rdt.sync.core.RDTSyncCorePlugin;
import org.eclipse.ptp.rdt.sync.core.SyncRunner;
import org.eclipse.ptp.rdt.sync.core.messages.Messages;
import org.eclipse.ptp.rdt.sync.core.serviceproviders.ISyncServiceProvider;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.ptp.services.core.ServiceProvider;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class BuildConfigurationManager {
    private static final String projectScopeSyncNode = "org.eclipse.ptp.rdt.sync.core";
    private static final String configSyncDataStorageName = "org.eclipse.ptp.rdt.sync.core";
    private static final String TEMPLATE_KEY = "template-service-configuration";
    private static final String projectLocationPathVariable = "${project_loc}";
    private static final String localConfigAnnotation = "_local";
    private static final String remoteConfigAnnotation = "_remote";
    private static BuildConfigurationManager fInstance = null;

    private BuildConfigurationManager() {
    }

    public static synchronized BuildConfigurationManager getInstance() {
        if (fInstance == null) {
            fInstance = new BuildConfigurationManager();
        }
        return fInstance;
    }

    public BuildScenario createLocalBuildScenario(IProject project) throws CoreException {
        IRemoteServices localService = PTPRemoteCorePlugin.getDefault().getRemoteServices("org.eclipse.ptp.remote.LocalServices", null);
        if (localService != null) {
            IRemoteConnection localConnection = localService.getConnectionManager().getConnection("Local");
            if (localConnection != null) {
                return new BuildScenario(null, localConnection, projectLocationPathVariable);
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rdt.sync.core", Messages.BCM_LocalConnectionError));
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rdt.sync.core", Messages.BCM_LocalServiceError));
    }

    public IConfiguration createLocalConfiguration(IProject project, String configName) {
        this.checkProject(project);
        try {
            BuildScenario localBuildScenario = this.createLocalBuildScenario(project);
            if (localBuildScenario != null) {
                return this.createConfiguration(project, localBuildScenario, configName, Messages.BCM_WorkspaceConfigDes);
            }
        }
        catch (CoreException e) {
            RDTSyncCorePlugin.log(String.valueOf(Messages.BCM_CreateConfigFailure) + e.getMessage(), e);
        }
        return null;
    }

    public IConfiguration createRemoteConfiguration(IProject project, BuildScenario remoteBuildScenario, String configName, String configDesc) {
        this.checkProject(project);
        return this.createConfiguration(project, remoteBuildScenario, configName, configDesc);
    }

    public URI getActiveSyncLocationURI(IResource resource) throws CoreException {
        if (resource.getProject().hasNature("org.eclipse.ptp.rdt.sync.core.remoteSyncNature")) {
            IConfiguration configuration = ManagedBuildManager.getBuildInfo((IResource)resource.getProject()).getDefaultConfiguration();
            return this.getSyncLocationURI(configuration, resource);
        }
        return null;
    }

    public IServiceConfiguration getConfigurationForBuildConfiguration(IConfiguration bconf) {
        IProject project = bconf.getOwner().getProject();
        this.checkProject(project);
        BuildScenario bs = this.getBuildScenarioForBuildConfiguration(bconf);
        if (bs == null) {
            return null;
        }
        IServiceConfiguration sconf = this.copyTemplateServiceConfiguration(project);
        this.modifyServiceConfigurationForBuildScenario(sconf, project, bs);
        return sconf;
    }

    public SyncRunner getSyncRunnerForBuildConfiguration(IConfiguration bconf) {
        IProject project = bconf.getOwner().getProject();
        this.checkProject(project);
        ISyncServiceProvider provider = this.getProjectSyncServiceProvider(project);
        if (provider == null) {
            return null;
        }
        BuildScenario buildScenario = this.getBuildScenarioForBuildConfigurationInternal((IConfiguration)bconf).bs;
        if (buildScenario == null) {
            return null;
        }
        if (buildScenario.getSyncProvider() == null) {
            return null;
        }
        return new SyncRunner(provider);
    }

    private IServiceConfiguration copyTemplateServiceConfiguration(IProject project) {
        IServiceConfiguration newConfig = ServiceModelManager.getInstance().newServiceConfiguration("");
        if (newConfig == null) {
            throw new RuntimeException(Messages.BuildConfigurationManager_15);
        }
        String oldConfigId = BuildConfigurationManager.getTemplateServiceConfigurationId(project);
        if (oldConfigId == null) {
            RDTSyncCorePlugin.log(Messages.BuildConfigurationManager_9);
            return null;
        }
        IServiceConfiguration oldConfig = ServiceModelManager.getInstance().getConfiguration(oldConfigId);
        if (oldConfig == null) {
            RDTSyncCorePlugin.log(String.valueOf(Messages.BuildConfigurationManager_10) + oldConfigId + Messages.BuildConfigurationManager_11 + project.getName());
            return null;
        }
        for (IService service : oldConfig.getServices()) {
            ServiceProvider oldProvider = (ServiceProvider)oldConfig.getServiceProvider(service);
            try {
                ServiceProvider newProvider = (ServiceProvider)oldProvider.getClass().newInstance();
                XMLMemento oldProviderState = XMLMemento.createWriteRoot((String)"provider");
                oldProvider.saveState((IMemento)oldProviderState);
                newProvider.restoreState((IMemento)oldProviderState);
                newConfig.setServiceProvider(service, (IServiceProvider)newProvider);
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException(String.valueOf(Messages.BCM_ProviderError) + oldProvider.getClass());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(String.valueOf(Messages.BCM_ProviderError) + oldProvider.getClass());
            }
        }
        return newConfig;
    }

    private void modifyServiceConfigurationForBuildScenario(IServiceConfiguration sConfig, IProject project, BuildScenario bs) {
        IService syncService = null;
        for (IService service : sConfig.getServices()) {
            ServiceProvider provider = (ServiceProvider)sConfig.getServiceProvider(service);
            if (!(provider instanceof IRemoteExecutionServiceProvider)) continue;
            if (provider instanceof ISyncServiceProvider && bs.getSyncProvider() == null) {
                syncService = service;
                continue;
            }
            ((IRemoteExecutionServiceProvider)provider).setRemoteToolsConnection(bs.getRemoteConnection());
            ((IRemoteExecutionServiceProvider)provider).setConfigLocation(bs.getLocation(project));
        }
        if (syncService != null) {
            sConfig.disable(syncService);
        }
    }

    public String getProjectSyncProvider(IProject project) {
        ISyncServiceProvider provider = this.getProjectSyncServiceProvider(project);
        if (provider == null) {
            RDTSyncCorePlugin.log(String.valueOf(Messages.BuildConfigurationManager_13) + project.getName());
            return null;
        }
        return provider.getName();
    }

    private ISyncServiceProvider getProjectSyncServiceProvider(IProject project) {
        this.checkProject(project);
        String serviceConfigId = BuildConfigurationManager.getTemplateServiceConfigurationId(project);
        if (serviceConfigId == null) {
            RDTSyncCorePlugin.log(Messages.BuildConfigurationManager_9);
            return null;
        }
        IServiceConfiguration serviceConfig = ServiceModelManager.getInstance().getConfiguration(serviceConfigId);
        if (serviceConfig == null) {
            RDTSyncCorePlugin.log(String.valueOf(Messages.BuildConfigurationManager_10) + serviceConfigId + Messages.BuildConfigurationManager_11 + project.getName());
            return null;
        }
        IService syncService = ServiceModelManager.getInstance().getService("org.eclipse.ptp.rdt.sync.core.SyncService");
        if (syncService == null) {
            RDTSyncCorePlugin.log(Messages.BuildConfigurationManager_12);
            return null;
        }
        return (ISyncServiceProvider)serviceConfig.getServiceProvider(syncService);
    }

    public URI getSyncLocationURI(IConfiguration configuration, IResource resource) throws CoreException {
        BuildScenario scenario = this.getBuildScenarioForBuildConfiguration(configuration);
        if (scenario != null) {
            IPath path = new Path(scenario.location).append(resource.getProjectRelativePath());
            IRemoteConnection conn = scenario.getRemoteConnection();
            if (conn != null) {
                IRemoteFileManager fileMgr = scenario.getRemoteConnection().getRemoteServices().getFileManager(conn);
                return fileMgr.toURI(path);
            }
        }
        return null;
    }

    public void initProject(IProject project, IServiceConfiguration sc, BuildScenario bs) {
        IConfiguration[] allConfigs;
        if (project == null || sc == null || bs == null) {
            throw new NullPointerException();
        }
        ServiceModelManager smm = ServiceModelManager.getInstance();
        smm.addConfiguration(sc);
        try {
            smm.saveModelConfiguration();
        }
        catch (IOException e) {
            RDTSyncCorePlugin.log(e.toString(), e);
        }
        try {
            if (!project.hasNature("org.eclipse.ptp.rdt.sync.core.remoteSyncNature")) {
                throw new IllegalArgumentException(Messages.BuildConfigurationManager_6);
            }
        }
        catch (CoreException coreException) {
            throw new IllegalArgumentException(Messages.BuildConfigurationManager_8);
        }
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode("org.eclipse.ptp.rdt.sync.core");
        if (node == null) {
            throw new RuntimeException(Messages.BuildConfigurationManager_0);
        }
        node.put(TEMPLATE_KEY, sc.getId());
        BuildConfigurationManager.flushNode((Preferences)node);
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (buildInfo == null) {
            throw new RuntimeException(String.valueOf(Messages.BCM_BuildInfoError) + project.getName());
        }
        IConfiguration[] iConfigurationArray = allConfigs = buildInfo.getManagedProject().getConfigurations();
        int n = allConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration config = iConfigurationArray[n2];
            this.setBuildScenarioForBuildConfigurationInternal(bs, config);
            ++n2;
        }
    }

    public void setTemplateServiceConfiguration(IProject project, IServiceConfiguration sc) {
        this.checkProject(project);
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode("org.eclipse.ptp.rdt.sync.core");
        if (node == null) {
            throw new RuntimeException(Messages.BuildConfigurationManager_0);
        }
        node.put(TEMPLATE_KEY, sc.getId());
        BuildConfigurationManager.flushNode((Preferences)node);
    }

    public boolean isInitialized(IProject project) {
        if (project == null) {
            throw new NullPointerException();
        }
        return BuildConfigurationManager.getTemplateServiceConfigurationId(project) != null;
    }

    public IConfiguration createConfiguration(IProject project, BuildScenario buildScenario, String configName, String configDesc) {
        return this.createConfiguration(project, null, buildScenario, configName, configDesc);
    }

    public IConfiguration createConfiguration(IProject project, Configuration configParent, BuildScenario buildScenario, String configName, String configDesc) {
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (buildInfo == null) {
            throw new RuntimeException(String.valueOf(Messages.BCM_BuildInfoError) + project.getName());
        }
        Throwable creationException = null;
        String creationError = null;
        boolean configAdded = false;
        ManagedProject managedProject = (ManagedProject)buildInfo.getManagedProject();
        if (configParent == null) {
            configParent = (Configuration)buildInfo.getDefaultConfiguration();
        }
        String configId = ManagedBuildManager.calculateChildId((String)configParent.getId(), null);
        Configuration config = new Configuration(managedProject, configParent, configId, true, false);
        CConfigurationData configData = config.getConfigurationData();
        ICProjectDescription projectDes = CoreModel.getDefault().getProjectDescription(project);
        ICConfigurationDescription configDes = null;
        try {
            configDes = projectDes.createConfiguration("org.eclipse.cdt.managedbuilder.core.configurationDataProvider", configData);
        }
        catch (WriteAccessException e) {
            creationException = e;
        }
        catch (CoreException e) {
            creationException = e;
        }
        if (configDes != null) {
            configAdded = true;
            config.setConfigurationDescription(configDes);
            configDes.setName(configName);
            configDes.setDescription(configDesc);
            BuildConfigurationManager.setProjectDescription(project, projectDes);
            this.setBuildScenarioForBuildConfigurationInternal(buildScenario, (IConfiguration)config);
        } else {
            creationError = Messages.BCM_CreateConfigError;
        }
        if (!configAdded) {
            if (creationError == null && creationException != null) {
                creationError = creationException.getMessage();
            }
            RDTSyncCorePlugin.log(String.valueOf(Messages.BCM_CreateConfigFailure) + creationError, creationException);
            return null;
        }
        return config;
    }

    private void updateConfigurations(IProject project) {
        IConfiguration[] allConfigs;
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (buildInfo == null) {
            throw new RuntimeException(String.valueOf(Messages.BCM_BuildInfoError) + project.getName());
        }
        IConfiguration[] iConfigurationArray = allConfigs = buildInfo.getManagedProject().getConfigurations();
        int n = allConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration config = iConfigurationArray[n2];
            BuildScenarioAndConfiguration parentConfigInfo = this.getBuildScenarioForBuildConfigurationInternal(config);
            if (parentConfigInfo == null) {
                return;
            }
            if (parentConfigInfo.configId != config.getId()) {
                IConfiguration parentConfig = buildInfo.getManagedProject().getConfiguration(parentConfigInfo.configId);
                if (parentConfig != null) {
                    this.setBuildScenarioForBuildConfigurationInternal(parentConfigInfo.bs, config);
                } else {
                    RDTSyncCorePlugin.log(String.valueOf(Messages.BuildConfigurationManager_10) + parentConfigInfo.configId + Messages.BuildConfigurationManager_11 + project.getName());
                }
            }
            ++n2;
        }
    }

    private static String getTemplateServiceConfigurationId(IProject project) {
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode("org.eclipse.ptp.rdt.sync.core");
        if (node == null) {
            return null;
        }
        String configId = node.get(TEMPLATE_KEY, null);
        if (configId == null) {
            return null;
        }
        return configId;
    }

    public BuildScenario getBuildScenarioForProject(IProject project) {
        this.checkProject(project);
        IConfiguration bconf = ManagedBuildManager.getBuildInfo((IResource)project).getDefaultConfiguration();
        return this.getBuildScenarioForBuildConfigurationInternal((IConfiguration)bconf).bs;
    }

    public BuildScenario getBuildScenarioForBuildConfiguration(IConfiguration bconf) {
        IProject project = bconf.getOwner().getProject();
        this.checkProject(project);
        return this.getBuildScenarioForBuildConfigurationInternal((IConfiguration)bconf).bs;
    }

    private BuildScenarioAndConfiguration getBuildScenarioForBuildConfigurationInternal(IConfiguration bconf) {
        block5: {
            BuildScenario bs;
            String configId;
            block6: {
                IProject project = bconf.getOwner().getProject();
                IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
                if (buildInfo == null) {
                    throw new RuntimeException(String.valueOf(Messages.BCM_BuildInfoError) + project.getName());
                }
                try {
                    IConfiguration config = bconf;
                    configId = config.getId();
                    Map<String, String> scenarioData = this.getConfigData((Configuration)config, "org.eclipse.ptp.rdt.sync.core");
                    while (scenarioData == null) {
                        if ((configId = BuildConfigurationManager.getParentId(configId)) == null) break;
                        config = buildInfo.getManagedProject().getConfiguration(configId);
                        scenarioData = this.getConfigData((Configuration)config, "org.eclipse.ptp.rdt.sync.core");
                    }
                    if (configId == null) break block5;
                    bs = BuildScenario.loadScenario(scenarioData);
                    if (bs != null) break block6;
                    RDTSyncCorePlugin.log(String.valueOf(Messages.BuildConfigurationManager_14) + configId + Messages.BuildConfigurationManager_11 + project.getName());
                    return null;
                }
                catch (CoreException e) {
                    RDTSyncCorePlugin.log(Messages.BuildConfigurationManager_19, e);
                    return null;
                }
            }
            return new BuildScenarioAndConfiguration(bs, configId);
        }
        return null;
    }

    private static String getParentId(String configId) {
        String parentConfigId;
        String idRegEx = "\\.\\d+$";
        Pattern idPattern = Pattern.compile(idRegEx);
        if (idPattern.matcher(parentConfigId = configId.replaceFirst(idRegEx, "")).find()) {
            return parentConfigId;
        }
        return null;
    }

    public void setBuildScenarioForBuildConfiguration(BuildScenario bs, IConfiguration bconf) {
        if (bs == null) {
            throw new NullPointerException();
        }
        IProject project = bconf.getOwner().getProject();
        this.checkProject(project);
        this.updateConfigurations(project);
        this.setBuildScenarioForBuildConfigurationInternal(bs, bconf);
    }

    private void setBuildScenarioForBuildConfigurationInternal(BuildScenario bs, IConfiguration bconf) {
        HashMap<String, String> map = new HashMap<String, String>();
        bs.saveScenario(map);
        try {
            this.setConfigData((Configuration)bconf, map, "org.eclipse.ptp.rdt.sync.core");
        }
        catch (CoreException e) {
            RDTSyncCorePlugin.log(Messages.BuildConfigurationManager_20, e);
            return;
        }
    }

    private Map<String, String> getConfigData(Configuration config, String storageName) throws CoreException {
        ICConfigurationDescription configDesc = config.getConfigurationDescription();
        if (configDesc == null) {
            throw new RuntimeException(Messages.BuildConfigurationManager_18);
        }
        HashMap<String, String> m = new HashMap<String, String>();
        ICStorageElement storage = configDesc.getStorage(storageName, false);
        if (storage == null) {
            return null;
        }
        String[] stringArray = storage.getAttributeNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attr = stringArray[n2];
            m.put(attr, storage.getAttribute(attr));
            ++n2;
        }
        return m;
    }

    private void setConfigData(Configuration config, Map<String, String> map, String storageName) throws CoreException {
        ICProjectDescription projectDesc = CoreModel.getDefault().getProjectDescription(config.getOwner().getProject());
        ICConfigurationDescription configDesc = projectDesc.getConfigurationById(config.getId());
        if (configDesc == null) {
            throw new RuntimeException(Messages.BuildConfigurationManager_18);
        }
        ICStorageElement storage = configDesc.getStorage(storageName, true);
        storage.clear();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            storage.setAttribute(entry.getKey(), entry.getValue());
        }
        config.setDirty(true);
        BuildConfigurationManager.setProjectDescription(config.getOwner().getProject(), projectDesc);
    }

    private void checkProject(IProject project) {
        try {
            if (!project.hasNature("org.eclipse.ptp.rdt.sync.core.remoteSyncNature")) {
                throw new IllegalArgumentException(Messages.BuildConfigurationManager_6);
            }
        }
        catch (CoreException coreException) {
            throw new IllegalArgumentException(Messages.BuildConfigurationManager_8);
        }
        if (!this.isInitialized(project)) {
            throw new RuntimeException(Messages.BuildConfigurationManager_7);
        }
    }

    public static void flushNode(final Preferences prefNode) {
        Throwable firstException = null;
        final IWorkspace ws = ResourcesPlugin.getWorkspace();
        try {
            if (!ws.isTreeLocked()) {
                prefNode.flush();
                return;
            }
        }
        catch (BackingStoreException e) {
            firstException = e;
        }
        catch (IllegalStateException e) {
            firstException = e;
            return;
        }
        final BackingStoreException currentException = firstException;
        Thread flushThread = new Thread(new Runnable(){

            @Override
            public void run() {
                int sleepCount = 0;
                Throwable lastException = currentException;
                block4: while (true) {
                    try {
                        do {
                            Thread.sleep(1000L);
                            if (++sleepCount <= 30) continue;
                            if (lastException != null) {
                                RDTSyncCorePlugin.log(Messages.BuildConfigurationManager_17, lastException);
                                break block4;
                            }
                            RDTSyncCorePlugin.log(Messages.BuildConfigurationManager_17);
                            break block4;
                        } while (ws.isTreeLocked());
                        prefNode.flush();
                    }
                    catch (InterruptedException e) {
                        lastException = e;
                        continue;
                    }
                    catch (BackingStoreException e) {
                        lastException = e;
                        continue;
                    }
                    catch (IllegalStateException illegalStateException) {
                        return;
                    }
                    break;
                }
            }
        }, "Flush project data thread");
        flushThread.start();
    }

    public static void setProjectDescription(final IProject project, final ICProjectDescription desc) {
        CoreException firstException = null;
        final IWorkspace ws = ResourcesPlugin.getWorkspace();
        try {
            if (!ws.isTreeLocked()) {
                CoreModel.getDefault().setProjectDescription(project, desc, true, null);
                return;
            }
        }
        catch (CoreException e) {
            firstException = e;
        }
        final CoreException currentException = firstException;
        Thread flushThread = new Thread(new Runnable(){

            @Override
            public void run() {
                int sleepCount = 0;
                Throwable lastException = currentException;
                block3: while (true) {
                    try {
                        do {
                            Thread.sleep(1000L);
                            if (++sleepCount <= 30) continue;
                            if (lastException != null) {
                                RDTSyncCorePlugin.log(Messages.BuildConfigurationManager_24, lastException);
                                break block3;
                            }
                            RDTSyncCorePlugin.log(Messages.BuildConfigurationManager_24);
                            break block3;
                        } while (ws.isTreeLocked());
                        CoreModel.getDefault().setProjectDescription(project, desc, true, null);
                    }
                    catch (InterruptedException e) {
                        lastException = e;
                        continue;
                    }
                    catch (CoreException e) {
                        lastException = e;
                        continue;
                    }
                    break;
                }
            }
        }, "Save project CDT data thread");
        flushThread.start();
    }

    public Set<IPath> getMergeConflictFiles(IProject project, BuildScenario buildScenario) throws CoreException {
        ISyncServiceProvider provider = this.getProjectSyncServiceProvider(project);
        if (provider == null) {
            return new HashSet<IPath>();
        }
        return provider.getMergeConflictFiles(project, buildScenario);
    }

    public String[] getMergeConflictParts(IProject project, BuildScenario buildScenario, IFile file) throws CoreException {
        ISyncServiceProvider provider = this.getProjectSyncServiceProvider(project);
        if (provider == null) {
            return null;
        }
        return provider.getMergeConflictParts(project, buildScenario, file);
    }

    public void setMergeAsResolved(IProject project, BuildScenario buildScenario, IPath path) throws CoreException {
        ISyncServiceProvider provider = this.getProjectSyncServiceProvider(project);
        if (provider == null) {
            return;
        }
        provider.setMergeAsResolved(project, buildScenario, path);
    }

    public void checkout(IProject project, BuildScenario buildScenario, IPath path) throws CoreException {
        ISyncServiceProvider provider = this.getProjectSyncServiceProvider(project);
        if (provider == null) {
            return;
        }
        provider.checkout(project, buildScenario, path);
    }

    public void modifyConfigurationAsSyncLocal(IConfiguration config) {
        String configName = config.getName();
        if (!configName.endsWith(localConfigAnnotation)) {
            if (configName.endsWith(remoteConfigAnnotation)) {
                configName = configName.substring(0, configName.length() - remoteConfigAnnotation.length());
            }
            configName = String.valueOf(configName) + localConfigAnnotation;
            config.setName(configName);
        }
        ManagedBuildManager.saveBuildInfo((IProject)config.getOwner().getProject(), (boolean)true);
    }

    public void modifyConfigurationAsSyncRemote(IConfiguration config) {
        String configName = config.getName();
        if (!configName.endsWith(remoteConfigAnnotation)) {
            if (configName.endsWith(localConfigAnnotation)) {
                configName = configName.substring(0, configName.length() - localConfigAnnotation.length());
            }
            configName = String.valueOf(configName) + remoteConfigAnnotation;
            config.setName(configName);
        }
        IBuilder syncBuilder = ManagedBuildManager.getExtensionBuilder((String)"org.eclipse.ptp.rdt.sync.core.SyncBuilder");
        config.changeBuilder(syncBuilder, "org.eclipse.ptp.rdt.sync.core.SyncBuilder", "Sync Builder");
        ICConfigurationDescription c_mb_confgDes = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)config);
        if (c_mb_confgDes != null) {
            EnvironmentVariableManager.fUserSupplier.setAppendContributedEnvironment(false, (Object)c_mb_confgDes);
        }
        ManagedBuildManager.saveBuildInfo((IProject)config.getOwner().getProject(), (boolean)true);
    }

    private class BuildScenarioAndConfiguration {
        public final BuildScenario bs;
        public final String configId;

        BuildScenarioAndConfiguration(BuildScenario scenario, String configuration) {
            this.bs = scenario;
            this.configId = configuration;
        }
    }
}

