/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.ptp.rdt.sync.core.ISyncExceptionHandler;
import org.eclipse.ptp.rdt.sync.core.RemoteSyncMergeConflictException;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.ui.RDTSyncUIPlugin;
import org.eclipse.ptp.rdt.sync.ui.messages.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class CommonSyncExceptionHandler
implements ISyncExceptionHandler {
    private static final String SYNC_MERGE_FILE_VIEW = "org.eclipse.ptp.rdt.sync.ui.SyncMergeFileTableViewer";
    private final boolean showErrorMessageToggle;
    private final boolean alwaysShowDialog;
    private static long lastMergeConflictDialogTimeStamp = 0L;
    private static final long timeBetweenMergeConflicts = 5000L;

    public CommonSyncExceptionHandler(boolean showToggle, boolean alwaysShow) {
        this.showErrorMessageToggle = showToggle;
        this.alwaysShowDialog = alwaysShow;
    }

    public void handle(final IProject project, final CoreException e) {
        if (!this.alwaysShowDialog && !SyncManager.getShowErrors((IProject)project)) {
            return;
        }
        String endOfLineChar = System.getProperty("line.separator");
        String message = String.valueOf(Messages.CommonSyncExceptionHandler_0) + project.getName() + ":" + endOfLineChar + endOfLineChar;
        message = e.getMessage() != null && e.getMessage().length() > 0 || e.getCause() == null ? String.valueOf(message) + e.getMessage() : String.valueOf(message) + e.getCause().getMessage();
        final String finalMessage = message;
        Display errorDisplay = RDTSyncUIPlugin.getStandardDisplay();
        errorDisplay.syncExec(new Runnable(){

            @Override
            public void run() {
                String[] buttonLabels;
                if (e instanceof RemoteSyncMergeConflictException) {
                    if (System.currentTimeMillis() - lastMergeConflictDialogTimeStamp <= 5000L) {
                        return;
                    }
                    lastMergeConflictDialogTimeStamp = System.currentTimeMillis();
                    buttonLabels = new String[]{IDialogConstants.OK_LABEL, Messages.CommonSyncExceptionHandler_1};
                } else {
                    buttonLabels = new String[]{IDialogConstants.OK_LABEL};
                }
                Object dialog = CommonSyncExceptionHandler.this.showErrorMessageToggle ? new MessageDialogWithToggle(null, Messages.CommonSyncExceptionHandler_2, null, finalMessage, 1, buttonLabels, 0, Messages.CommonSyncExceptionHandler_3, !SyncManager.getShowErrors((IProject)project)) : new MessageDialog(null, Messages.CommonSyncExceptionHandler_4, null, finalMessage, 1, buttonLabels, 0);
                int buttonPressed = dialog.open();
                if (CommonSyncExceptionHandler.this.showErrorMessageToggle) {
                    if (((MessageDialogWithToggle)dialog).getToggleState()) {
                        SyncManager.setShowErrors((IProject)project, (boolean)false);
                    } else {
                        SyncManager.setShowErrors((IProject)project, (boolean)true);
                    }
                }
                if (CommonSyncExceptionHandler.this.showErrorMessageToggle && 256 - buttonPressed == 0 || !CommonSyncExceptionHandler.this.showErrorMessageToggle && buttonPressed == 1) {
                    try {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(CommonSyncExceptionHandler.SYNC_MERGE_FILE_VIEW, null, 2);
                    }
                    catch (CoreException e2) {
                        throw new RuntimeException(e2);
                    }
                }
            }
        });
    }
}

