/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.ui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.ptp.rdt.sync.core.BuildConfigurationManager;
import org.eclipse.ptp.rdt.sync.core.BuildScenario;
import org.eclipse.ptp.rdt.sync.core.ISyncListener;
import org.eclipse.ptp.rdt.sync.core.SyncEvent;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.core.resources.RemoteSyncNature;
import org.eclipse.ptp.rdt.sync.ui.RDTSyncUIPlugin;
import org.eclipse.ptp.rdt.sync.ui.SyncMergeEditor;
import org.eclipse.ptp.rdt.sync.ui.messages.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class SyncMergeFileTableViewer
extends ViewPart {
    private IProject project;
    private TableViewer fileTableViewer;
    private ISelectionListener selectionListener;
    private ISyncListener syncListener;
    private static SyncMergeFileTableViewer activeViewerInstance = null;

    public void dispose() {
        super.dispose();
        if (this.selectionListener != null) {
            ISelectionService selectionService = (ISelectionService)this.getSite().getService(ISelectionService.class);
            selectionService.removePostSelectionListener(this.selectionListener);
        }
        if (this.project != null) {
            SyncManager.removePostSyncListener((IProject)this.project, (ISyncListener)this.syncListener);
        }
    }

    public static SyncMergeFileTableViewer getActiveInstance() {
        return activeViewerInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPartControl(Composite parent) {
        SyncMergeFileTableViewer syncMergeFileTableViewer = this;
        synchronized (syncMergeFileTableViewer) {
            activeViewerInstance = this;
            this.fileTableViewer = new TableViewer(parent, 2816);
            TableViewerColumn fileColumn = new TableViewerColumn(this.fileTableViewer, 0);
            fileColumn.getColumn().setText(Messages.SyncMergeFileTreeViewer_0);
            fileColumn.getColumn().setWidth(200);
            fileColumn.getColumn().setResizable(true);
            fileColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (!$assertionsDisabled && !(element instanceof IFile)) {
                        throw new AssertionError();
                    }
                    return ((IFile)element).getProjectRelativePath().toOSString();
                }
            });
            GridData gridData = new GridData();
            gridData.verticalAlignment = 4;
            gridData.horizontalSpan = 2;
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            gridData.horizontalAlignment = 4;
            this.fileTableViewer.getControl().setLayoutData((Object)gridData);
            this.fileTableViewer.getTable().setHeaderVisible(true);
            this.fileTableViewer.getTable().setLinesVisible(true);
            this.fileTableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (selection != null) {
                        if (!$assertionsDisabled && !(selection instanceof IFile)) {
                            throw new AssertionError();
                        }
                        SyncMergeEditor.open((IFile)selection);
                    }
                }
            });
            ISelectionService selectionService = (ISelectionService)this.getSite().getService(ISelectionService.class);
            this.selectionListener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    IProject selectedProject = SyncMergeFileTableViewer.getProject();
                    if (selectedProject != null && selectedProject != SyncMergeFileTableViewer.this.project) {
                        SyncMergeFileTableViewer.this.update(selectedProject);
                    }
                }
            };
            selectionService.addPostSelectionListener(this.selectionListener);
            this.syncListener = new ISyncListener(){

                public void handleSyncEvent(SyncEvent event) {
                    RDTSyncUIPlugin.getStandardDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            SyncMergeFileTableViewer.this.update(null);
                        }
                    });
                }
            };
            MenuManager menuManager = new MenuManager();
            Menu menu = menuManager.createContextMenu((Control)this.fileTableViewer.getTable());
            this.fileTableViewer.getTable().setMenu(menu);
            this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.fileTableViewer);
            this.getSite().setSelectionProvider((ISelectionProvider)this.fileTableViewer);
            this.fileTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.update(SyncMergeFileTableViewer.getProject());
        }
    }

    public void update(IProject newProject) {
        if (newProject != null && RemoteSyncNature.hasNature((IProject)newProject)) {
            if (this.project != null) {
                SyncManager.removePostSyncListener((IProject)this.project, (ISyncListener)this.syncListener);
            }
            SyncManager.addPostSyncListener((IProject)newProject, (ISyncListener)this.syncListener);
            this.project = newProject;
        }
        Set mergeConflictFiles = new HashSet();
        if (this.project != null) {
            BuildConfigurationManager bcm = BuildConfigurationManager.getInstance();
            BuildScenario buildScenario = bcm.getBuildScenarioForProject(this.project);
            try {
                mergeConflictFiles = bcm.getMergeConflictFiles(this.project, buildScenario);
            }
            catch (CoreException e) {
                RDTSyncUIPlugin.log(e);
            }
        }
        HashSet<IFile> fileSet = new HashSet<IFile>();
        for (IPath path : mergeConflictFiles) {
            fileSet.add(this.project.getFile(path));
        }
        this.fileTableViewer.setInput(fileSet);
        this.fileTableViewer.refresh();
    }

    public void setFocus() {
        this.fileTableViewer.getControl().setFocus();
    }

    private static IProject getProject() {
        IStructuredSelection selection = SyncMergeFileTableViewer.getSelectedElements();
        if (selection == null) {
            return null;
        }
        Object firstElement = selection.getFirstElement();
        if (!(firstElement instanceof IAdaptable)) {
            return null;
        }
        Object o = ((IAdaptable)firstElement).getAdapter(IResource.class);
        if (o == null) {
            return null;
        }
        IResource resource = (IResource)o;
        return resource.getProject();
    }

    private static IStructuredSelection getSelectedElements() {
        IWorkbenchWindow wnd = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage pg = wnd.getActivePage();
        ISelection sel = pg.getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return null;
        }
        return (IStructuredSelection)sel;
    }
}

