/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.ui.properties;

import java.net.URI;
import java.util.Set;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractSingleBuildPage;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.ems.core.EnvManagerProjectProperties;
import org.eclipse.ptp.ems.core.IEnvManagerConfig;
import org.eclipse.ptp.ems.ui.EnvManagerConfigWidget;
import org.eclipse.ptp.ems.ui.IErrorListener;
import org.eclipse.ptp.rdt.core.serviceproviders.IRemoteExecutionServiceProvider;
import org.eclipse.ptp.rdt.sync.core.BuildConfigurationManager;
import org.eclipse.ptp.rdt.sync.core.RDTSyncCorePlugin;
import org.eclipse.ptp.rdt.sync.ui.RDTSyncUIPlugin;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.swt.widgets.Composite;

public final class EnvManagerPropertiesPage
extends AbstractSingleBuildPage {
    private EnvManagerConfigWidget ui = null;

    public void createWidgets(Composite parent) {
        IRemoteExecutionServiceProvider executionProvider = this.getRemoteServicesExecutionProvider();
        IRemoteConnection remoteConnection = executionProvider == null ? null : executionProvider.getConnection();
        this.ui = new EnvManagerConfigWidget(parent, remoteConnection);
        this.ui.setErrorListener(new IErrorListener(){

            public void errorRaised(String message) {
                EnvManagerPropertiesPage.this.setErrorMessage(message);
            }

            public void errorCleared() {
                EnvManagerPropertiesPage.this.setErrorMessage(null);
            }
        });
        this.ui.setUseEMSCheckbox(this.isEnvConfigSupportEnabled());
        this.ui.setManualConfigCheckbox(this.isManualConfigEnabled());
        this.ui.setManualConfigText(this.getManualConfigText());
        this.ui.configurationChanged(this.getSyncURI(), remoteConnection, this.computeSelectedItems());
    }

    private IRemoteExecutionServiceProvider getRemoteServicesExecutionProvider() {
        if (this.getControl().isDisposed()) {
            return null;
        }
        BuildConfigurationManager bcm = BuildConfigurationManager.getInstance();
        IServiceConfiguration serviceConfig = bcm.getConfigurationForBuildConfiguration(this.getCfg());
        if (serviceConfig == null) {
            return null;
        }
        ServiceModelManager smm = ServiceModelManager.getInstance();
        IService syncService = smm.getService("org.eclipse.ptp.rdt.sync.core.SyncService");
        if (syncService == null || serviceConfig.isDisabled(syncService)) {
            return null;
        }
        IService buildService = smm.getService("org.eclipse.ptp.rdt.core.BuildService");
        if (buildService == null) {
            return null;
        }
        IServiceProvider provider = serviceConfig.getServiceProvider(buildService);
        if (!(provider instanceof IRemoteExecutionServiceProvider)) {
            return null;
        }
        return (IRemoteExecutionServiceProvider)provider;
    }

    private boolean isEnvConfigSupportEnabled() {
        try {
            return this.getProjectProperties().isEnvMgmtEnabled();
        }
        catch (Error error) {
            return false;
        }
    }

    private EnvManagerProjectProperties getProjectProperties() {
        try {
            return new EnvManagerProjectProperties(this.getProject());
        }
        catch (Error e) {
            this.setErrorMessage(String.valueOf(e.getClass().getSimpleName()) + ": " + e.getLocalizedMessage());
            RDTSyncUIPlugin.log(e);
            throw e;
        }
    }

    private boolean isManualConfigEnabled() {
        try {
            return this.getProjectProperties().isManualConfigEnabled();
        }
        catch (Error error) {
            return false;
        }
    }

    private String getManualConfigText() {
        try {
            return this.getProjectProperties().getManualConfigText();
        }
        catch (Error error) {
            return "";
        }
    }

    private URI getSyncURI() {
        BuildConfigurationManager bcm = BuildConfigurationManager.getInstance();
        try {
            return bcm.getSyncLocationURI(this.getCfg(), (IResource)this.getCfg().getOwner().getProject());
        }
        catch (CoreException e) {
            this.setErrorMessage(String.valueOf(((Object)((Object)e)).getClass().getSimpleName()) + ": " + e.getLocalizedMessage());
            RDTSyncUIPlugin.log(e);
            return null;
        }
    }

    private Set<String> computeSelectedItems() {
        try {
            EnvManagerProjectProperties projectProperties = new EnvManagerProjectProperties(this.getProject());
            if (projectProperties.getConnectionName().equals(this.ui.getConnectionName())) {
                return projectProperties.getConfigElements();
            }
            return null;
        }
        catch (Error error) {
            return null;
        }
    }

    protected void cfgChanged(ICConfigurationDescription cfgd) {
        super.cfgChanged(cfgd);
        if (this.ui != null) {
            IRemoteExecutionServiceProvider executionProvider = this.getRemoteServicesExecutionProvider();
            IRemoteConnection connection = executionProvider == null ? null : executionProvider.getConnection();
            this.ui.configurationChanged(this.getSyncURI(), connection, this.computeSelectedItems());
        }
    }

    public void performDefaults() {
        if (this.ui != null) {
            this.ui.setUseEMSCheckbox(false);
        }
        super.performDefaults();
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        this.storeProjectProperties();
    }

    public boolean performOk() {
        this.storeProjectProperties();
        return super.performOk();
    }

    private void storeProjectProperties() {
        try {
            EnvManagerProjectProperties projectProperties = new EnvManagerProjectProperties(this.getProject());
            this.ui.saveConfiguration((IEnvManagerConfig)projectProperties);
        }
        catch (Error e) {
            RDTSyncCorePlugin.log((Throwable)e);
            this.setErrorMessage(String.valueOf(e.getClass().getSimpleName()) + ": " + e.getLocalizedMessage());
        }
    }
}

