/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.remotetools.core;

import java.io.IOException;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.ptp.remote.core.AbstractRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsConnection;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsFileManager;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsProcess;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionTools;
import org.eclipse.ptp.remotetools.core.IRemoteScript;
import org.eclipse.ptp.remotetools.core.RemoteProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteToolsProcessBuilder
extends AbstractRemoteProcessBuilder {
    private final RemoteToolsConnection fConnection;
    private final RemoteToolsFileManager fFileMgr;
    private final Map<String, String> fRemoteEnv;
    private Map<String, String> fNewRemoteEnv = null;
    private final Set<Character> charSet = new HashSet<Character>();

    public RemoteToolsProcessBuilder(RemoteToolsConnection conn, RemoteToolsFileManager fileMgr, List<String> command) {
        super((IRemoteConnection)conn, command);
        this.fConnection = conn;
        this.fFileMgr = fileMgr;
        this.fRemoteEnv = new HashMap<String, String>(conn.getEnv());
        String trustedChars = null;
        trustedChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        trustedChars = String.valueOf(trustedChars) + "0123456789/._-";
        StringCharacterIterator it = new StringCharacterIterator(trustedChars);
        char c = it.first();
        while (c != '\uffff') {
            this.charSet.add(Character.valueOf(c));
            c = it.next();
        }
    }

    public RemoteToolsProcessBuilder(RemoteToolsConnection conn, RemoteToolsFileManager fileMgr, String ... command) {
        this(conn, fileMgr, Arrays.asList(command));
    }

    public IFileStore directory() {
        IFileStore dir = super.directory();
        if (dir == null) {
            dir = this.fFileMgr.getResource(this.connection().getWorkingDirectory());
            this.directory(dir);
        }
        return dir;
    }

    public Map<String, String> environment() {
        if (this.fNewRemoteEnv == null) {
            this.fNewRemoteEnv = new HashMap<String, String>();
            this.fNewRemoteEnv.putAll(this.fRemoteEnv);
        }
        return this.fNewRemoteEnv;
    }

    public int getSupportedFlags() {
        return 3;
    }

    public IRemoteProcess start(int flags) throws IOException {
        List cmdArgs = this.command();
        if (cmdArgs.size() < 1) {
            throw new IndexOutOfBoundsException();
        }
        String remoteCmd = "";
        int i = 0;
        while (i < cmdArgs.size()) {
            if (i > 0) {
                remoteCmd = String.valueOf(remoteCmd) + " ";
            }
            remoteCmd = String.valueOf(remoteCmd) + this.charEscapify((String)cmdArgs.get(i), this.charSet);
            ++i;
        }
        try {
            IRemoteExecutionManager exeMgr = this.fConnection.createExecutionManager();
            IRemoteExecutionTools exeTools = exeMgr.getExecutionTools();
            IRemoteScript script = exeTools.createScript();
            if (this.directory() != null) {
                String setWorkingDirStr = "cd " + this.charEscapify(this.directory().toURI().getPath(), this.charSet);
                script.setScript(new String[]{setWorkingDirStr, remoteCmd});
            } else {
                script.setScript(remoteCmd);
            }
            if (this.fNewRemoteEnv != null) {
                boolean clearEnv = false;
                for (String string : this.fRemoteEnv.keySet()) {
                    if (this.fNewRemoteEnv.get(string) != null) continue;
                    clearEnv = true;
                    break;
                }
                if (clearEnv) {
                    script.clearEnvironment();
                    for (Map.Entry entry : this.fNewRemoteEnv.entrySet()) {
                        script.addEnvironment(String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue());
                    }
                } else {
                    for (Map.Entry entry : this.fNewRemoteEnv.entrySet()) {
                        String oldValue = this.fRemoteEnv.get(entry.getKey());
                        if (oldValue != null && oldValue.equals(entry.getValue())) continue;
                        script.addEnvironment(String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue());
                    }
                }
            }
            script.setAllocateTerminal((flags & 1) == 1);
            script.setForwardX11((flags & 2) == 2);
            RemoteProcess process = exeTools.executeProcess(script);
            return new RemoteToolsProcess((Process)process, this.redirectErrorStream());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private String charEscapify(String inputString, Set<Character> charSet) {
        if (inputString == null) {
            return null;
        }
        StringBuffer newString = new StringBuffer("");
        StringCharacterIterator it = new StringCharacterIterator(inputString);
        char c = it.first();
        while (c != '\uffff') {
            if (c == '\'') {
                newString.append("'\\\\\\''");
            } else if (c > '\u007f' || charSet.contains(Character.valueOf(c))) {
                newString.append(c);
            } else {
                newString.append("\\" + c);
            }
            c = it.next();
        }
        inputString = newString.toString();
        return inputString;
    }
}

