/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control;

import java.util.UUID;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.core.ModelManager;
import org.eclipse.ptp.core.jobs.IJobControl;
import org.eclipse.ptp.rm.jaxb.control.ILaunchController;
import org.eclipse.ptp.rm.jaxb.control.LaunchController;
import org.eclipse.ptp.rm.jaxb.core.JAXBExtensionUtils;

public class LaunchControllerManager {
    private static final LaunchControllerManager fInstance = new LaunchControllerManager();

    public static String generateControlId(String remoteServicesId, String connectionName, String configName) {
        String controlBytes = String.valueOf(remoteServicesId) + "/" + connectionName + "/" + configName;
        return UUID.nameUUIDFromBytes(controlBytes.getBytes()).toString();
    }

    public static LaunchControllerManager getInstance() {
        return fInstance;
    }

    private LaunchControllerManager() {
    }

    public ILaunchController getLaunchController(String remoteServicesId, String connectionName, String configName) throws CoreException {
        if (remoteServicesId != null && connectionName != null && configName != null) {
            String controlId = LaunchControllerManager.generateControlId(remoteServicesId, connectionName, configName);
            ILaunchController controller = (ILaunchController)ModelManager.getInstance().getJobControl(controlId);
            if (controller == null) {
                controller = new LaunchController();
                controller.setRMConfigurationURL(JAXBExtensionUtils.getConfigurationURL((String)configName));
                if (connectionName != null && remoteServicesId != null) {
                    controller.setConnectionName(connectionName);
                    controller.setRemoteServicesId(remoteServicesId);
                }
            }
            controller.initialize();
            if (controller.isInitialized()) {
                ModelManager.getInstance().addJobControl((IJobControl)controller);
                ModelManager.getInstance().getUniverse().addResourceManager(configName, controlId);
                return controller;
            }
        }
        return null;
    }
}

