/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.internal.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.rm.jaxb.control.internal.IAssign;
import org.eclipse.ptp.rm.jaxb.control.internal.IMatchable;
import org.eclipse.ptp.rm.jaxb.control.internal.data.AddImpl;
import org.eclipse.ptp.rm.jaxb.control.internal.data.AppendImpl;
import org.eclipse.ptp.rm.jaxb.control.internal.data.MatchImpl;
import org.eclipse.ptp.rm.jaxb.control.internal.data.PutImpl;
import org.eclipse.ptp.rm.jaxb.control.internal.data.SetImpl;
import org.eclipse.ptp.rm.jaxb.control.internal.data.TestImpl;
import org.eclipse.ptp.rm.jaxb.control.internal.data.ThrowImpl;
import org.eclipse.ptp.rm.jaxb.control.internal.messages.Messages;
import org.eclipse.ptp.rm.jaxb.control.internal.utils.DebuggingLogger;
import org.eclipse.ptp.rm.jaxb.control.internal.variables.RMVariableMap;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AddType;
import org.eclipse.ptp.rm.jaxb.core.data.AppendType;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.ptp.rm.jaxb.core.data.MatchType;
import org.eclipse.ptp.rm.jaxb.core.data.PutType;
import org.eclipse.ptp.rm.jaxb.core.data.SetType;
import org.eclipse.ptp.rm.jaxb.core.data.TargetType;
import org.eclipse.ptp.rm.jaxb.core.data.TestType;
import org.eclipse.ptp.rm.jaxb.core.data.ThrowType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetImpl
implements IMatchable {
    private final IVariableMap rmVarMap;
    private final String uuid;
    private final String ref;
    private final List<MatchImpl> matches;
    private final List<TestImpl> tests;
    private final List<AttributeType> targets;
    private final boolean matchAll;
    private final boolean allowOverwrites;
    private IAssign defaultAction;
    private AttributeType refTarget;
    private boolean selected;

    public TargetImpl(String uuid, TargetType target, IVariableMap rmVarMap) {
        this.rmVarMap = rmVarMap;
        this.uuid = uuid;
        this.ref = target.getRef();
        this.matchAll = target.isMatchAll();
        this.allowOverwrites = target.isAllowOverwrites();
        this.matches = new ArrayList<MatchImpl>();
        List mdata = target.getMatch();
        for (MatchType m : mdata) {
            this.matches.add(new MatchImpl(uuid, m, this, rmVarMap));
        }
        this.tests = new ArrayList<TestImpl>();
        List tdata = target.getTest();
        for (TestType t : tdata) {
            this.tests.add(new TestImpl(uuid, t, rmVarMap));
        }
        TargetType.Else defAction = target.getElse();
        if (defAction != null) {
            AddType add = defAction.getAdd();
            AppendType append = defAction.getAppend();
            PutType put = defAction.getPut();
            SetType set = defAction.getSet();
            ThrowType toThrow = defAction.getThrow();
            if (add != null) {
                this.defaultAction = new AddImpl(uuid, add, rmVarMap);
            } else if (append != null) {
                this.defaultAction = new AppendImpl(uuid, append, rmVarMap);
            } else if (put != null) {
                this.defaultAction = new PutImpl(uuid, put, rmVarMap);
            } else if (set != null) {
                this.defaultAction = new SetImpl(uuid, set, rmVarMap);
            } else if (toThrow != null) {
                this.defaultAction = new ThrowImpl(uuid, toThrow, rmVarMap);
            }
        }
        this.targets = new ArrayList<AttributeType>();
        this.selected = false;
    }

    @Override
    public synchronized boolean doMatch(StringBuffer segment) throws Throwable {
        int matched = 0;
        boolean match = false;
        for (MatchImpl m : this.matches) {
            if (this.matchAll && m.getMatched()) {
                ++matched;
                continue;
            }
            int tail = m.doMatch(segment.toString());
            match = m.getMatched();
            if (!match) continue;
            segment.delete(0, tail);
            ++matched;
            this.selected = m.getMoveToTop();
            break;
        }
        if (!this.matchAll || matched == this.matches.size()) {
            for (MatchImpl m : this.matches) {
                m.reset();
            }
        }
        return match;
    }

    public AttributeType getTarget(IAssign assign) throws CoreException {
        if (this.refTarget != null) {
            return this.refTarget;
        }
        AttributeType target = null;
        if (this.ref != null) {
            String name = this.rmVarMap.getString(this.uuid, this.ref);
            target = this.rmVarMap.get(name);
            if (target == null) {
                throw CoreExceptionUtils.newException((String)(String.valueOf(Messages.StreamParserNoSuchVariableError) + name), null);
            }
            this.refTarget = target;
        } else {
            int i = assign.getIndex();
            if (i < this.targets.size()) {
                target = this.targets.get(i);
            }
            if (target == null) {
                target = new AttributeType();
                this.targets.add(target);
            }
        }
        return target;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public synchronized void postProcess() throws Throwable {
        if (this.refTarget == null) {
            DebuggingLogger.getLogger().logPropertyInfo(String.valueOf(Messages.TargetImpl_2) + this.targets.size() + Messages.TargetImpl_3);
            this.mergeAttributes(this.targets);
            if (this.rmVarMap instanceof RMVariableMap) {
                Map<String, AttributeType> dmap = ((RMVariableMap)this.rmVarMap).getDiscovered();
                for (AttributeType t : this.targets) {
                    this.runTests(t);
                    AttributeType a = t;
                    DebuggingLogger.getLogger().logPropertyInfo(String.valueOf(Messages.TargetImpl_6) + a.getName() + "," + " " + a.getValue());
                    dmap.put(a.getName(), a);
                }
            }
            this.targets.clear();
        } else {
            this.runTests(this.refTarget);
            this.refTarget = null;
        }
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    private void merge(AttributeType previous, AttributeType current) throws Throwable {
        previous.setValue(this.mergeObject(previous.getValue(), current.getValue()));
        previous.setDefault(this.mergeString(previous.getDefault(), current.getDefault()));
        previous.setType(this.mergeString(previous.getType(), current.getType()));
        previous.setReadOnly(this.mergeBoolean(previous.isReadOnly(), current.isReadOnly()));
        previous.setVisible(this.mergeBoolean(previous.isVisible(), current.isVisible()));
        previous.setStatus(this.mergeString(previous.getStatus(), current.getStatus()));
        previous.setMax(this.mergeInteger(previous.getMax(), current.getMax()));
        previous.setMin(this.mergeInteger(previous.getMin(), current.getMin()));
        previous.setDescription(this.mergeString(previous.getDescription(), current.getDescription()));
        previous.setTooltip(this.mergeString(previous.getTooltip(), current.getTooltip()));
        previous.setChoice(this.mergeString(previous.getChoice(), current.getChoice()));
    }

    private void mergeAttributes(List<AttributeType> targets) throws Throwable {
        HashMap<String, AttributeType> hash = new HashMap<String, AttributeType>();
        Iterator<AttributeType> i = targets.iterator();
        while (i.hasNext()) {
            AttributeType current = i.next();
            String name = current.getName();
            if (current.getName() == null) {
                i.remove();
                continue;
            }
            AttributeType previous = (AttributeType)hash.get(name);
            if (previous != null) {
                this.merge(previous, current);
                i.remove();
                continue;
            }
            hash.put(name, current);
        }
    }

    private Boolean mergeBoolean(Boolean b0, Boolean b1) {
        if (this.allowOverwrites) {
            return b1;
        }
        if (!b0.booleanValue()) {
            return b1;
        }
        return b0;
    }

    private Integer mergeInteger(Integer i0, Integer i1) throws Throwable {
        if (i0 == null) {
            return i1;
        }
        if (i1 != null) {
            if (this.allowOverwrites) {
                return i1;
            }
            throw new Throwable(String.valueOf(Messages.StreamParserInconsistentPropertyWarning) + i0 + "," + " " + i1);
        }
        return i0;
    }

    private Object mergeObject(Object v0, Object v1) throws Throwable {
        if (v0 == null) {
            return v1;
        }
        if (v1 != null) {
            if (v0 instanceof Collection && v1 instanceof Collection) {
                ((Collection)v0).addAll((Collection)v1);
            } else if (v0 instanceof Map && v1 instanceof Map) {
                ((Map)v0).putAll((Map)v1);
            } else if (this.allowOverwrites) {
                return v1;
            }
            throw new Throwable(String.valueOf(Messages.StreamParserInconsistentPropertyWarning) + v0 + "," + " " + v1);
        }
        return v0;
    }

    private String mergeString(String s0, String s1) throws Throwable {
        if (s0 == null) {
            return s1;
        }
        if (s1 != null) {
            if (this.allowOverwrites) {
                return s1;
            }
            throw new Throwable(String.valueOf(Messages.StreamParserInconsistentPropertyWarning) + s0 + "," + " " + s1);
        }
        return s0;
    }

    private void runTests(Object target) throws Throwable {
        boolean any = false;
        boolean testSuccess = false;
        for (TestImpl test : this.tests) {
            test.setTarget(target);
            testSuccess = test.doTest();
            boolean bl = any = any || testSuccess;
        }
        if (!any && this.defaultAction != null) {
            this.defaultAction.setTarget(target);
            this.defaultAction.assign(null);
        }
    }
}

