/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.ui.launch;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ptp.launch.ui.extensions.AbstractRMLaunchConfigurationDynamicTab;
import org.eclipse.ptp.launch.ui.extensions.RMLaunchValidation;
import org.eclipse.ptp.rm.jaxb.control.ui.JAXBControlUIPlugin;
import org.eclipse.ptp.rm.jaxb.control.ui.launch.IJAXBParentLaunchConfigurationTab;
import org.eclipse.ptp.rm.jaxb.control.ui.messages.Messages;
import org.eclipse.ptp.rm.jaxb.control.ui.variables.LCVariableMap;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJAXBLaunchConfigurationTab
extends AbstractRMLaunchConfigurationDynamicTab {
    protected final IJAXBParentLaunchConfigurationTab parentTab;
    protected final Set<String> visibleList;
    protected final Set<String> enabledList;
    protected final Set<String> validSet;
    protected String title;
    protected Composite control;

    protected AbstractJAXBLaunchConfigurationTab(IJAXBParentLaunchConfigurationTab parentTab) {
        this.parentTab = parentTab;
        this.title = Messages.DefaultDynamicTab_title;
        this.visibleList = new TreeSet<String>();
        this.enabledList = new TreeSet<String>();
        this.validSet = new TreeSet<String>();
    }

    public abstract Image getImage();

    public abstract String getText();

    public RMLaunchValidation performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.control.isVisible()) {
            try {
                this.refreshLocal(configuration);
            }
            catch (CoreException t) {
                JAXBControlUIPlugin.log(t);
                return new RMLaunchValidation(false, t.getMessage());
            }
        }
        return new RMLaunchValidation(true, null);
    }

    public void setUpSharedEnvironment(Map<String, AbstractJAXBLaunchConfigurationTab> controllers) throws CoreException {
    }

    public abstract void setVisible();

    protected abstract void doRefreshLocal();

    protected String getControllerTag() {
        return this.title.replaceAll(" ", ".");
    }

    protected void refreshLocal(ILaunchConfigurationWorkingCopy config) throws CoreException {
        this.visibleList.clear();
        this.enabledList.clear();
        this.validSet.clear();
        this.doRefreshLocal();
        LCVariableMap lcMap = this.parentTab.getVariableMap();
        lcMap.relinkConfigurationProperties((ILaunchConfiguration)config);
        this.parentTab.getVariableMap().relinkHidden(this.getControllerTag());
        this.writeLocalProperties();
        this.parentTab.getVariableMap().flush(config);
    }

    protected abstract void writeLocalProperties();
}

