/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.ui.variables;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ptp.ems.core.IEnvManager;
import org.eclipse.ptp.rm.jaxb.control.internal.variables.RMVariableMap;
import org.eclipse.ptp.rm.jaxb.control.ui.variables.LCVariableResolver;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.JAXBCorePlugin;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LCVariableMap
implements IVariableMap {
    private static final Object monitor = new Object();
    private IEnvManager envManager;
    private final Map<String, AttributeType> linkedTo;
    private final Map<String, Object> excluded;
    private final Map<String, AttributeType> values = Collections.synchronizedMap(new TreeMap());
    private final Map<String, String> defaultValues;
    private final Map<String, AttributeType> temp;
    private final Set<String> hidden;
    private String rmPrefix;

    public static void normalizeStandardProperties(String rmPrefix, ILaunchConfigurationWorkingCopy configuration) throws CoreException {
        configuration.removeAttribute(String.valueOf(rmPrefix) + "executablePath");
        configuration.removeAttribute(String.valueOf(rmPrefix) + "executableDirectory");
        configuration.removeAttribute(String.valueOf(rmPrefix) + "progArgs");
        configuration.removeAttribute(String.valueOf(rmPrefix) + "debuggerExecutablePath");
        configuration.removeAttribute(String.valueOf(rmPrefix) + "debuggerArgs");
        configuration.removeAttribute(String.valueOf(rmPrefix) + "debuggerId");
        String attr = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_REMOTE_EXECUTABLE_PATH", "");
        if (!"".equals(attr)) {
            configuration.setAttribute(String.valueOf(rmPrefix) + "executablePath", attr);
            attr = new Path(attr).removeLastSegments(1).toString();
            configuration.setAttribute(String.valueOf(rmPrefix) + "executableDirectory", attr);
        }
        if (!"".equals(attr = configuration.getAttribute("org.eclipse.ptp.launch.ARGUMENT_ATTR", ""))) {
            configuration.setAttribute(String.valueOf(rmPrefix) + "progArgs", attr);
        }
        if (!"".equals(attr = configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", ""))) {
            configuration.setAttribute(String.valueOf(rmPrefix) + "debuggerExecutablePath", attr);
        }
        if (!"".equals(attr = configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_ARGS", ""))) {
            configuration.setAttribute(String.valueOf(rmPrefix) + "debuggerArgs", attr);
        }
        if (!"".equals(attr = configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_ID", ""))) {
            configuration.setAttribute(String.valueOf(rmPrefix) + "debuggerId", attr);
        }
    }

    public LCVariableMap() {
        this.excluded = Collections.synchronizedMap(new TreeMap());
        this.defaultValues = Collections.synchronizedMap(new TreeMap());
        this.linkedTo = Collections.synchronizedMap(new TreeMap());
        this.temp = Collections.synchronizedMap(new TreeMap());
        this.hidden = new HashSet<String>();
    }

    public void clear() {
        this.values.clear();
        this.defaultValues.clear();
        this.linkedTo.clear();
        this.temp.clear();
        this.excluded.clear();
        this.hidden.clear();
    }

    public void flush(ILaunchConfigurationWorkingCopy configuration) throws CoreException {
        for (String name : this.values.keySet()) {
            if (this.rmPrefix.equals("") || RMVariableMap.isDynamic((String)name.replace(this.rmPrefix, ""))) continue;
            Object value = this.getValueFromAttribute(name);
            if (value instanceof Boolean) {
                configuration.setAttribute(name, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Integer) {
                configuration.setAttribute(name, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof List) {
                configuration.setAttribute(name, (List)value);
                continue;
            }
            if (value instanceof Set) {
                configuration.setAttribute(name, (Set)value);
                continue;
            }
            if (value instanceof Map) {
                configuration.setAttribute(name, (Map)value);
                continue;
            }
            configuration.setAttribute(name, (String)value);
        }
    }

    public Set<String> forControlState(String name, String statePrefix) {
        TreeSet<String> set = new TreeSet<String>();
        String state = (String)this.getValue(String.valueOf(statePrefix) + name);
        if (state != null) {
            String[] split;
            String[] stringArray = split = state.split(" ");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                set.add(s);
                ++n2;
            }
        }
        return set;
    }

    public AttributeType get(String name) {
        if (name == null) {
            return null;
        }
        return this.values.get(String.valueOf(this.rmPrefix) + name);
    }

    public Map<String, AttributeType> getAttributes() {
        return this.values;
    }

    public String getDefault(String name) {
        if (name == null) {
            return null;
        }
        return this.defaultValues.get(name);
    }

    public Map<String, AttributeType> getDiscovered() {
        return null;
    }

    public IEnvManager getEnvironmentManager() {
        return this.envManager;
    }

    public IEnvManager getEnvManager() {
        return this.envManager;
    }

    public Map<String, Object> getExcluded() {
        return this.excluded;
    }

    public Set<String> getHidden() {
        return this.hidden;
    }

    public String getString(String value) {
        try {
            value = value.replaceAll("ptp_rm:", "ptp_lc:");
            return this.dereference(value);
        }
        catch (CoreException t) {
            JAXBCorePlugin.log((Throwable)t);
            return value;
        }
    }

    public String getString(String jobId, String value) {
        return this.getString(value);
    }

    public Object getValue(String name) {
        return this.getValueFromAttribute(String.valueOf(this.rmPrefix) + name);
    }

    private Object getValueFromAttribute(String name) {
        AttributeType a = this.values.get(name);
        if (a != null) {
            return a.getValue();
        }
        return null;
    }

    public void initialize(IVariableMap rmVars, String rmId) throws Throwable {
        this.clear();
        this.rmPrefix = rmId != null ? String.valueOf(rmId) + "." : "";
        for (String s : rmVars.getAttributes().keySet()) {
            this.loadValues(s, (AttributeType)rmVars.getAttributes().get(s), false);
        }
        for (String s : rmVars.getDiscovered().keySet()) {
            this.loadValues(s, (AttributeType)rmVars.getDiscovered().get(s), true);
        }
    }

    public void put(String name, AttributeType attr) {
        if (name == null || "".equals(name)) {
            return;
        }
        this.values.put(String.valueOf(this.rmPrefix) + name, attr);
    }

    public void putValue(String name, Object value) {
        if (name == null || "".equals(name)) {
            return;
        }
        this.putValueToAttribute(String.valueOf(this.rmPrefix) + name, value);
    }

    private void putValueToAttribute(String name, Object value) {
        if (value != null) {
            AttributeType a = this.values.get(name);
            if (a == null) {
                a = new AttributeType();
                a.setName(name);
                a.setValue(value);
                this.values.put(name, a);
            }
            a.setValue(value);
        }
    }

    public void relinkConfigurationProperties(ILaunchConfiguration configuration) throws CoreException {
        if (!this.rmPrefix.equals("")) {
            Iterator<String> key = this.values.keySet().iterator();
            while (key.hasNext()) {
                String name = key.next();
                if (name.startsWith(this.rmPrefix)) continue;
                key.remove();
            }
        }
        Map attributes = configuration.getAttributes();
        for (Object o : attributes.keySet()) {
            String key = (String)o;
            if (!RMVariableMap.isExternal((String)key)) continue;
            this.putValueToAttribute(key, attributes.get(key));
        }
    }

    public void relinkHidden(String controller) {
        Set<String> valid = this.forControlState(controller, "valid_");
        for (String name : this.linkedTo.keySet()) {
            Object value = null;
            AttributeType a = this.linkedTo.get(name);
            String link = null;
            link = a.getLinkValueTo();
            if (link != null && (valid.contains(link) || RMVariableMap.isExternal((String)link) || RMVariableMap.isFixedValid((String)link))) {
                value = this.getValue(link);
            }
            if (value == null || "".equals(value)) {
                value = this.defaultValues.get(name);
            }
            if (value == null) {
                value = "";
            }
            this.putValue(name, value);
        }
    }

    public AttributeType remove(String name) {
        return null;
    }

    public void restoreGlobal() {
        this.values.clear();
        this.values.putAll(this.temp);
        this.temp.clear();
    }

    public void setDefault(String name, String defaultv) {
        if (defaultv == null) {
            this.values.remove(String.valueOf(this.rmPrefix) + name);
        } else {
            this.putValue(name, defaultv);
        }
    }

    public void setEnvManager(IEnvManager envManager) {
        this.envManager = envManager;
    }

    public void setInitialized(boolean initialized) {
    }

    public void shiftToCurrent(String controller) {
        Set<String> valid = this.forControlState(controller, "valid_");
        this.temp.putAll(this.values);
        this.values.clear();
        for (String var : this.temp.keySet()) {
            AttributeType a = this.temp.get(var);
            if ("".equals(a.getValue())) continue;
            if (!this.rmPrefix.equals("") && var.startsWith(this.rmPrefix)) {
                if (!valid.contains(var = var.substring(this.rmPrefix.length())) && !RMVariableMap.isFixedValid((String)var)) continue;
                this.putValue(var, a.getValue());
                continue;
            }
            if (!RMVariableMap.isExternal((String)var)) continue;
            this.putValueToAttribute(var, a.getValue());
        }
    }

    public void updateFromConfiguration(ILaunchConfiguration configuration) throws CoreException {
        Map attr = configuration.getAttributes();
        for (Object keyObj : attr.keySet()) {
            if (!(keyObj instanceof String)) continue;
            String key = (String)keyObj;
            if ((this.rmPrefix.equals("") || !key.startsWith(this.rmPrefix) || RMVariableMap.isDynamic((String)key.replace(this.rmPrefix, ""))) && !RMVariableMap.isExternal((String)key)) continue;
            this.putValueToAttribute(key, attr.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String dereference(String expression) throws CoreException {
        if (expression == null) {
            return null;
        }
        Object object = monitor;
        synchronized (object) {
            LCVariableResolver.setActive(this);
            return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(expression);
        }
    }

    private void loadValues(String key, AttributeType attr, boolean discovered) throws Throwable {
        String name = null;
        String defVal = null;
        boolean linked = false;
        boolean visible = true;
        Object o = null;
        name = attr.getName();
        if (name == null) {
            return;
        }
        defVal = attr.getDefault();
        visible = attr.isVisible();
        if (!visible) {
            this.hidden.add(name);
            if (attr.getLinkValueTo() != null) {
                linked = true;
                this.linkedTo.put(name, attr);
            } else {
                o = attr.getValue();
            }
        } else {
            o = attr.getValue();
        }
        if (!discovered) {
            this.defaultValues.put(name, defVal);
            if (!linked) {
                if (o == null) {
                    this.setDefault(name, defVal);
                } else {
                    this.putValue(name, o);
                }
            }
        } else if (!visible) {
            this.hidden.add(name);
            this.excluded.put(name, o);
        } else {
            this.putValue(name, o);
        }
    }
}

