/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.internal.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ptp.rm.lml.core.messages.Messages;
import org.eclipse.ptp.rm.lml.internal.core.elements.DataElement;
import org.eclipse.ptp.rm.lml.internal.core.elements.Nodedisplay;
import org.eclipse.ptp.rm.lml.internal.core.elements.SchemeElement;
import org.eclipse.ptp.rm.lml.internal.core.elements.SchemeType;
import org.eclipse.ptp.rm.lml.internal.core.model.ErrorList;
import org.eclipse.ptp.rm.lml.internal.core.model.LMLCheck;
import org.eclipse.ptp.rm.lml.internal.core.model.Mask;

public class FastImpCheck {
    private static ArrayList<ArrayList<Integer>> levelsList;

    public static ErrorList checkRefids(Nodedisplay base, Nodedisplay nodedisplay, ErrorList errList) {
        ErrorList result = errList == null ? new ErrorList() : errList;
        FastImpCheck.recCheckRefIds(nodedisplay.getData(), base.getScheme(), result);
        return result;
    }

    public static ArrayList<ArrayList<Integer>> getAllImpNameLevels(String impName, Object scheme) {
        levelsList = new ArrayList();
        FastImpCheck.impNameToAllPossibleLevel(impName, scheme, new ArrayList<Integer>());
        return levelsList;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static void impNameToAllPossibleLevel(String impName, Object scheme, ArrayList<Integer> numbersList) {
        lowerList = LMLCheck.getLowerSchemeElements(scheme);
        for (SchemeElement lowerElement : lowerList) {
            mask = new Mask(lowerElement);
            i = 1;
            while (i <= impName.length() && !mask.isOutputAllowed(impName.substring(0, i))) {
                ++i;
            }
            if (i <= impName.length()) ** GOTO lbl22
            continue;
lbl-1000:
            // 1 sources

            {
                id = mask.getNumberOfLevelString(impName.substring(0, i));
                numbersList.add(id);
                if (i == impName.length()) {
                    copy = LMLCheck.copyArrayList(numbersList);
                    FastImpCheck.levelsList.add(copy);
                } else {
                    FastImpCheck.impNameToAllPossibleLevel(impName.substring(i), lowerElement, numbersList);
                }
                numbersList.remove(numbersList.size() - 1);
                ++i;
lbl22:
                // 2 sources

                ** while (i <= impName.length() && mask.isOutputAllowed((String)impName.substring((int)0, (int)i)))
            }
lbl23:
            // 1 sources

        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static ArrayList<Integer> impNameToOneLevel(String impName, Object scheme, ArrayList<Integer> numbersList) {
        lowerList = LMLCheck.getLowerSchemeElements(scheme);
        for (SchemeElement lowerElement : lowerList) {
            mask = new Mask(lowerElement);
            i = 1;
            while (i <= impName.length() && !mask.isOutputAllowed(impName.substring(0, i))) {
                ++i;
            }
            if (i <= impName.length()) ** GOTO lbl27
            continue;
lbl-1000:
            // 1 sources

            {
                id = mask.getNumberOfLevelString(impName.substring(0, i));
                idList = new ArrayList<Integer>();
                idList.add(id);
                if (LMLCheck.getSchemeByLevels(idList, scheme) == null) {
                    ++i;
                    continue;
                }
                numbersList.add(id);
                if (i == impName.length()) {
                    return numbersList;
                }
                result = FastImpCheck.impNameToOneLevel(impName.substring(i), lowerElement, numbersList);
                if (result != null) {
                    return result;
                }
                numbersList.remove(numbersList.size() - 1);
                ++i;
lbl27:
                // 3 sources

                ** while (i <= impName.length() && mask.isOutputAllowed((String)impName.substring((int)0, (int)i)))
            }
lbl28:
            // 1 sources

        }
        return null;
    }

    private static HashMap<Integer, Mask> findMasks(Object selectObject, int level, HashMap<Integer, Mask> masksMap) {
        List<? extends SchemeElement> elementsList = LMLCheck.getLowerSchemeElements(selectObject);
        Iterator<? extends SchemeElement> iterator = elementsList.iterator();
        while (iterator.hasNext()) {
            SchemeElement element;
            SchemeElement schmeElement = element = iterator.next();
            if (!masksMap.containsKey(level) && schmeElement.getMask() != null) {
                masksMap.put(level, new Mask(schmeElement));
            }
            FastImpCheck.findMasks(schmeElement, level + 1, masksMap);
        }
        return masksMap;
    }

    private static ArrayList<Integer> impNameToLevel(String impName, HashMap<Integer, Mask> masksMap) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int length = impName.length();
        int sumLength = 0;
        int level = 1;
        while (sumLength < length) {
            Mask mask;
            if ((mask = masksMap.get(level++)) == null) {
                return null;
            }
            int currentLength = 0;
            if (mask.getOutputLength() >= 0) {
                currentLength = mask.getOutputLength();
                if (sumLength + currentLength > impName.length() || !mask.isOutputAllowed(impName.substring(sumLength, sumLength + currentLength))) {
                    return null;
                }
            } else {
                String rest = impName.substring(sumLength);
                int i = 1;
                while (i <= rest.length() && !mask.isOutputAllowed(rest.substring(0, i))) {
                    ++i;
                }
                if (i <= rest.length()) {
                    int j = i;
                    while (j <= rest.length() && mask.isOutputAllowed(rest.substring(0, j))) {
                        ++j;
                    }
                    currentLength = j - 1;
                } else {
                    return null;
                }
            }
            int number = mask.getNumberOfLevelString(impName.substring(sumLength, sumLength + currentLength));
            result.add(number);
            sumLength += currentLength;
        }
        return result;
    }

    private static ErrorList recCheckRefIds(Object data, SchemeType scheme, ErrorList errList) {
        List<? extends DataElement> elements = LMLCheck.getLowerDataElements(data);
        if (elements == null) {
            return errList;
        }
        int i = 0;
        while (i < elements.size()) {
            String refName = elements.get(i).getRefid();
            if (refName != null) {
                ArrayList<Integer> levelList = FastImpCheck.impNameToOneLevel(refName, scheme, new ArrayList<Integer>());
                if (levelList == null) {
                    errList.addError(String.valueOf(Messages.FastImpCheck_0) + refName + Messages.FastImpCheck_1);
                } else if (LMLCheck.getSchemeByLevels(levelList, scheme) == null) {
                    errList.addError(String.valueOf(Messages.FastImpCheck_2) + refName + Messages.FastImpCheck_3);
                }
            }
            FastImpCheck.recCheckRefIds(elements.get(i), scheme, errList);
            ++i;
        }
        return errList;
    }
}

