/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.monitor.core;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ptp.core.ModelManager;
import org.eclipse.ptp.core.elements.IPResourceManager;
import org.eclipse.ptp.core.jobs.IJobStatus;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.core.util.LaunchUtils;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.remote.core.server.RemoteServerManager;
import org.eclipse.ptp.rm.core.rmsystem.IRemoteResourceManagerConfiguration;
import org.eclipse.ptp.rm.jaxb.core.IJAXBResourceManagerConfiguration;
import org.eclipse.ptp.rm.jaxb.core.data.MonitorDriverType;
import org.eclipse.ptp.rm.jaxb.core.data.MonitorType;
import org.eclipse.ptp.rm.jaxb.core.data.ResourceManagerData;
import org.eclipse.ptp.rm.jaxb.core.data.SimpleCommandType;
import org.eclipse.ptp.rm.lml.core.JobStatusData;
import org.eclipse.ptp.rm.lml.core.LMLManager;
import org.eclipse.ptp.rm.lml.core.model.IPattern;
import org.eclipse.ptp.rm.lml.da.server.core.LMLDAServer;
import org.eclipse.ptp.rm.lml.internal.core.elements.CommandType;
import org.eclipse.ptp.rm.lml.internal.core.elements.DriverType;
import org.eclipse.ptp.rm.lml.internal.core.elements.RequestType;
import org.eclipse.ptp.rm.lml.internal.core.model.Pattern;
import org.eclipse.ptp.rm.lml.monitor.LMLMonitorCorePlugin;
import org.eclipse.ptp.rm.lml.monitor.core.messages.Messages;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerMonitor;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.ui.IRMSelectionListener;
import org.eclipse.ptp.ui.PTPUIPlugin;
import org.eclipse.ptp.ui.managers.RMManager;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LMLResourceManagerMonitor
extends AbstractResourceManagerMonitor {
    private static final String USER_JOBS = "user-jobs";
    private static final int JOB_SCHEDULE_FREQUENCY = 60000;
    private static final RMListener fListener = new RMListener();
    private MonitorJob fMonitorJob = null;
    private final RMManager fRMManager = PTPUIPlugin.getDefault().getRMManager();
    private final LMLManager fLMLManager = LMLManager.getInstance();
    private static final String LAYOUT = "layout";
    private static final String LAYOUT_STRING = "layoutString";
    private static final String PATTERN_GID_ATTR = "gid";
    private static final String FILTER_TITLE_ATTR = "columnTitle";
    private static final String FILTER_TYPE_ATTR = "type";
    private static final String FILTER_RANGE_ATTR = "range";
    private static final String FILTER_RELATION_ATTR = "relation";
    private static final String FILTER_MAX_VALUE_RANGE_ATTR = "maxValueRange";
    private static final String FILTER_MIN_VALUE_RANGE_ATTR = "minValueRange";
    private static final String FILTER_RELATION_OPERATOR_ATTR = "relationOperartor";
    private static final String FILTER_RELATION_VALUE_ATTR = "relationValue";

    public LMLResourceManagerMonitor(AbstractResourceManagerConfiguration config) {
        super(config);
    }

    private RequestType getMonitorConfigurationRequestType() {
        MonitorType monitorType = this.getResourceManagerData().getMonitorData();
        RequestType request = null;
        if (monitorType != null) {
            request = new RequestType();
            for (MonitorDriverType monitorDriver : monitorType.getDriver()) {
                DriverType driver = new DriverType();
                driver.setName(monitorType.getSchedulerType());
                for (SimpleCommandType cmd : monitorDriver.getCmd()) {
                    CommandType command = new CommandType();
                    command.setName(cmd.getName());
                    command.setExec(cmd.getExec());
                    driver.getCommand().add(command);
                }
                request.getDriver().add(driver);
            }
            if (monitorType.getDriver().size() == 0) {
                DriverType driver = new DriverType();
                driver.setName(monitorType.getSchedulerType());
                request.getDriver().add(driver);
            }
        }
        return request;
    }

    private String getMonitorType() {
        MonitorType monitorType = this.getResourceManagerData().getMonitorData();
        if (monitorType != null) {
            return monitorType.getSchedulerType();
        }
        return "";
    }

    private IRemoteConnection getRemoteConnection(IProgressMonitor monitor) {
        String name;
        String id;
        IRemoteResourceManagerConfiguration conf = (IRemoteResourceManagerConfiguration)this.getMonitorConfiguration();
        if (conf.getUseDefault()) {
            id = this.getResourceManager().getControlConfiguration().getRemoteServicesId();
            name = this.getResourceManager().getControlConfiguration().getConnectionName();
        } else {
            id = this.getMonitorConfiguration().getRemoteServicesId();
            name = this.getMonitorConfiguration().getConnectionName();
        }
        IRemoteServices services = PTPRemoteCorePlugin.getDefault().getRemoteServices(id, monitor);
        if (services != null) {
            IRemoteConnectionManager connMgr = services.getConnectionManager();
            return connMgr.getConnection(name);
        }
        return null;
    }

    private ResourceManagerData getResourceManagerData() {
        return ((IJAXBResourceManagerConfiguration)this.getResourceManager().getConfiguration()).getResourceManagerData();
    }

    private JobStatusData[] reloadJobs(IMemento memento) {
        ArrayList<JobStatusData> jobs = new ArrayList<JobStatusData>();
        if (memento != null) {
            IMemento[] children;
            IMemento[] iMementoArray = children = memento.getChildren("jobId");
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento child = iMementoArray[n2];
                String[][] attrs = new String[][]{{"jobId", child.getID()}, {"remoteServicesId", this.getMonitorConfiguration().getRemoteServicesId()}, {"connectionName", this.getMonitorConfiguration().getConnectionName()}, {"controlType", child.getString("controlType")}, {"monitorType", this.getMonitorType()}, {"state", child.getString("state")}, {"stateDetail", child.getString("stateDetail")}, {"stdoutRemotePath", child.getString("stdoutRemotePath")}, {"stderrRemotePath", child.getString("stderrRemotePath")}, {"interactive", Boolean.toString(child.getBoolean("interactive"))}, {"queueName", child.getString("queueName")}, {"owner", child.getString("owner")}, {"oid", child.getString("oid")}};
                jobs.add(new JobStatusData(attrs));
                ++n2;
            }
        }
        return jobs.toArray(new JobStatusData[jobs.size()]);
    }

    private Map<String, List<IPattern>> reloadPattern(IMemento memento) {
        HashMap<String, List<IPattern>> pattern = new HashMap<String, List<IPattern>>();
        if (memento != null) {
            IMemento[] childrenPattern;
            IMemento[] iMementoArray = childrenPattern = memento.getChildren(PATTERN_GID_ATTR);
            int n = childrenPattern.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento[] childrenFilter;
                IMemento childPattern = iMementoArray[n2];
                LinkedList<Pattern> filters = new LinkedList<Pattern>();
                IMemento[] iMementoArray2 = childrenFilter = childPattern.getChildren(FILTER_TITLE_ATTR);
                int n3 = childrenFilter.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemento childFilter = iMementoArray2[n4];
                    Pattern filter = new Pattern(childFilter.getID(), childFilter.getString(FILTER_TYPE_ATTR));
                    if (childFilter.getBoolean(FILTER_RANGE_ATTR).booleanValue()) {
                        filter.setRange(childFilter.getString(FILTER_MIN_VALUE_RANGE_ATTR), childFilter.getString(FILTER_MAX_VALUE_RANGE_ATTR));
                    } else if (childFilter.getBoolean(FILTER_RELATION_ATTR).booleanValue()) {
                        filter.setRelation(childFilter.getString(FILTER_RELATION_OPERATOR_ATTR), childFilter.getString(FILTER_RELATION_VALUE_ATTR));
                    }
                    filters.add(filter);
                    ++n4;
                }
                if (filters.size() > 0) {
                    pattern.put(childPattern.getID(), filters);
                }
                ++n2;
            }
        }
        return pattern;
    }

    private void saveJob(JobStatusData job, XMLMemento memento) {
        IMemento jobMemento = memento.createChild("jobId", job.getJobId());
        jobMemento.putString("controlType", job.getControlType());
        jobMemento.putString("state", job.getState());
        jobMemento.putString("stateDetail", job.getStateDetail());
        jobMemento.putString("stdoutRemotePath", job.getOutputPath());
        jobMemento.putString("stderrRemotePath", job.getErrorPath());
        jobMemento.putBoolean("interactive", job.isInteractive());
        jobMemento.putString("queueName", job.getQueueName());
        jobMemento.putString("owner", job.getOwner());
        jobMemento.putString("oid", job.getOid());
    }

    private void savePattern(String key, List<IPattern> value, IMemento memento) {
        IMemento patternMemento = memento.createChild(PATTERN_GID_ATTR, key);
        for (IPattern filterValue : value) {
            IMemento filterMemento = patternMemento.createChild(FILTER_TITLE_ATTR, filterValue.getColumnTitle());
            filterMemento.putString(FILTER_TYPE_ATTR, filterValue.getType());
            filterMemento.putBoolean(FILTER_RANGE_ATTR, filterValue.isRange());
            filterMemento.putBoolean(FILTER_RELATION_ATTR, filterValue.isRelation());
            if (filterValue.isRange()) {
                filterMemento.putString(FILTER_MIN_VALUE_RANGE_ATTR, filterValue.getMinValueRange());
                filterMemento.putString(FILTER_MAX_VALUE_RANGE_ATTR, filterValue.getMaxValueRange());
                continue;
            }
            if (!filterValue.isRelation()) continue;
            filterMemento.putString(FILTER_RELATION_OPERATOR_ATTR, filterValue.getRelationOperator());
            filterMemento.putString(FILTER_RELATION_VALUE_ATTR, filterValue.getRelationValue());
        }
    }

    protected void doAddJob(IJobStatus status) {
        ILaunchConfiguration configuration = status.getLaunchConfiguration();
        String controlName = LaunchUtils.getTemplateName((ILaunchConfiguration)configuration);
        String[][] attrs = new String[][]{{"jobId", status.getJobId()}, {"remoteServicesId", this.getMonitorConfiguration().getRemoteServicesId()}, {"connectionName", this.getMonitorConfiguration().getConnectionName()}, {"controlType", controlName}, {"monitorType", this.getMonitorType()}, {"queueName", status.getQueueName()}, {"owner", status.getOwner()}, {"stdoutRemotePath", status.getOutputPath()}, {"stderrRemotePath", status.getErrorPath()}, {"interactive", Boolean.toString(status.isInteractive())}};
        JobStatusData data = new JobStatusData(attrs);
        data.setState(status.getState());
        data.setStateDetail(status.getStateDetail());
        this.fLMLManager.addUserJob(this.getResourceManager().getUniqueName(), status.getJobId(), data);
    }

    protected void doDispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doShutdown() throws CoreException {
        XMLMemento memento = XMLMemento.createWriteRoot((String)USER_JOBS);
        if (memento != null) {
            String qualifier = this.getResourceManager().getUniqueName();
            String layout = this.fLMLManager.getCurrentLayout(qualifier);
            JobStatusData[] jobs = this.fLMLManager.getUserJobs(qualifier);
            Map patternMap = this.fLMLManager.getCurrentPattern(qualifier);
            if (layout != null) {
                IMemento layoutMemento = memento.createChild(LAYOUT);
                layoutMemento.putString(LAYOUT_STRING, layout);
            }
            if (jobs != null && jobs.length > 0) {
                JobStatusData[] jobStatusDataArray = jobs;
                int n = jobs.length;
                int n2 = 0;
                while (n2 < n) {
                    JobStatusData status = jobStatusDataArray[n2];
                    if (!status.isRemoved()) {
                        this.saveJob(status, memento);
                    }
                    ++n2;
                }
            }
            if (patternMap != null && patternMap.keySet().size() > 0) {
                for (Map.Entry pattern : patternMap.entrySet()) {
                    this.savePattern((String)pattern.getKey(), (List)pattern.getValue(), (IMemento)memento);
                }
            }
        }
        this.fLMLManager.closeLgui(this.getResourceManager().getUniqueName());
        StringWriter writer = new StringWriter();
        if (memento != null) {
            try {
                memento.save((Writer)writer);
            }
            catch (IOException t) {
                throw CoreExceptionUtils.newException((String)t.getMessage(), (Throwable)t);
            }
        }
        ((AbstractResourceManagerConfiguration)this.getMonitorConfiguration()).putString(USER_JOBS, writer.toString());
        LMLResourceManagerMonitor lMLResourceManagerMonitor = this;
        synchronized (lMLResourceManagerMonitor) {
            if (this.fMonitorJob != null) {
                this.fMonitorJob.cancel();
                this.fMonitorJob = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStartup(IProgressMonitor monitor) throws CoreException {
        IRemoteConnection conn;
        String userJobs = ((AbstractResourceManagerConfiguration)this.getMonitorConfiguration()).getString(USER_JOBS, null);
        XMLMemento memento = null;
        if (userJobs != null) {
            memento = XMLMemento.createReadRoot((Reader)new StringReader(userJobs));
        }
        String layout = new String();
        JobStatusData[] jobs = null;
        Map<String, List<IPattern>> pattern = null;
        if (memento != null) {
            IMemento childLayout = memento.getChild(LAYOUT);
            if (childLayout != null) {
                layout = childLayout.getString(LAYOUT_STRING);
            }
            pattern = this.reloadPattern((IMemento)memento);
            jobs = this.reloadJobs((IMemento)memento);
        }
        if ((conn = this.getRemoteConnection(monitor)) == null) {
            throw new CoreException((IStatus)new Status(4, LMLMonitorCorePlugin.getUniqueIdentifier(), Messages.LMLResourceManagerMonitor_unableToOpenConnection));
        }
        if (!conn.isOpen()) {
            try {
                conn.open(monitor);
            }
            catch (RemoteConnectionException e) {
                throw new CoreException((IStatus)new Status(4, LMLMonitorCorePlugin.getUniqueIdentifier(), e.getMessage()));
            }
            if (!conn.isOpen()) {
                throw new CoreException((IStatus)new Status(4, LMLMonitorCorePlugin.getUniqueIdentifier(), Messages.LMLResourceManagerMonitor_unableToOpenConnection));
            }
        }
        this.fLMLManager.openLgui(this.getResourceManager().getUniqueName(), conn.getUsername(), this.getMonitorConfigurationRequestType(), layout, jobs, pattern);
        LMLResourceManagerMonitor lMLResourceManagerMonitor = this;
        synchronized (lMLResourceManagerMonitor) {
            if (this.fMonitorJob == null) {
                this.fMonitorJob = new MonitorJob(Messages.LMLResourceManagerMonitor_LMLMonitorJob, conn);
            }
            this.fMonitorJob.schedule();
        }
        this.fRMManager.addRMSelectionListener((IRMSelectionListener)fListener);
    }

    protected void doUpdateJob(IJobStatus status) {
        this.fLMLManager.updateUserJob(this.getResourceManager().getUniqueName(), status.getJobId(), status.getState(), status.getStateDetail());
    }

    private class MonitorJob
    extends Job {
        private final LMLDAServer fServer;

        public MonitorJob(String name, IRemoteConnection conn) {
            super(name);
            this.setSystem(true);
            this.fServer = (LMLDAServer)RemoteServerManager.getServer((String)LMLDAServer.SERVER_ID, (IRemoteConnection)conn);
            this.fServer.setWorkDir(new Path(conn.getWorkingDirectory()).append(".eclipsesettings").toString());
        }

        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                try {
                    this.fServer.startServer((IProgressMonitor)subMon.newChild(20));
                    if (!subMon.isCanceled()) {
                        this.fServer.waitForServerStart((IProgressMonitor)subMon.newChild(20));
                        if (!subMon.isCanceled()) {
                            LMLManager.getInstance().update(LMLResourceManagerMonitor.this.getResourceManager().getUniqueName(), this.fServer.getInputStream(), this.fServer.getOutputStream());
                        }
                    }
                }
                catch (Exception e) {
                    LMLResourceManagerMonitor.this.fRMManager.removeRMSelectionListener((IRMSelectionListener)fListener);
                    LMLResourceManagerMonitor.this.fireResourceManagerError(e.getLocalizedMessage());
                    Status status = new Status(4, "org.eclipse.ptp.rm.lml.monitor.core", e.getLocalizedMessage());
                    if (monitor != null) {
                        monitor.done();
                    }
                    return status;
                }
                this.fServer.waitForServerFinish((IProgressMonitor)subMon.newChild(40));
                if (!subMon.isCanceled()) {
                    this.schedule(60000L);
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    }

    private static class RMListener
    implements IRMSelectionListener {
        private RMListener() {
        }

        public void selectionChanged(ISelection selection) {
            TreePath path;
            Object segment;
            String name = null;
            if (!selection.isEmpty() && (segment = (path = ((ITreeSelection)selection).getPaths()[0]).getFirstSegment()) instanceof IPResourceManager) {
                String rmId = ((IPResourceManager)segment).getControlId();
                IResourceManager rm = ModelManager.getInstance().getResourceManagerFromUniqueName(rmId);
                if (rm != null) {
                    name = rm.getConfiguration().getUniqueName();
                }
            }
            RMSelectionJob job = new RMSelectionJob(Messages.LMLResourceManagerMonitor_RMSelectionJob, name);
            job.schedule();
        }

        public void setDefault(Object rm) {
        }
    }

    private static class RMSelectionJob
    extends Job {
        private final String fRMName;

        public RMSelectionJob(String jobName, String rmName) {
            super(jobName);
            this.setSystem(true);
            this.fRMName = rmName;
        }

        protected IStatus run(IProgressMonitor monitor) {
            LMLManager.getInstance().selectLgui(this.fRMName);
            return Status.OK_STATUS;
        }
    }
}

