/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml_jaxb.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.rm.jaxb.control.ILaunchController;
import org.eclipse.ptp.rm.jaxb.control.LaunchControllerManager;
import org.eclipse.ptp.rm.jaxb.core.data.ControlType;
import org.eclipse.ptp.rm.jaxb.core.data.ResourceManagerData;
import org.eclipse.ptp.rm.lml.core.JobStatusData;
import org.eclipse.ptp.rm.lml.internal.core.model.Row;
import org.eclipse.ptp.rm.lml.ui.views.TableView;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractStatusAction
implements IObjectActionDelegate {
    protected static final String JOB_STATUS = "get-job-status";
    protected static final String COSP = ": ";
    protected List<Row> selected;
    protected TableView view;

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection.isEmpty()) {
            action.setEnabled(false);
            return;
        }
        List list = ((IStructuredSelection)selection).toList();
        this.selected = new ArrayList<Row>();
        for (Object o : list) {
            this.selected.add((Row)o);
        }
        this.validate(action);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.view = (TableView)targetPart;
    }

    protected abstract void validate(IAction var1);

    protected static boolean operationSupported(JobStatusData status, String operation, IViewPart targetPart) {
        try {
            ResourceManagerData data;
            ILaunchController jobController = LaunchControllerManager.getInstance().getLaunchController(status.getRemoteId(), status.getConnectionName(), status.getControlType());
            if (jobController != null && (data = jobController.getConfiguration()) != null) {
                ControlType control = data.getControlData();
                if (operation.equals(JOB_STATUS)) {
                    return control.getGetJobStatus() != null;
                }
                if (operation.equals("HOLD")) {
                    return control.getHoldJob() != null;
                }
                if (operation.equals("RELEASE")) {
                    return control.getReleaseJob() != null;
                }
                if (operation.equals("RESUME")) {
                    return control.getResumeJob() != null;
                }
                if (operation.equals("SUSPEND")) {
                    return control.getSuspendJob() != null;
                }
                if (operation.equals("TERMINATE")) {
                    return control.getTerminateJob() != null;
                }
            }
        }
        catch (Throwable t) {
            PTPCorePlugin.log((Throwable)t);
        }
        return false;
    }
}

