/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rmsystem;

import org.eclipse.ptp.core.ModelManager;
import org.eclipse.ptp.rmsystem.IResourceManagerComponentConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.ResourceManagerServiceProvider;
import org.eclipse.ptp.services.core.IServiceProvider;

@Deprecated
public abstract class AbstractResourceManagerConfiguration
implements IResourceManagerConfiguration,
IResourceManagerComponentConfiguration {
    public static final String BASE = "base.";
    public static final String CONTROL = "control.";
    public static final String MONITOR = "monitor.";
    private static final String TAG_AUTOSTART = "autoStart";
    private static final String TAG_DESCRIPTION = "description";
    private static final String TAG_NAME = "name";
    private static final String TAG_CONNECTION_NAME = "connectionName";
    private static final String TAG_REMOTE_SERVICES_ID = "remoteServicesID";
    private final IServiceProvider fServiceProvider;
    private final String fNamespace;

    public AbstractResourceManagerConfiguration(String namespace, IServiceProvider provider) {
        this.fServiceProvider = provider;
        this.fNamespace = namespace;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractResourceManagerConfiguration)) {
            return false;
        }
        return this.getUniqueName().equals(((AbstractResourceManagerConfiguration)obj).getUniqueName());
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        if (adapter == IServiceProvider.class) {
            return this.fServiceProvider;
        }
        return null;
    }

    public boolean getAutoStart() {
        return this.getBoolean(BASE, TAG_AUTOSTART, false);
    }

    public boolean getBoolean(String key, boolean defaultVal) {
        return this.getBoolean(this.fNamespace, key, defaultVal);
    }

    public String getConnectionName() {
        return this.getString(TAG_CONNECTION_NAME, "");
    }

    public String getDescription() {
        return this.getString(BASE, TAG_DESCRIPTION, "");
    }

    public int getInt(String key, int defaultVal) {
        return this.getInt(this.fNamespace, key, defaultVal);
    }

    public String getName() {
        return this.getString(BASE, TAG_NAME, "");
    }

    public String getRemoteServicesId() {
        return this.getString(TAG_REMOTE_SERVICES_ID, null);
    }

    public String getResourceManagerId() {
        return this.fServiceProvider.getId();
    }

    public String getString(String key, String defaultVal) {
        return this.getString(this.fNamespace, key, defaultVal);
    }

    public String getType() {
        return this.fServiceProvider.getName();
    }

    public String getUniqueName() {
        return ((ResourceManagerServiceProvider)this.fServiceProvider).getUniqueName();
    }

    public boolean isConfigured() {
        return !this.getConnectionName().equals("") && this.getRemoteServicesId() != null;
    }

    public boolean needsDebuggerLaunchHelp() {
        return false;
    }

    public void putBoolean(String key, boolean value) {
        this.putBoolean(this.fNamespace, key, value);
    }

    public void putInt(String key, int value) {
        this.putInt(this.fNamespace, key, value);
    }

    public void putString(String key, String value) {
        this.putString(this.fNamespace, key, value);
    }

    public void setAutoStart(boolean flag) {
        this.putBoolean(BASE, TAG_AUTOSTART, flag);
    }

    public void setConnectionName(String name) {
        this.putString(TAG_CONNECTION_NAME, name);
    }

    public void setDescription(String description) {
        this.putString(BASE, TAG_DESCRIPTION, description);
    }

    public void setName(String name) {
        this.putString(BASE, TAG_NAME, name);
    }

    public void setRemoteServicesId(String id) {
        this.putString(TAG_REMOTE_SERVICES_ID, id);
    }

    public void setUniqueName(String name) {
        ModelManager.getInstance().changeResourceManagerUniqueName(this.getUniqueName(), name);
        ((ResourceManagerServiceProvider)this.fServiceProvider).setUniqueName(name);
    }

    private boolean getBoolean(String namespace, String key, boolean defaultVal) {
        return this.fServiceProvider.getBoolean(String.valueOf(namespace) + key, defaultVal);
    }

    private int getInt(String namespace, String key, int defaultVal) {
        return this.fServiceProvider.getInt(String.valueOf(namespace) + key, defaultVal);
    }

    private String getString(String namespace, String key, String defaultVal) {
        return this.fServiceProvider.getString(String.valueOf(namespace) + key, defaultVal);
    }

    private void putBoolean(String namespace, String key, boolean value) {
        this.fServiceProvider.putBoolean(String.valueOf(namespace) + key, value);
    }

    private void putInt(String namespace, String key, int value) {
        this.fServiceProvider.putInt(String.valueOf(namespace) + key, value);
    }

    private void putString(String namespace, String key, String value) {
        this.fServiceProvider.putString(String.valueOf(namespace) + key, value);
    }
}

