/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ems.core;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.ptp.ems.core.IEnvManagerConfig;

public final class EnvManagerConfigString
implements IEnvManagerConfig {
    private static final String MAGIC = "#%PTP_EMS_v1%#";
    private static final String KV_SEPARATOR = "~#%#~";
    private static final String SEPARATOR = ";";
    private static final String ENABLE_ENVCONFIG_PROPERTY_KEY = "enableEnvConfig";
    private static final String ENABLE_MANUAL_CONFIG_PROPERTY_KEY = "envEnableManualConfig";
    private static final String ENVCONFIG_MANUAL_CONFIG_TEXT_PROPERTY_KEY = "envManualConfig";
    private static final String ENVCONFIG_PROPERTY_KEY = "envConfig";
    private static final String ENVCONFIG_CONNECTION_NAME_PROPERTY_KEY = "envConfigConnectionName";
    private final Map<String, String> settings = new TreeMap<String, String>();

    public static boolean isEnvMgmtConfigString(String string) {
        return string != null && (string.equals("") || string.startsWith(MAGIC));
    }

    public EnvManagerConfigString() {
        this.settings.put(ENABLE_ENVCONFIG_PROPERTY_KEY, Boolean.FALSE.toString());
        this.settings.put(ENABLE_MANUAL_CONFIG_PROPERTY_KEY, Boolean.FALSE.toString());
        this.settings.put(ENVCONFIG_MANUAL_CONFIG_TEXT_PROPERTY_KEY, "");
        this.settings.put(ENVCONFIG_CONNECTION_NAME_PROPERTY_KEY, null);
        this.settings.put(ENVCONFIG_PROPERTY_KEY, EnvManagerConfigString.toString(Collections.<String>emptySet()));
    }

    public EnvManagerConfigString(String configuration) {
        if (configuration != null && EnvManagerConfigString.isEnvMgmtConfigString(configuration) && !configuration.equals("")) {
            String[] stringArray = this.removeMagicPrefix(configuration).split(KV_SEPARATOR);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value;
                String key;
                String kvPair = stringArray[n2];
                int index = kvPair.indexOf(61);
                if (index < 0) {
                    key = kvPair;
                    value = "";
                } else {
                    key = kvPair.substring(0, index);
                    value = kvPair.substring(index + 1);
                }
                this.settings.put(key, value);
                ++n2;
            }
        }
    }

    private String removeMagicPrefix(String configuration) {
        if (configuration.startsWith("#%PTP_EMS_v1%#~#%#~")) {
            return configuration.substring(MAGIC.length() + KV_SEPARATOR.length());
        }
        if (configuration.startsWith(MAGIC)) {
            return configuration.substring(MAGIC.length());
        }
        throw new IllegalStateException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MAGIC);
        for (String key : this.settings.keySet()) {
            sb.append(KV_SEPARATOR);
            sb.append(key);
            sb.append("=");
            String value = this.settings.get(key);
            sb.append(value == null ? "" : value);
        }
        return sb.toString();
    }

    @Override
    public void setEnvMgmtEnabled(boolean enabled) {
        this.settings.put(ENABLE_ENVCONFIG_PROPERTY_KEY, Boolean.toString(enabled));
    }

    @Override
    public boolean isEnvMgmtEnabled() {
        return Boolean.parseBoolean(this.settings.get(ENABLE_ENVCONFIG_PROPERTY_KEY));
    }

    @Override
    public void setManualConfig(boolean enabled) {
        this.settings.put(ENABLE_MANUAL_CONFIG_PROPERTY_KEY, Boolean.toString(enabled));
    }

    @Override
    public boolean isManualConfigEnabled() {
        return Boolean.parseBoolean(this.settings.get(ENABLE_MANUAL_CONFIG_PROPERTY_KEY));
    }

    @Override
    public void setManualConfigText(String manualConfigText) {
        this.settings.put(ENVCONFIG_MANUAL_CONFIG_TEXT_PROPERTY_KEY, manualConfigText.replace("\r\n", "\r").replace('\n', '\r'));
    }

    @Override
    public String getManualConfigText() {
        String result = this.settings.get(ENVCONFIG_MANUAL_CONFIG_TEXT_PROPERTY_KEY);
        return result == null ? "" : result.replace('\r', '\n');
    }

    @Override
    public void setConnectionName(String connectionName) {
        this.settings.put(ENVCONFIG_CONNECTION_NAME_PROPERTY_KEY, connectionName);
    }

    @Override
    public String getConnectionName() {
        String result = this.settings.get(ENVCONFIG_CONNECTION_NAME_PROPERTY_KEY);
        return result == null ? "" : result;
    }

    @Override
    public void setConfigElements(Set<String> selectedModules) {
        this.settings.put(ENVCONFIG_PROPERTY_KEY, EnvManagerConfigString.toString(selectedModules));
    }

    private static String toString(Set<String> set) {
        if (set == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = set.iterator();
        if (it.hasNext()) {
            sb.append(it.next());
        }
        while (it.hasNext()) {
            sb.append(SEPARATOR);
            sb.append(it.next());
        }
        return sb.toString();
    }

    @Override
    public Set<String> getConfigElements() {
        String modulesProperty = this.settings.get(ENVCONFIG_PROPERTY_KEY);
        return EnvManagerConfigString.toSet(modulesProperty);
    }

    private static Set<String> toSet(String modulesProperty) {
        if (modulesProperty == null || modulesProperty.trim().equals("")) {
            return Collections.emptySet();
        }
        return EnvManagerConfigString.toSet(modulesProperty.split(SEPARATOR));
    }

    private static Set<String> toSet(String[] array) {
        if (array == null) {
            return Collections.emptySet();
        }
        TreeSet<String> result = new TreeSet<String>();
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String module = stringArray[n2];
            result.add(module);
            ++n2;
        }
        return Collections.unmodifiableSet(result);
    }
}

