/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ems.core;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ptp.ems.core.IEnvManager;
import org.eclipse.ptp.ems.internal.core.EMSCorePlugin;
import org.eclipse.ptp.ems.internal.core.managers.NullEnvManager;
import org.eclipse.ptp.remote.core.IRemoteConnection;

public final class EnvManagerRegistry {
    public static IEnvManager getNullEnvManager() {
        return new NullEnvManager();
    }

    public static IEnvManager getEnvManager(IProgressMonitor pm, IRemoteConnection remoteConnection) {
        if (remoteConnection != null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ptp.ems.core.envmanager");
            IConfigurationElement[] iConfigurationElementArray = extensionPoint.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    IEnvManager manager = (IEnvManager)element.createExecutableExtension("class");
                    manager.configure(remoteConnection);
                    if (manager.checkForCompatibleInstallation(pm)) {
                        return manager;
                    }
                }
                catch (Exception e) {
                    EMSCorePlugin.log(e);
                }
                ++n2;
            }
        }
        return EnvManagerRegistry.getNullEnvManager();
    }

    private EnvManagerRegistry() {
        throw new UnsupportedOperationException("Instantiation prohibited");
    }
}

