/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ptp.etfw.IToolLaunchConfigurationConstants;
import org.eclipse.ptp.etfw.messages.Messages;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametricParameterTab
extends AbstractLaunchConfigurationTab
implements IToolLaunchConfigurationConstants {
    private Button useParam;
    private Text processors;
    private Text optLevels;
    private Table argTab;
    private Table varTab;
    private Button allCom;
    private Text script;
    private Button scriptBrowse;
    private boolean parallel = false;
    private final WidgetListener wl = new WidgetListener();
    private static final String weakError = Messages.ParametricParameterTab_25;
    private static final String noParError = Messages.ParametricParameterTab_26;

    private ParametricParameterTab() {
    }

    public ParametricParameterTab(boolean parallel) {
        this.parallel = parallel;
    }

    public void createControl(Composite comp) {
        ScrolledComposite sparent = new ScrolledComposite(comp, 512);
        this.setControl((Control)sparent);
        final Composite parent = new Composite((Composite)sparent, 0);
        parent.setLayout((Layout)ParametricParameterTab.createGridLayout(3, false, 0, 0));
        parent.setLayoutData((Object)ParametricParameterTab.spanGridData(768, 5));
        this.createVerticalSpacer(parent, 3);
        this.useParam = new Button(parent, 32);
        this.useParam.setText(Messages.ParametricParameterTab_EnableParametric);
        this.useParam.addSelectionListener((SelectionListener)this.wl);
        GridData fill3 = new GridData(768);
        fill3.horizontalSpan = 3;
        Label lab = new Label(parent, 258);
        lab.setLayoutData((Object)fill3);
        lab = new Label(parent, 0);
        lab.setText(Messages.ParametricParameterTab_OptLevels);
        lab.setToolTipText(Messages.ParametricParameterTab_BlankForDefaultCompWarn);
        this.optLevels = new Text(parent, 2048);
        this.optLevels.setLayoutData((Object)new GridData(768));
        this.optLevels.addModifyListener((ModifyListener)this.wl);
        lab = new Label(parent, 258);
        lab.setLayoutData((Object)fill3);
        String allComText = Messages.ParametricParameterTab_CheckedOneRunPerCombo;
        if (this.parallel) {
            lab = new Label(parent, 0);
            lab.setText(Messages.ParametricParameterTab_MPIProcesses);
            this.processors = new Text(parent, 2048);
            this.processors.setLayoutData((Object)new GridData(768));
            this.processors.addModifyListener((ModifyListener)this.wl);
            lab = new Label(parent, 258);
            lab.setLayoutData((Object)fill3);
            allComText = Messages.ParametricParameterTab_CheckToRunEachCombo;
        }
        this.allCom = new Button(parent, 32);
        this.allCom.setText(Messages.ParametricParameterTab_RunJobsForAllCombos);
        this.allCom.setToolTipText(allComText);
        this.allCom.addSelectionListener((SelectionListener)this.wl);
        lab = new Label(parent, 258);
        lab.setLayoutData((Object)fill3);
        this.argTab = this.makeArgTable(parent, Messages.ParametricParameterTab_Name, Messages.ParametricParameterTab_Values, Messages.ParametricParameterTab_AppArgs);
        lab = new Label(parent, 258);
        lab.setLayoutData((Object)fill3);
        this.varTab = this.makeArgTable(parent, Messages.ParametricParameterTab_Name, Messages.ParametricParameterTab_Values, Messages.ParametricParameterTab_EnvVars);
        lab = new Label(parent, 258);
        lab.setLayoutData((Object)fill3);
        lab = new Label(parent, 0);
        lab.setText(Messages.ParametricParameterTab_AnalysisApp);
        this.script = new Text(parent, 2048);
        this.script.setLayoutData((Object)new GridData(768));
        this.script.addModifyListener((ModifyListener)this.wl);
        this.scriptBrowse = new Button(parent, 0);
        this.scriptBrowse.setText(Messages.ParametricParameterTab_Browse);
        this.scriptBrowse.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(parent.getShell());
                fd.setText(Messages.ParametricParameterTab_SelectPerfExScript);
                String s = fd.open();
                if (s != null) {
                    ParametricParameterTab.this.script.setText(s);
                }
            }
        });
        int thisHeight = parent.computeSize((int)-1, (int)-1).y;
        sparent.setMinSize(400, thisHeight);
        sparent.setExpandHorizontal(true);
        sparent.setExpandVertical(true);
        sparent.setContent((Control)parent);
    }

    private Table makeArgTable(Composite suParent, String c1, String c2, String title) {
        Group parent = new Group(suParent, 0);
        parent.setLayout((Layout)ParametricParameterTab.createGridLayout(3, false, 0, 0));
        parent.setLayoutData((Object)ParametricParameterTab.spanGridData(768, 5));
        parent.setText(title);
        final Table argTab = new Table((Composite)parent, 2594);
        argTab.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    ParametricParameterTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        GridData tableGD = new GridData(768);
        tableGD.heightHint = 80;
        tableGD.horizontalSpan = 3;
        argTab.setLayoutData((Object)tableGD);
        GridData span2 = new GridData(768);
        span2.horizontalSpan = 2;
        TableColumn tc = new TableColumn(argTab, 0);
        tc.setText(c1);
        tc.setWidth(80);
        tc = new TableColumn(argTab, 0);
        tc.setText(c2);
        tc.setWidth(80);
        argTab.setHeaderVisible(true);
        TableEditor te = new TableEditor(argTab);
        te.horizontalAlignment = 16384;
        te.grabHorizontal = true;
        te.minimumWidth = 50;
        Label lab = new Label((Composite)parent, 0);
        lab.setText(c1);
        final Text flags = new Text((Composite)parent, 2048);
        flags.setLayoutData((Object)span2);
        lab = new Label((Composite)parent, 0);
        lab.setText(c2);
        final Text vars = new Text((Composite)parent, 2048);
        vars.setLayoutData((Object)span2);
        Button addVar = new Button((Composite)parent, 0);
        addVar.setText(Messages.ParametricParameterTab_Add);
        addVar.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TableItem it = new TableItem(argTab, 0);
                it.setText(0, flags.getText());
                it.setText(1, vars.getText());
                ParametricParameterTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button removeVar = new Button((Composite)parent, 0);
        removeVar.setText(Messages.ParametricParameterTab_Remove);
        removeVar.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (argTab.getSelectionIndices().length > 0) {
                    argTab.remove(argTab.getSelectionIndices());
                    ParametricParameterTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        new Label((Composite)parent, 0);
        return argTab;
    }

    public String getName() {
        return Messages.ParametricParameterTab_ParametricStudy;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            if (this.parallel) {
                this.processors.setText(configuration.getAttribute("processors to use in parametric study", "1"));
            }
            this.allCom.setSelection(configuration.getAttribute("use simple weak scaling in perf parametric tests", false));
            this.optLevels.setText(configuration.getAttribute("compiler optimization levels to use in parametric study", ""));
            ParametricParameterTab.setTableList(this.argTab, configuration.getAttribute("argument names use in parametric study", null), configuration.getAttribute("argument values use in parametric study", null), configuration.getAttribute("tells which para args are checked", null));
            ParametricParameterTab.setTableList(this.varTab, configuration.getAttribute("env-var names to use in parametric study", null), configuration.getAttribute("env-var values to use in parametric study", null), configuration.getAttribute("tells which para vars are checked", null));
            this.useParam.setSelection(configuration.getAttribute("use the parametric analysis system", false));
            this.script.setText(configuration.getAttribute("path to the perfexplorer script to use in parametric study", ""));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private static void setTableList(Table ta, List<String> data0, List<String> data1, List<String> checkList) {
        if (data0 == null || data1 == null) {
            return;
        }
        ta.removeAll();
        int i = 0;
        while (i < data0.size()) {
            TableItem ti = new TableItem(ta, 0);
            ti.setText(0, data0.get(i));
            ti.setText(1, data1.get(i));
            if (checkList.get(i).equals("1")) {
                ti.setChecked(true);
            }
            ++i;
        }
    }

    private static List<String> getTableList(Table table, int index) {
        TableItem[] tiA;
        ArrayList<String> l = new ArrayList<String>();
        TableItem[] tableItemArray = tiA = table.getItems();
        int n = tiA.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem it = tableItemArray[n2];
            l.add(it.getText(index));
            ++n2;
        }
        return l;
    }

    private static List<String> getTableChecks(Table table) {
        TableItem[] tiA;
        ArrayList<String> l = new ArrayList<String>();
        TableItem[] tableItemArray = tiA = table.getItems();
        int n = tiA.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem it = tableItemArray[n2];
            if (it.getChecked()) {
                l.add("1");
            } else {
                l.add("0");
            }
            ++n2;
        }
        return l;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.parallel) {
            configuration.setAttribute("processors to use in parametric study", this.processors.getText());
        }
        configuration.setAttribute("use simple weak scaling in perf parametric tests", this.allCom.getSelection());
        configuration.setAttribute("compiler optimization levels to use in parametric study", this.optLevels.getText());
        configuration.setAttribute("argument names use in parametric study", ParametricParameterTab.getTableList(this.argTab, 0));
        configuration.setAttribute("argument values use in parametric study", ParametricParameterTab.getTableList(this.argTab, 1));
        configuration.setAttribute("tells which para args are checked", ParametricParameterTab.getTableChecks(this.argTab));
        configuration.setAttribute("env-var names to use in parametric study", ParametricParameterTab.getTableList(this.varTab, 0));
        configuration.setAttribute("env-var values to use in parametric study", ParametricParameterTab.getTableList(this.varTab, 1));
        configuration.setAttribute("tells which para vars are checked", ParametricParameterTab.getTableChecks(this.varTab));
        configuration.setAttribute("use the parametric analysis system", this.useParam.getSelection());
        configuration.setAttribute("path to the perfexplorer script to use in parametric study", this.script.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        super.isValid(config);
        boolean ok = true;
        boolean all = this.allCom.getSelection();
        if (this.parallel) {
            int numProcArgs = ParametricParameterTab.getComArgs(this.processors.getText()).size();
            ok = ParametricParameterTab.checkTableCounts(this.argTab, numProcArgs, !all);
            if (!(ok &= ParametricParameterTab.checkTableCounts(this.varTab, numProcArgs, !all))) {
                this.setErrorMessage(weakError);
            }
        } else {
            ok = ParametricParameterTab.checkNoParTableCounts(this.argTab, !all);
            if (!(ok &= ParametricParameterTab.checkNoParTableCounts(this.varTab, !all))) {
                this.setErrorMessage(noParError);
            }
        }
        return ok;
    }

    private static boolean checkNoParTableCounts(Table t, boolean all) {
        TableItem[] tis = t.getItems();
        int n = -1;
        TableItem[] tableItemArray = tis;
        int n2 = tis.length;
        int n3 = 0;
        while (n3 < n2) {
            TableItem ti = tableItemArray[n3];
            if (ti.getChecked() || all) {
                if (n == -1) {
                    n = ParametricParameterTab.getComArgs(ti.getText(1)).size();
                }
                if (ParametricParameterTab.getComArgs(ti.getText(0)).size() > 1 || ParametricParameterTab.getComArgs(ti.getText(1)).size() != n) {
                    return false;
                }
            }
            ++n3;
        }
        return true;
    }

    private static boolean checkTableCounts(Table t, int n, boolean all) {
        TableItem[] tis;
        TableItem[] tableItemArray = tis = t.getItems();
        int n2 = tis.length;
        int n3 = 0;
        while (n3 < n2) {
            TableItem ti = tableItemArray[n3];
            if ((ti.getChecked() || all) && (ParametricParameterTab.getComArgs(ti.getText(0)).size() > 1 || ParametricParameterTab.getComArgs(ti.getText(1)).size() != n)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    protected static GridLayout createGridLayout(int columns, boolean isEqual, int mh, int mw) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.makeColumnsEqualWidth = isEqual;
        gridLayout.marginHeight = mh;
        gridLayout.marginWidth = mw;
        return gridLayout;
    }

    protected static GridData spanGridData(int style, int space) {
        GridData gd = null;
        gd = style == -1 ? new GridData() : new GridData(style);
        gd.horizontalSpan = space;
        return gd;
    }

    static List<String> getComArgs(String combined) {
        StringTokenizer st = new StringTokenizer(combined, ",");
        ArrayList<String> numProcesses = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            numProcesses.add(st.nextToken().trim());
        }
        return numProcesses;
    }

    static List<String> getRangeArgs(String combined) {
        ArrayList<String> numProcesses = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(combined, "-");
        if (st.countTokens() == 2) {
            String from = st.nextToken().trim();
            String to = st.nextToken().trim();
            int fromi = Integer.parseInt(from);
            int toi = Integer.parseInt(to);
            int i = fromi;
            while (i <= toi) {
                numProcesses.add(String.valueOf(i));
                ++i;
            }
        }
        return numProcesses;
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener,
    IPropertyChangeListener {
        protected WidgetListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            ParametricParameterTab.this.updateLaunchConfigurationDialog();
        }

        public void propertyChange(PropertyChangeEvent event) {
            ParametricParameterTab.this.updateLaunchConfigurationDialog();
        }

        public void modifyText(ModifyEvent evt) {
            ParametricParameterTab.this.updateLaunchConfigurationDialog();
        }
    }
}

