/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.ptp.debug.core.IPDebugConfiguration;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.launch.PTPLaunchPlugin;
import org.eclipse.ptp.launch.messages.Messages;
import org.eclipse.ptp.launch.ui.LaunchConfigurationTab;
import org.eclipse.ptp.launch.ui.LaunchImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public abstract class AbstractDebuggerTab
extends LaunchConfigurationTab {
    protected ILaunchConfigurationWorkingCopy fWorkingCopy;
    protected IPDebugConfiguration fCurrentDebugConfig;
    protected ILaunchConfigurationTab fDynamicTab;
    protected Composite fDynamicTabHolder;
    private boolean fInitDefaults;
    private Combo fDCombo;
    private boolean fIsInitializing = false;
    private boolean fPageUpdated;

    protected void setDebugConfig(IPDebugConfiguration config) {
        this.fCurrentDebugConfig = config;
    }

    protected IPDebugConfiguration getDebugConfig() {
        return this.fCurrentDebugConfig;
    }

    protected ILaunchConfigurationTab getDynamicTab() {
        return this.fDynamicTab;
    }

    protected void setDynamicTab(ILaunchConfigurationTab tab) {
        this.fDynamicTab = tab;
    }

    protected Composite getDynamicTabHolder() {
        return this.fDynamicTabHolder;
    }

    protected void setDynamicTabHolder(Composite tabHolder) {
        this.fDynamicTabHolder = tabHolder;
    }

    protected ILaunchConfigurationWorkingCopy getLaunchConfigurationWorkingCopy() {
        return this.fWorkingCopy;
    }

    public void setLaunchConfiguration(ILaunchConfiguration launchConfiguration) {
        super.setLaunchConfiguration(launchConfiguration);
        this.setLaunchConfigurationWorkingCopy(null);
    }

    protected void setLaunchConfigurationWorkingCopy(ILaunchConfigurationWorkingCopy workingCopy) {
        this.fWorkingCopy = workingCopy;
    }

    public String getErrorMessage() {
        ILaunchConfigurationTab tab = this.getDynamicTab();
        if (super.getErrorMessage() != null || tab == null) {
            return super.getErrorMessage();
        }
        return tab.getErrorMessage();
    }

    protected void handleDebuggerChanged() {
        this.loadDynamicDebugArea();
        ILaunchConfigurationWorkingCopy wc = this.getLaunchConfigurationWorkingCopy();
        if (this.getDynamicTab() == null) {
            if (wc == null && this.getLaunchConfiguration().isWorkingCopy()) {
                wc = (ILaunchConfigurationWorkingCopy)this.getLaunchConfiguration();
            }
            if (wc != null) {
                wc.setAttribute("org.eclipse.ptp.launch.DEBUGGER_ARGS", null);
            }
        } else {
            if (wc == null) {
                try {
                    if (this.getLaunchConfiguration().isWorkingCopy()) {
                        this.setLaunchConfigurationWorkingCopy((ILaunchConfigurationWorkingCopy)this.getLaunchConfiguration());
                    } else {
                        this.setLaunchConfigurationWorkingCopy(this.getLaunchConfiguration().getWorkingCopy());
                    }
                    wc = this.getLaunchConfigurationWorkingCopy();
                }
                catch (CoreException coreException) {
                    return;
                }
            }
            if (this.initDefaults()) {
                this.getDynamicTab().setDefaults(wc);
            }
            this.setInitializeDefault(false);
            this.getDynamicTab().initializeFrom((ILaunchConfiguration)wc);
        }
    }

    protected void loadDynamicDebugArea() {
        Control[] children = this.getDynamicTabHolder().getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        IPDebugConfiguration debugConfig = this.getConfigForCurrentDebugger();
        if (debugConfig == null) {
            this.setDynamicTab(null);
        } else {
            ILaunchConfigurationTab tab = null;
            try {
                tab = PTPDebugUIPlugin.getDefault().getDebuggerPage(debugConfig.getID());
            }
            catch (CoreException e) {
                PTPLaunchPlugin.errorDialog(Messages.AbstractDebuggerTab_ErrorLoadingDebuggerPage, e.getStatus());
            }
            this.setDynamicTab(tab);
        }
        this.setDebugConfig(debugConfig);
        if (this.getDynamicTab() == null) {
            return;
        }
        this.getDynamicTab().setLaunchConfigurationDialog(this.getLaunchConfigurationDialog());
        this.getDynamicTab().createControl(this.getDynamicTabHolder());
        this.getDynamicTab().getControl().setVisible(true);
        this.getDynamicTabHolder().layout(true);
    }

    public abstract void createControl(Composite var1);

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            dynamicTab.activated(workingCopy);
        }
    }

    public void initializeFrom(ILaunchConfiguration config) {
        super.initializeFrom(config);
        ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            dynamicTab.initializeFrom(config);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (this.getDebugConfig() != null) {
            config.setAttribute("org.eclipse.ptp.launch.DEBUGGER_ID", this.getDebugConfig().getID());
            ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
            if (dynamicTab == null) {
                config.setAttribute("org.eclipse.ptp.launch.DEBUGGER_ARGS", null);
            } else {
                dynamicTab.performApply(config);
            }
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        this.setLaunchConfigurationWorkingCopy(config);
        ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            dynamicTab.setDefaults(config);
            this.setInitializeDefault(false);
        }
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.getDebugConfig() == null) {
            this.setErrorMessage(Messages.AbstractDebuggerTab_No_debugger_available);
            return false;
        }
        ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            return dynamicTab.isValid(config);
        }
        return true;
    }

    public boolean canSave() {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.getDebugConfig() == null) {
            this.setErrorMessage(Messages.AbstractDebuggerTab_No_debugger_available);
            return false;
        }
        ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            return dynamicTab.canSave();
        }
        return true;
    }

    protected void setInitializeDefault(boolean init) {
        this.fInitDefaults = init;
    }

    protected boolean initDefaults() {
        return this.fInitDefaults;
    }

    public Image getImage() {
        return LaunchImages.getImage(LaunchImages.IMG_DEBUGGER_TAB);
    }

    public String getName() {
        return Messages.AbstractDebuggerTab_Debugger;
    }

    protected void createDebuggerCombo(Composite parent, int colspan) {
        Composite comboComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        comboComp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colspan;
        comboComp.setLayoutData((Object)gd);
        Label dlabel = new Label(comboComp, 0);
        dlabel.setText(Messages.Launch_common_DebuggerColon);
        this.fDCombo = new Combo(comboComp, 12);
        this.fDCombo.setLayoutData((Object)new GridData(768));
        this.fDCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (!AbstractDebuggerTab.this.isInitializing() && event.type == 13) {
                    AbstractDebuggerTab.this.setInitializeDefault(true);
                    AbstractDebuggerTab.this.updateComboFromSelection();
                }
            }
        });
    }

    protected void loadDebuggerCombo(IPDebugConfiguration[] debugConfigs, String current) {
        this.fDCombo.removeAll();
        int select = -1;
        int i = 0;
        while (i < debugConfigs.length) {
            this.fDCombo.add(debugConfigs[i].getName());
            this.fDCombo.setData(Integer.toString(i), (Object)debugConfigs[i]);
            if (debugConfigs[i].getID().equalsIgnoreCase(current)) {
                select = i;
            }
            ++i;
        }
        this.fPageUpdated = false;
        if (select != -1) {
            this.fDCombo.select(select);
        }
        if (!this.fPageUpdated) {
            this.updateComboFromSelection();
        }
        this.fPageUpdated = false;
        this.getControl().getParent().layout(true);
    }

    protected void createDebuggerGroup(Composite parent, int colspan) {
        Group debuggerGroup = new Group(parent, 16);
        debuggerGroup.setText(Messages.DebuggerTab_Debugger_Options);
        this.setDynamicTabHolder((Composite)debuggerGroup);
        GridLayout tabHolderLayout = new GridLayout();
        tabHolderLayout.marginHeight = 0;
        tabHolderLayout.marginWidth = 0;
        tabHolderLayout.numColumns = 1;
        this.getDynamicTabHolder().setLayout((Layout)tabHolderLayout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = colspan;
        this.getDynamicTabHolder().setLayoutData((Object)gd);
    }

    protected void updateComboFromSelection() {
        this.fPageUpdated = true;
        this.handleDebuggerChanged();
        this.updateLaunchConfigurationDialog();
    }

    protected boolean isInitializing() {
        return this.fIsInitializing;
    }

    protected void setInitializing(boolean isInitializing) {
        this.fIsInitializing = isInitializing;
    }

    protected IPDebugConfiguration getConfigForCurrentDebugger() {
        int selectedIndex = this.fDCombo.getSelectionIndex();
        return (IPDebugConfiguration)this.fDCombo.getData(Integer.toString(selectedIndex));
    }
}

