/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.ui.wizards;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.ui.newui.PageLayout;
import org.eclipse.cdt.ui.wizards.conversion.ConvertProjectWizardPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ptp.rdt.sync.core.BuildConfigurationManager;
import org.eclipse.ptp.rdt.sync.core.BuildScenario;
import org.eclipse.ptp.rdt.sync.core.SyncFileFilter;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.core.resources.RemoteSyncNature;
import org.eclipse.ptp.rdt.sync.core.serviceproviders.ISyncServiceProvider;
import org.eclipse.ptp.rdt.sync.core.serviceproviders.SyncBuildServiceProvider;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeParticipant;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeParticipantDescriptor;
import org.eclipse.ptp.rdt.sync.ui.RDTSyncUIPlugin;
import org.eclipse.ptp.rdt.sync.ui.SyncFileFilterPage;
import org.eclipse.ptp.rdt.sync.ui.SynchronizeParticipantRegistry;
import org.eclipse.ptp.rdt.sync.ui.messages.Messages;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.IServiceProviderDescriptor;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ConvertLocalToSyncProjectWizardPage
extends ConvertProjectWizardPage {
    private final boolean showProviderCombo = false;
    private Combo fProviderCombo;
    private Composite fProviderArea;
    private StackLayout fProviderStack;
    private Composite fConfigArea;
    private CheckboxTableViewer fConfigTable;
    private Button switchToRemoteConfigButton;
    private SyncFileFilter customFilter = null;
    private final List<Composite> fProviderControls = new ArrayList<Composite>();
    private ISynchronizeParticipantDescriptor fSelectedProvider;
    private final Map<Integer, ISynchronizeParticipantDescriptor> fComboIndexToDescriptorMap = new HashMap<Integer, ISynchronizeParticipantDescriptor>();
    protected Map<IProject, IServiceConfiguration> projectConfigs = new HashMap<IProject, IServiceConfiguration>();

    public ConvertLocalToSyncProjectWizardPage(String pageName) {
        super(pageName);
    }

    private void addProviderControl(ISynchronizeParticipantDescriptor desc) {
        Composite comp = null;
        ISynchronizeParticipant part = desc.getParticipant();
        if (part != null) {
            comp = new Composite(this.fProviderArea, 0);
            comp.setLayout((Layout)new GridLayout(1, false));
            comp.setLayoutData((Object)new GridData(4, 4, true, true));
            part.createConfigurationArea(comp, (IRunnableContext)this.getWizard().getContainer());
        }
        this.fProviderControls.add(comp);
    }

    protected void addToMainPage(Composite container) {
        Composite comp = new Composite(container, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        comp.setLayoutData((Object)gd);
        this.fProviderArea = new Group(comp, 16);
        this.fProviderStack = new StackLayout();
        this.fProviderArea.setLayout((Layout)this.fProviderStack);
        GridData providerAreaData = new GridData(4, 4, true, true);
        providerAreaData.horizontalSpan = 3;
        this.fProviderArea.setLayoutData((Object)providerAreaData);
        ISynchronizeParticipantDescriptor[] providers = SynchronizeParticipantRegistry.getDescriptors();
        int k = 0;
        while (k < providers.length) {
            this.fComboIndexToDescriptorMap.put(k, providers[k]);
            this.addProviderControl(providers[k]);
            ++k;
        }
        this.handleProviderSelected(0);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConvertLocalToSyncProjectWizardPage.this.update();
            }
        });
        Label configTableLabel = new Label(comp, 16384);
        configTableLabel.setText(Messages.ConvertLocalToSyncProjectWizardPage_2);
        this.fConfigArea = new Composite(comp, 0);
        this.fConfigArea.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.fConfigArea.setLayout((Layout)new PageLayout());
        this.fConfigTable = CheckboxTableViewer.newCheckList((Composite)this.fConfigArea, (int)2562);
        this.fConfigTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement == null) {
                    return new IConfiguration[0];
                }
                if (!$assertionsDisabled && !(inputElement instanceof IProject)) {
                    throw new AssertionError();
                }
                if (ConvertLocalToSyncProjectWizardPage.this.getCheckedElements().length != 1) {
                    return new IConfiguration[0];
                }
                IProject project = (IProject)inputElement;
                IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
                if (buildInfo == null) {
                    return new IConfiguration[0];
                }
                return buildInfo.getManagedProject().getConfigurations();
            }
        });
        this.fConfigTable.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (!$assertionsDisabled && !(element instanceof IConfiguration)) {
                    throw new AssertionError();
                }
                return ((IConfiguration)element).getName();
            }
        });
        this.switchToRemoteConfigButton = new Button(comp, 32);
        this.switchToRemoteConfigButton.setText(Messages.ConvertLocalToSyncProjectWizardPage_4);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.switchToRemoteConfigButton.setLayoutData((Object)gd);
        this.switchToRemoteConfigButton.setSelection(true);
        final Button filterButton = new Button(comp, 8);
        filterButton.setText(Messages.ConvertLocalToSyncProjectWizardPage_3);
        filterButton.setLayoutData((Object)new GridData(16384, 128, false, false, 3, 1));
        filterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SyncFileFilter tmpFilter = ConvertLocalToSyncProjectWizardPage.this.customFilter == null ? SyncManager.getDefaultFileFilter() : new SyncFileFilter(ConvertLocalToSyncProjectWizardPage.this.customFilter);
                int filterReturnCode = SyncFileFilterPage.openBlocking(tmpFilter, filterButton.getShell());
                if (filterReturnCode == 0) {
                    ConvertLocalToSyncProjectWizardPage.this.customFilter = tmpFilter;
                }
            }
        });
        this.selectAllButton.setVisible(false);
        this.deselectAllButton.setVisible(false);
    }

    protected void convertProject(IProject project, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.ConvertToSyncProjectWizardPage_convertingToSyncProject, 3);
        RemoteSyncNature.addNature((IProject)project, (IProgressMonitor)new NullProgressMonitor());
        try {
            IConfiguration[] allConfigs;
            ISynchronizeParticipant participant = this.fSelectedProvider.getParticipant();
            ServiceModelManager smm = ServiceModelManager.getInstance();
            IServiceConfiguration serviceConfig = smm.newServiceConfiguration(this.getConfigName(project.getName()));
            IService syncService = smm.getService("org.eclipse.ptp.rdt.sync.core.SyncService");
            serviceConfig.setServiceProvider(syncService, (IServiceProvider)participant.getProvider(project));
            IService buildService = smm.getService("org.eclipse.ptp.rdt.core.BuildService");
            IServiceProviderDescriptor descriptor = buildService.getProviderDescriptor("org.eclipse.ptp.rdt.sync.BuildServiceProvider");
            SyncBuildServiceProvider rbsp = (SyncBuildServiceProvider)smm.getServiceProvider(descriptor);
            if (rbsp != null) {
                IRemoteConnection remoteConnection = participant.getProvider(project).getRemoteConnection();
                rbsp.setRemoteToolsConnection(remoteConnection);
                serviceConfig.setServiceProvider(buildService, (IServiceProvider)rbsp);
            }
            smm.addConfiguration(project, serviceConfig);
            try {
                smm.saveModelConfiguration();
            }
            catch (IOException e) {
                RDTSyncUIPlugin.log(e.toString(), e);
            }
            BuildConfigurationManager bcm = BuildConfigurationManager.getInstance();
            bcm.initProject(project, serviceConfig, bcm.createLocalBuildScenario(project));
            ISyncServiceProvider provider = participant.getProvider(project);
            BuildScenario remoteBuildScenario = new BuildScenario(provider.getName(), provider.getRemoteConnection(), provider.getLocation());
            Object[] selectedConfigs = this.fConfigTable.getCheckedElements();
            HashSet<Object> selectedConfigsSet = new HashSet<Object>(Arrays.asList(selectedConfigs));
            IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
            if (buildInfo == null) {
                throw new RuntimeException("Build information for project not found. Project name: " + project.getName());
            }
            boolean switchToRemoteConfig = this.switchToRemoteConfigButton.getSelection();
            boolean defaultConfigSet = false;
            IConfiguration[] iConfigurationArray = allConfigs = buildInfo.getManagedProject().getConfigurations();
            int n = allConfigs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration config = iConfigurationArray[n2];
                if (selectedConfigsSet.contains(config)) {
                    IConfiguration remoteConfig = bcm.createConfiguration(project, (Configuration)config, remoteBuildScenario, config.getName(), null);
                    bcm.modifyConfigurationAsSyncRemote(remoteConfig);
                    if (switchToRemoteConfig && !defaultConfigSet) {
                        ManagedBuildManager.setDefaultConfiguration((IProject)project, (IConfiguration)remoteConfig);
                        defaultConfigSet = true;
                    }
                }
                bcm.modifyConfigurationAsSyncLocal(config);
                ++n2;
            }
            ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
            if (this.customFilter != null) {
                SyncManager.saveFileFilter((IProject)project, (SyncFileFilter)this.customFilter);
            }
            SyncManager.setSyncMode((IProject)project, (SyncManager.SYNC_MODE)SyncManager.SYNC_MODE.ACTIVE);
        }
        finally {
            monitor.done();
        }
    }

    public void convertProject(IProject project, IProgressMonitor monitor, String projectID) throws CoreException {
        this.convertProject(project, monitor);
    }

    public void convertProject(IProject project, String bsId, IProgressMonitor monitor) throws CoreException {
        this.convertProject(project, monitor);
    }

    public void doRun(IProgressMonitor monitor, String projectID, String bsId) throws CoreException {
        monitor.beginTask(Messages.ConvertToRemoteWizardPage_0, 2);
        super.doRun((IProgressMonitor)new SubProgressMonitor(monitor, 1), projectID, bsId);
        try {
            try {
                ServiceModelManager.getInstance().saveModelConfiguration();
            }
            catch (IOException e) {
                RDTSyncUIPlugin.log(e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected IServiceConfiguration getConfig(IProject project) {
        IServiceConfiguration config = this.projectConfigs.get(project);
        if (config == null) {
            config = ServiceModelManager.getInstance().newServiceConfiguration(project.getName());
            this.projectConfigs.put(project, config);
        }
        return config;
    }

    private String getConfigName(String candidateName) {
        Set configs = ServiceModelManager.getInstance().getConfigurations();
        HashSet<String> existingNames = new HashSet<String>();
        for (IServiceConfiguration config : configs) {
            existingNames.add(config.getName());
        }
        int i = 2;
        String newConfigName = candidateName;
        while (existingNames.contains(newConfigName)) {
            newConfigName = String.valueOf(candidateName) + " (" + i++ + ")";
        }
        return newConfigName;
    }

    public String getErrorMessage() {
        String errMsg = null;
        errMsg = super.getErrorMessage() != null ? super.getErrorMessage() : (this.fSelectedProvider == null ? Messages.ConvertToSyncProjectWizardPage_0 : (this.getCheckedElements().length != 1 ? Messages.ConvertFromRemoteCToSyncProjectWizardPage_3 : this.fSelectedProvider.getParticipant().getErrorMessage()));
        this.setPageComplete(super.validatePage() && errMsg == null);
        return errMsg;
    }

    protected String getWzDescriptionResource() {
        return "Converts a managed or unmanaged project to a synchronized project by adding a sync nature";
    }

    protected String getWzTitleResource() {
        return "Convert to a synchronized project";
    }

    private void handleProviderSelected(int index) {
        this.fProviderStack.topControl = (Control)this.fProviderControls.get(index);
        this.fSelectedProvider = this.fComboIndexToDescriptorMap.get(index);
        this.fProviderArea.layout();
        this.update();
    }

    public boolean isCandidate(IProject project) {
        boolean a = false;
        boolean b = false;
        boolean c = false;
        boolean d = false;
        a = !project.isHidden();
        try {
            b = project.hasNature("org.eclipse.cdt.core.cnature") || project.hasNature("org.eclipse.cdt.core.ccnature");
            c = !project.hasNature("org.eclipse.ptp.rdt.sync.core.remoteSyncNature");
            d = !project.hasNature("org.eclipse.ptp.rdt.core.remoteNature");
        }
        catch (CoreException e) {
            RDTSyncUIPlugin.log(e);
        }
        return a && b && c && d;
    }

    private void update() {
        this.getWizard().getContainer().updateMessage();
        if (this.getCheckedElements().length == 1 && this.fSelectedProvider != null) {
            IProject project = (IProject)this.getCheckedElements()[0];
            this.fSelectedProvider.getParticipant().setProjectName(project.getName());
            if (this.fConfigTable != null) {
                this.fConfigTable.setInput((Object)project);
                this.fConfigTable.setAllChecked(true);
            }
        } else if (this.fConfigTable != null) {
            this.fConfigTable.setInput(null);
        }
    }
}

