/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.ui.widgets;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.core.Preferences;
import org.eclipse.ptp.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.ptp.remote.ui.messages.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RemoteConnectionWidget
extends Composite {
    private static final String EMPTY_STRING = "";
    private Combo fRemoteCombo = null;
    private final Combo fConnectionCombo;
    private final Button fNewConnectionButton;
    private IRemoteServices[] fRemoteServices;
    private IRemoteConnection fSelectedConnection;
    private IRemoteServices fSelectedServices;
    private boolean fSelectionListernersEnabled = true;
    private boolean fEnabled = true;
    private final IRunnableContext fContext;
    private String[] fAttrHints;
    private String[] fAttrHintValues;
    private final ListenerList fSelectionListeners = new ListenerList();
    private final WidgetListener fWidgetListener = new WidgetListener();

    public RemoteConnectionWidget(Composite parent, int style, String title, IRunnableContext context) {
        super(parent, style);
        Label label;
        this.fContext = context;
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        RemoteConnectionWidget body = this;
        if (title != null) {
            Group group = new Group((Composite)this, 0);
            group.setText(title);
            group.setLayout((Layout)new GridLayout(1, false));
            group.setLayoutData((Object)new GridData(4, 4, true, true));
            body = group;
        }
        Composite remoteComp = new Composite((Composite)body, 0);
        GridLayout remoteLayout = new GridLayout();
        remoteLayout.numColumns = 4;
        remoteLayout.marginWidth = 0;
        remoteComp.setLayout((Layout)remoteLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 4;
        remoteComp.setLayoutData((Object)gd);
        String id = Preferences.getString((String)PTPRemoteCorePlugin.getUniqueIdentifier(), (String)"remoteServicesId");
        if (id != null) {
            this.fSelectedServices = this.getRemoteServices(id);
        }
        if (this.fSelectedServices == null) {
            this.fSelectedServices = PTPRemoteCorePlugin.getDefault().getDefaultServices();
        }
        if (id == null) {
            label = new Label(remoteComp, 0);
            label.setText(Messages.RemoteConnectionWidget_remoteServiceProvider);
            gd = new GridData();
            gd.horizontalSpan = 1;
            label.setLayoutData((Object)gd);
            this.fRemoteCombo = new Combo(remoteComp, 12);
            gd = new GridData(768);
            gd.horizontalSpan = 3;
            this.fRemoteCombo.setLayoutData((Object)gd);
            this.fRemoteCombo.addSelectionListener((SelectionListener)this.fWidgetListener);
            this.fRemoteCombo.setFocus();
        }
        label = new Label(remoteComp, 0);
        label.setText(Messages.RemoteConnectionWidget_connectionName);
        gd = new GridData();
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        this.fConnectionCombo = new Combo(remoteComp, 12);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fConnectionCombo.setLayoutData((Object)gd);
        this.fConnectionCombo.addSelectionListener((SelectionListener)this.fWidgetListener);
        if (id != null) {
            this.fConnectionCombo.setFocus();
        }
        this.fConnectionCombo.setEnabled(false);
        this.fNewConnectionButton = new Button(remoteComp, 8);
        this.fNewConnectionButton.setText(Messages.RemoteConnectionWidget_new);
        GridData data = new GridData();
        this.fNewConnectionButton.setLayoutData((Object)data);
        this.fNewConnectionButton.addSelectionListener((SelectionListener)this.fWidgetListener);
        if (this.fRemoteCombo != null) {
            this.initializeRemoteServicesCombo(null);
        }
        this.handleRemoteServiceSelected(null);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.fSelectionListeners.add((Object)listener);
    }

    public IRemoteConnection getConnection() {
        return this.fSelectedConnection;
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.fSelectionListeners.remove((Object)listener);
    }

    public void setConnection(IRemoteConnection connection) {
        this.fSelectionListernersEnabled = false;
        this.handleRemoteServiceSelected(connection);
        this.handleConnectionSelected();
        this.fSelectionListernersEnabled = true;
    }

    public void setConnection(String id, String name) {
        IRemoteConnection connection;
        IRemoteServices services = this.getRemoteServices(id);
        if (services != null && (connection = this.getRemoteConnection(services, name)) != null) {
            this.setConnection(connection);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.fRemoteCombo != null) {
            this.fRemoteCombo.setEnabled(enabled);
        }
        this.fConnectionCombo.setEnabled(enabled && this.fSelectedServices != null);
        this.fNewConnectionButton.setEnabled(enabled && this.fSelectedServices != null && this.fSelectedServices.canCreateConnections());
        this.fEnabled = enabled;
    }

    public void setHints(String[] attrHints, String[] attrHintValues) {
        this.fAttrHints = attrHints;
        this.fAttrHintValues = attrHintValues;
    }

    private IRemoteUIConnectionManager getUIConnectionManager() {
        if (this.fSelectedServices != null) {
            return PTPRemoteUIPlugin.getDefault().getRemoteUIServices(this.fSelectedServices).getUIConnectionManager();
        }
        return null;
    }

    private void notifyListeners(SelectionEvent e) {
        if (this.fSelectionListernersEnabled) {
            Object[] objectArray = this.fSelectionListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((SelectionListener)listener).widgetSelected(e);
                ++n2;
            }
        }
    }

    protected IRemoteConnection getRemoteConnection(IRemoteServices services, String name) {
        IRemoteConnectionManager manager = this.getRemoteConnectionManager(services);
        if (manager != null) {
            return manager.getConnection(name);
        }
        return null;
    }

    protected IRemoteConnectionManager getRemoteConnectionManager(IRemoteServices services) {
        if (services != null) {
            return services.getConnectionManager();
        }
        return null;
    }

    protected IRemoteServices getRemoteServices(String id) {
        if (id != null && !id.equals(EMPTY_STRING)) {
            return PTPRemoteUIPlugin.getDefault().getRemoteServices(id, this.fContext);
        }
        return null;
    }

    protected void handleConnectionSelected() {
        boolean enabled = this.fWidgetListener.isEnabled();
        this.fWidgetListener.disable();
        this.fSelectedConnection = null;
        int currentSelection = this.fConnectionCombo.getSelectionIndex();
        IRemoteConnection selectedConnection = null;
        if (currentSelection >= 0 && this.fSelectedServices != null) {
            String connectionName = this.fConnectionCombo.getItem(currentSelection);
            selectedConnection = this.getRemoteConnection(this.fSelectedServices, connectionName);
        }
        if (selectedConnection == null || this.fSelectedConnection == null || !selectedConnection.getName().equals(this.fSelectedConnection.getName())) {
            this.fSelectedConnection = selectedConnection;
            Event evt = new Event();
            evt.widget = this;
            this.notifyListeners(new SelectionEvent(evt));
        }
        this.fWidgetListener.setEnabled(enabled);
    }

    protected void handleNewRemoteConnectionSelected() {
        IRemoteConnection conn;
        if (this.getUIConnectionManager() != null && (conn = this.getUIConnectionManager().newConnection(this.getShell(), this.fAttrHints, this.fAttrHintValues)) != null) {
            this.handleRemoteServiceSelected(conn);
            this.handleConnectionSelected();
        }
    }

    protected void handleRemoteServiceSelected(IRemoteConnection conn) {
        boolean enabled = this.fWidgetListener.isEnabled();
        this.fWidgetListener.disable();
        if (this.fRemoteCombo != null) {
            if (conn != null) {
                IRemoteServices services = conn.getRemoteServices();
                if (this.fRemoteServices != null) {
                    int index = 0;
                    while (index < this.fRemoteServices.length) {
                        if (this.fRemoteServices[index].getId().equals(services.getId())) {
                            this.fRemoteCombo.select(index + 1);
                            break;
                        }
                        ++index;
                    }
                }
            }
            int selectionIndex = this.fRemoteCombo.getSelectionIndex();
            IRemoteServices selectedServices = null;
            if (this.fRemoteServices != null && this.fRemoteServices.length > 0 && selectionIndex > 0) {
                selectedServices = this.fRemoteServices[selectionIndex - 1];
            }
            if (selectedServices != null && this.fSelectedServices != null && selectedServices.getId().equals(this.fSelectedServices.getId())) {
                this.fWidgetListener.setEnabled(enabled);
                return;
            }
            this.fSelectedServices = selectedServices;
        }
        this.fConnectionCombo.removeAll();
        if (this.fSelectedServices == null) {
            this.fConnectionCombo.setEnabled(false);
            this.fNewConnectionButton.setEnabled(false);
        } else {
            this.fConnectionCombo.setEnabled(true);
            IRemoteConnectionManager connectionManager = this.fSelectedServices.getConnectionManager();
            IRemoteConnection[] connections = connectionManager.getConnections();
            Arrays.sort(connections, new Comparator<IRemoteConnection>(){

                @Override
                public int compare(IRemoteConnection c1, IRemoteConnection c2) {
                    return c1.getName().compareToIgnoreCase(c2.getName());
                }
            });
            int offset = 0;
            int selected = 0;
            if (connections.length > 1) {
                this.fConnectionCombo.add(Messages.RemoteConnectionWidget_selectConnection);
                offset = 1;
            }
            int i = 0;
            while (i < connections.length) {
                this.fConnectionCombo.add(connections[i].getName());
                if (conn != null && connections[i].getName().equals(conn.getName())) {
                    selected = i + offset;
                }
                ++i;
            }
            if (connections.length > 0) {
                this.fConnectionCombo.select(selected);
                this.handleConnectionSelected();
            }
            this.fNewConnectionButton.setEnabled(this.fSelectedServices.canCreateConnections());
        }
        this.fWidgetListener.setEnabled(enabled);
    }

    protected void initializeRemoteServicesCombo(String id) {
        boolean enabled = this.fWidgetListener.isEnabled();
        this.fWidgetListener.disable();
        this.fRemoteServices = PTPRemoteUIPlugin.getDefault().getRemoteServices(this.fContext);
        IRemoteServices defService = null;
        if (id != null) {
            defService = this.getRemoteServices(id);
        }
        Arrays.sort(this.fRemoteServices, new Comparator<IRemoteServices>(){

            @Override
            public int compare(IRemoteServices c1, IRemoteServices c2) {
                return c1.getName().compareToIgnoreCase(c2.getName());
            }
        });
        this.fRemoteCombo.removeAll();
        int offset = 0;
        int defIndex = 0;
        if (this.fRemoteServices.length > 1) {
            this.fRemoteCombo.add(Messages.RemoteConnectionWidget_selectRemoteProvider);
            offset = 1;
        }
        int i = 0;
        while (i < this.fRemoteServices.length) {
            this.fRemoteCombo.add(this.fRemoteServices[i].getName());
            if (defService != null && this.fRemoteServices[i].equals(defService)) {
                defIndex = i + offset;
            }
            ++i;
        }
        if (this.fRemoteServices.length > 0) {
            this.fRemoteCombo.select(defIndex);
        }
        this.fWidgetListener.setEnabled(enabled);
    }

    protected class WidgetListener
    implements SelectionListener {
        private boolean listenerEnabled = true;

        protected WidgetListener() {
        }

        public void disable() {
            this.setEnabled(false);
        }

        public void enable() {
            this.setEnabled(true);
        }

        public synchronized boolean isEnabled() {
            return this.listenerEnabled;
        }

        public synchronized void setEnabled(boolean enabled) {
            this.listenerEnabled = enabled;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            if (this.isEnabled()) {
                this.widgetSelected(e);
            }
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.isEnabled()) {
                Object source = e.getSource();
                if (source == RemoteConnectionWidget.this.fRemoteCombo) {
                    RemoteConnectionWidget.this.handleRemoteServiceSelected(null);
                } else if (source == RemoteConnectionWidget.this.fConnectionCombo) {
                    RemoteConnectionWidget.this.handleConnectionSelected();
                } else if (source == RemoteConnectionWidget.this.fNewConnectionButton) {
                    RemoteConnectionWidget.this.handleNewRemoteConnectionSelected();
                }
            }
        }

        protected void doWidgetDefaultSelected(SelectionEvent e) {
        }
    }
}

