/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ibm.pe.ui.widgets;

import java.util.List;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.attributes.StringSetAttributeDefinition;
import org.eclipse.ptp.rm.ibm.pe.ui.messages.Messages;
import org.eclipse.ptp.rm.ibm.pe.ui.widgets.ValidationState;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class BooleanRowWidget
implements ValidationState {
    private Label label;
    private Label nonDefaultMarker;
    private GridData gridData;
    private StringSetAttributeDefinition attrDef;
    private BooleanOption widget;
    private String defaultValue;
    private EventMonitor eventMonitor;
    private int validationState;

    public BooleanRowWidget(Composite parent, String id, StringSetAttributeDefinition def, int button_id) {
        this.attrDef = def;
        this.gridData = new GridData(768);
        this.gridData.grabExcessHorizontalSpace = false;
        this.label = new Label(parent, 0);
        this.label.setText(this.attrDef.getName());
        this.label.setLayoutData((Object)this.gridData);
        this.nonDefaultMarker = new Label(parent, 0);
        this.nonDefaultMarker.setText(" ");
        this.widget = new BooleanOption(parent, this.attrDef.getValues(), button_id);
        this.widget.setToolTipText(this.attrDef.getDescription());
        this.gridData = new GridData(768);
        this.gridData.grabExcessHorizontalSpace = true;
        this.gridData.horizontalSpan = 2;
        this.widget.setLayoutData(this.gridData);
        this.widget.setData(id);
        try {
            this.defaultValue = this.attrDef.create().getValueAsString();
        }
        catch (IllegalValueException illegalValueException) {
            this.defaultValue = "";
        }
        this.eventMonitor = new EventMonitor();
        this.widget.addSelectionListener(this.eventMonitor);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.widget.addSelectionListener(listener);
    }

    public void setEnabled(boolean state) {
        this.widget.setEnabled(state);
    }

    public void setValue(String value) {
        this.widget.setSelectedButton(value);
    }

    public String getData() {
        return this.widget.getData();
    }

    public String getValue() {
        return this.widget.getValue();
    }

    public boolean isMatchingWidget(Widget source) {
        return this.widget.isMatchingWidget(source);
    }

    public void resetValidationState() {
        this.validationState = 0;
    }

    public void setFieldInError() {
        this.validationState = 2;
    }

    public void setValidationRequired() {
        this.validationState = 1;
    }

    public boolean isValidationRequired() {
        return this.validationState == 1 || this.validationState == 2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BooleanOption {
        private String attrValue;
        private Composite group;
        private Button[] buttons;

        public BooleanOption(Composite parent, List<String> labels, int button_id) {
            if (labels.size() != 2) {
                throw new IllegalArgumentException(Messages.getString("BooleanRowWidget_2"));
            }
            this.group = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, true);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.group.setLayout((Layout)layout);
            this.buttons = new Button[2];
            this.buttons[0] = new Button(this.group, 16);
            this.buttons[0].setText(labels.get(0));
            this.buttons[0].setData("BUTTON_ID", (Object)button_id);
            this.buttons[1] = new Button(this.group, 16);
            this.buttons[1].setText(labels.get(1));
            this.buttons[1].setData("BUTTON_ID", (Object)button_id);
        }

        public void setToolTipText(String text) {
            this.group.setToolTipText(text);
        }

        public void setSelectedButton(String value) {
            if (this.buttons[0].getText().equals(value)) {
                this.buttons[0].setSelection(true);
            } else {
                this.buttons[1].setSelection(true);
            }
        }

        public String getValue() {
            if (this.buttons[0].getSelection()) {
                return this.buttons[0].getText();
            }
            return this.buttons[1].getText();
        }

        public void setLayoutData(GridData gd) {
            this.group.setLayoutData((Object)gd);
        }

        public void setEnabled(boolean state) {
            this.buttons[0].setEnabled(state);
            this.buttons[1].setEnabled(state);
        }

        public boolean isEnabled() {
            return this.buttons[0].isEnabled();
        }

        public void setData(String value) {
            this.attrValue = value;
        }

        public String getData() {
            return this.attrValue;
        }

        public void addSelectionListener(SelectionListener listener) {
            this.buttons[0].addSelectionListener(listener);
            this.buttons[1].addSelectionListener(listener);
        }

        public boolean isMatchingWidget(Widget source) {
            return source == this.buttons[0] || source == this.buttons[1];
        }
    }

    private class EventMonitor
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button selectedButton = (Button)e.getSource();
            if (selectedButton.getText().equals(BooleanRowWidget.this.defaultValue)) {
                BooleanRowWidget.this.nonDefaultMarker.setText(" ");
            } else {
                BooleanRowWidget.this.nonDefaultMarker.setText("*");
            }
        }
    }
}

